/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.gui.GuiSpinner;
import se.mickelus.tetra.items.modular.impl.holo.HoloPage;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloHeaderGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloRootBaseGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloCraftRootGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.HoloScanRootGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.system.HoloSystemRootGui;

@OnlyIn(value=Dist.CLIENT)
public class HoloGui
extends Screen {
    private static final Logger logger = LogManager.getLogger();
    private final HoloHeaderGui header;
    private final HoloRootBaseGui[] pages;
    private HoloRootBaseGui currentPage;
    private GuiElement defaultGui;
    private GuiElement spinner;
    private static HoloGui instance = null;
    private static boolean hasListener = false;

    public HoloGui() {
        super((ITextComponent)new StringTextComponent("tetra:holosphere"));
        this.field_230708_k_ = 320;
        this.field_230709_l_ = 240;
        this.defaultGui = new GuiElement(0, 0, this.field_230708_k_, this.field_230709_l_);
        this.header = new HoloHeaderGui(0, 0, this.field_230708_k_, this::changePage);
        this.defaultGui.addChild((GuiElement)this.header);
        this.pages = new HoloRootBaseGui[HoloPage.values().length];
        this.pages[0] = new HoloCraftRootGui(0, 18);
        this.defaultGui.addChild((GuiElement)this.pages[0]);
        this.pages[1] = new HoloScanRootGui(0, 18);
        this.pages[1].setVisible(false);
        this.defaultGui.addChild((GuiElement)this.pages[1]);
        this.pages[2] = new HoloSystemRootGui(0, 18);
        this.pages[2].setVisible(false);
        this.defaultGui.addChild((GuiElement)this.pages[2]);
        this.currentPage = this.pages[0];
        this.spinner = new GuiSpinner(-8, 6);
        this.spinner.setVisible(false);
        this.defaultGui.addChild(this.spinner);
        if (((Boolean)ConfigHandler.development.get()).booleanValue() && !hasListener) {
            DataManager.featureData.onReload(() -> Minecraft.func_71410_x().func_213167_f(HoloGui::onReload));
            hasListener = true;
        }
    }

    public static HoloGui getInstance() {
        if (instance == null) {
            instance = new HoloGui();
        }
        return instance;
    }

    public void onShow() {
        this.header.onShow();
        this.currentPage.animateOpen();
    }

    private void changePage(HoloPage page) {
        this.header.changePage(page);
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].setVisible(page.ordinal() == i);
        }
        this.currentPage = this.pages[page.ordinal()];
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_238651_a_(matrixStack, 0);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.defaultGui.draw(matrixStack, (this.field_230708_k_ - this.defaultGui.getWidth()) / 2, (this.field_230709_l_ - this.defaultGui.getHeight()) / 2, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY, 1.0f);
        this.renderHoveredToolTip(matrixStack, mouseX, mouseY);
    }

    protected void renderHoveredToolTip(MatrixStack matrixStack, int mouseX, int mouseY) {
        List tooltipLines = this.defaultGui.getTooltipLines();
        if (tooltipLines != null) {
            List textComponents = tooltipLines.stream().map(line -> line.replace("\\n", "\n")).flatMap(line -> Arrays.stream(line.split("\n"))).map(StringTextComponent::new).collect(Collectors.toList());
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, textComponents, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)300, (FontRenderer)this.field_230712_o_);
        }
    }

    public boolean func_231044_a_(double x, double y, int button) {
        this.defaultGui.onMouseClick((int)x, (int)y, button);
        return super.func_231044_a_(x, y, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double distance) {
        return this.defaultGui.onMouseScroll(mouseX, mouseY, distance);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (((Boolean)ConfigHandler.development.get()).booleanValue()) {
            switch (typedChar) {
                case 'r': {
                    instance = null;
                    Minecraft.func_71410_x().func_147108_a(null);
                    HoloGui gui = HoloGui.getInstance();
                    Minecraft.func_71410_x().func_147108_a((Screen)gui);
                    gui.onShow();
                    break;
                }
                case 't': {
                    this.getMinecraft().field_71439_g.func_71165_d("/reload");
                    this.spinner.setVisible(true);
                }
            }
        }
        this.currentPage.charTyped(typedChar);
        return false;
    }

    private static void onReload() {
        if (instance != null && HoloGui.instance.getMinecraft().field_71462_r == instance) {
            logger.info("Refreshing holosphere gui data");
            HoloGui.instance.spinner.setVisible(false);
            if (HoloGui.instance.currentPage != null) {
                HoloGui.instance.currentPage.onReload();
            }
        }
    }
}

