/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.LinkedList;
import net.minecraft.client.resources.I18n;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloRootBaseGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloBreadcrumbsGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloItemsGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialsGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloSchematicGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloSchematicsGui;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class HoloCraftRootGui
extends HoloRootBaseGui {
    public static final char backBinding = 'q';
    private HoloBreadcrumbsGui breadcrumbs = new HoloBreadcrumbsGui(0, 0, this.width, this::onBreadcrumbClick);
    private int depth = 0;
    private HoloItemsGui itemsView;
    private IModularItem item;
    private HoloSchematicsGui schematicsView;
    private String slot;
    private HoloSchematicGui schematicView;
    private UpgradeSchematic schematic;
    private boolean showingMaterials = false;
    private HoloMaterialsGui materialsView;

    public HoloCraftRootGui(int x, int y) {
        super(x, y);
        this.breadcrumbs.setVisible(false);
        this.addChild(this.breadcrumbs);
        this.itemsView = new HoloItemsGui(0, 70, this.width, this.height, this::onItemSelect, this::onSlotSelect, this::onMaterialsSelect);
        this.addChild(this.itemsView);
        this.schematicsView = new HoloSchematicsGui(0, 20, this.width, this.height, this::onSchematicSelect);
        this.schematicsView.setVisible(false);
        this.addChild(this.schematicsView);
        this.schematicView = new HoloSchematicGui(0, 20, this.width, this.height);
        this.schematicView.setVisible(false);
        this.addChild(this.schematicView);
        this.materialsView = new HoloMaterialsGui(0, 20, this.width, this.height);
        this.materialsView.setVisible(false);
        this.addChild(this.materialsView);
    }

    @Override
    public void charTyped(char typedChar) {
        switch (typedChar) {
            case 'q': {
                if (this.depth <= 0) break;
                this.onBreadcrumbClick(this.depth - 1);
            }
        }
    }

    private void onBreadcrumbClick(int depth) {
        switch (depth) {
            case 0: {
                this.onItemSelect(null);
                break;
            }
            case 1: {
                if (this.showingMaterials) break;
                this.onItemSelect(this.item);
                break;
            }
            case 2: {
                this.onSlotSelect(this.slot);
            }
        }
        this.depth = depth;
    }

    private void onMaterialsSelect() {
        this.item = null;
        this.itemsView.setVisible(false);
        this.slot = null;
        this.schematicsView.setVisible(false);
        this.schematic = null;
        this.schematicView.setVisible(false);
        this.showingMaterials = true;
        this.materialsView.setVisible(true);
        this.updateBreadcrumb();
    }

    private void onItemSelect(IModularItem item) {
        this.item = item;
        this.itemsView.changeItem(item);
        this.itemsView.setVisible(true);
        this.slot = null;
        this.schematicsView.setVisible(false);
        this.schematic = null;
        this.schematicView.setVisible(false);
        if (this.depth > 1) {
            this.itemsView.animateBack();
        }
        this.showingMaterials = false;
        this.materialsView.setVisible(false);
        this.updateBreadcrumb();
    }

    private void onSlotSelect(String slot) {
        this.slot = slot;
        this.schematicsView.update(this.item, slot);
        this.schematicsView.setVisible(true);
        this.itemsView.setVisible(false);
        this.schematic = null;
        this.schematicView.setVisible(false);
        this.showingMaterials = false;
        this.materialsView.setVisible(false);
        this.updateBreadcrumb();
    }

    private void onSchematicSelect(UpgradeSchematic schematic) {
        this.schematic = schematic;
        this.schematicView.update(this.item, this.slot, schematic);
        this.schematicView.setVisible(true);
        this.schematicsView.setVisible(false);
        this.itemsView.setVisible(false);
        this.showingMaterials = false;
        this.materialsView.setVisible(false);
        this.updateBreadcrumb();
    }

    private void updateBreadcrumb() {
        this.breadcrumbs.setVisible(this.item != null);
        LinkedList<String> result = new LinkedList<String>();
        if (this.item != null) {
            result.add(I18n.func_135052_a((String)"tetra.holo.craft.breadcrumb.root", (Object[])new Object[0]));
            result.add(I18n.func_135052_a((String)("tetra.holo.craft." + this.item.getItem().getRegistryName().func_110623_a()), (Object[])new Object[0]));
            if (this.slot != null) {
                result.add(this.getSlotName());
            }
            if (this.schematic != null) {
                result.add(this.schematic.getName());
            }
        } else if (this.showingMaterials) {
            result.add(I18n.func_135052_a((String)"tetra.holo.craft.breadcrumb.root", (Object[])new Object[0]));
            result.add(I18n.func_135052_a((String)"tetra.holo.craft.breadcrumb.materials", (Object[])new Object[0]));
        }
        this.depth = result.size() - 1;
        this.breadcrumbs.setVisible(result.size() > 1);
        this.breadcrumbs.setItems(result.toArray(new String[0]));
    }

    private String getSlotName() {
        if (this.item != null) {
            String[] majorKeys = this.item.getMajorModuleKeys();
            for (int i = 0; i < majorKeys.length; ++i) {
                if (!majorKeys[i].equals(this.slot)) continue;
                return this.item.getMajorModuleNames()[i];
            }
            String[] minorKeys = this.item.getMinorModuleKeys();
            for (int i = 0; i < minorKeys.length; ++i) {
                if (!minorKeys[i].equals(this.slot)) continue;
                return this.item.getMinorModuleNames()[i];
            }
        }
        return this.slot;
    }

    @Override
    public void animateOpen() {
        switch (this.depth) {
            case 0: {
                this.itemsView.animateOpenAll();
                break;
            }
            case 1: {
                if (this.showingMaterials) {
                    this.materialsView.animateOpen();
                    break;
                }
                this.itemsView.animateOpen();
                break;
            }
            case 2: {
                this.schematicsView.animateOpen();
                break;
            }
            case 3: {
                this.schematicView.animateOpen();
            }
        }
        this.breadcrumbs.animateOpen(this.depth > 1);
    }

    @Override
    public void onReload() {
        if (this.schematic != null) {
            this.schematicView.setVisible(false);
            UpgradeSchematic newSchematic = SchematicRegistry.getSchematic(this.schematic.getKey());
            this.onSchematicSelect(newSchematic);
        } else if (this.slot != null) {
            this.onSlotSelect(this.slot);
        }
        this.materialsView.reload();
    }
}

