/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.Arrays;
import java.util.function.Consumer;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.blocks.workbench.gui.GuiSchematicListItem;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.SchematicRarity;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.util.Filter;

public class HoloSchematicsGui
extends GuiElement {
    private Consumer<UpgradeSchematic> onSchematicSelect;
    private KeyframeAnimation openAnimation;
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation hideAnimation;

    public HoloSchematicsGui(int x, int y, int width, int height, Consumer<UpgradeSchematic> onSchematicSelect) {
        super(x, y, width, height);
        this.onSchematicSelect = onSchematicSelect;
        this.openAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY((float)(y - 5), (float)y)}).withDelay(120);
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY((float)y)});
        this.hideAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY((float)(y - 5))}).onStop(complete -> {
            this.isVisible = false;
        });
    }

    public void update(IModularItem item, String slot) {
        int offset = 0;
        int pageLines = 8;
        UpgradeSchematic[] schematics = (UpgradeSchematic[])Arrays.stream(SchematicRegistry.getSchematics(slot)).filter(schematic -> !schematic.isHoning()).filter(schematic -> !schematic.getRarity().equals((Object)SchematicRarity.temporary)).filter(schematic -> !schematic.getType().equals((Object)SchematicType.improvement)).filter(Filter.distinct(UpgradeSchematic::getName)).toArray(UpgradeSchematic[]::new);
        int count = schematics.length;
        this.clearChildren();
        for (int i = 0; i < count; ++i) {
            UpgradeSchematic schematic2 = schematics[i + offset];
            this.addChild((GuiElement)new GuiSchematicListItem(i / pageLines * 106, i % pageLines * 14, 103, schematic2, () -> this.onSchematicSelect.accept(schematic2)));
        }
    }

    public void animateOpen() {
        this.openAnimation.start();
    }

    protected void onShow() {
        super.onShow();
        this.hideAnimation.stop();
        this.showAnimation.start();
    }

    protected boolean onHide() {
        this.showAnimation.stop();
        this.hideAnimation.start();
        return false;
    }
}

