/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiItem;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.blocks.workbench.gui.ToolRequirementGui;
import se.mickelus.tetra.gui.GuiItemRolling;
import se.mickelus.tetra.gui.GuiSynergyIndicator;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloImprovementGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.OutcomePreview;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.properties.PropertyHelper;

public class HoloVariantDetailGui
extends GuiElement {
    private GuiString variantLabel = new GuiString(0, 0, "");
    private GuiSynergyIndicator synergyIndicator;
    private GuiString improvementsLabel;
    private GuiElement improvements;
    private GuiElement requiredTools;
    private GuiItemRolling material;
    private HoloStatsGui stats;
    private Map<ToolType, Integer> availableToolLevels;
    private KeyframeAnimation openAnimation;
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation hideAnimation;

    public HoloVariantDetailGui(int x, int y, int width) {
        super(x, y, width, 100);
        this.addChild((GuiElement)this.variantLabel);
        this.synergyIndicator = new GuiSynergyIndicator(0, -1, true);
        this.addChild(this.synergyIndicator);
        GuiStringSmall requirementsLabel = new GuiStringSmall(0, 13, I18n.func_135052_a((String)"tetra.holo.craft.requirements", (Object[])new Object[0]));
        requirementsLabel.setColor(0x7F7F7F);
        this.addChild((GuiElement)requirementsLabel);
        this.requiredTools = new GuiElement(0, 20, width, this.height);
        this.addChild(this.requiredTools);
        this.material = new GuiItemRolling(0, 20).setCountVisibility(GuiItem.CountMode.always);
        this.addChild(this.material);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.availableToolLevels = Stream.of(PropertyHelper.getPlayerToolLevels((PlayerEntity)player), PropertyHelper.getToolbeltToolLevels((PlayerEntity)player)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
        this.improvementsLabel = new GuiStringSmall(57, 13, I18n.func_135052_a((String)"tetra.holo.craft.improvements", (Object[])new Object[0]));
        this.improvementsLabel.setColor(0x7F7F7F);
        this.addChild((GuiElement)this.improvementsLabel);
        this.improvements = new GuiElement(57, 18, width, this.height);
        this.addChild(this.improvements);
        GuiStringSmall statsLabel = new GuiStringSmall(120, 13, I18n.func_135052_a((String)"tetra.holo.craft.stats", (Object[])new Object[0]));
        statsLabel.setColor(0x7F7F7F);
        this.addChild((GuiElement)statsLabel);
        this.stats = new HoloStatsGui(120, 20);
        this.addChild(this.stats);
        this.openAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY((float)(y - 4), (float)y)}).withDelay(120);
        this.showAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY((float)y)});
        this.hideAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY((float)(y - 5))}).onStop(complete -> {
            if (complete.booleanValue()) {
                this.isVisible = false;
            }
        });
    }

    public void updateVariant(OutcomePreview selectedOutcome, OutcomePreview hoveredOutcome, String slot) {
        if (selectedOutcome != null || hoveredOutcome != null) {
            OutcomePreview baseOutcome = hoveredOutcome != null ? hoveredOutcome : selectedOutcome;
            this.variantLabel.setString(I18n.func_135052_a((String)ItemModule.getName(baseOutcome.moduleKey, baseOutcome.variantKey), (Object[])new Object[0]));
            this.synergyIndicator.setX(this.variantLabel.getWidth() + 4);
            this.synergyIndicator.update(baseOutcome.itemStack, slot);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ItemStack improvementStack = baseOutcome.itemStack;
            UpgradeSchematic[] improvementSchematics = (UpgradeSchematic[])Arrays.stream(SchematicRegistry.getSchematics(slot)).filter(improvementSchematic -> SchematicType.improvement.equals((Object)improvementSchematic.getType())).filter(improvementSchematic -> improvementSchematic.isApplicableForItem(improvementStack)).filter(arg_0 -> HoloVariantDetailGui.lambda$updateVariant$3((PlayerEntity)player, improvementStack, arg_0)).toArray(UpgradeSchematic[]::new);
            this.improvementsLabel.setVisible(improvementSchematics.length > 0);
            this.improvements.setVisible(improvementSchematics.length > 0);
            if (improvementSchematics.length > 0) {
                this.improvements.clearChildren();
                for (int i = 0; i < improvementSchematics.length; ++i) {
                    this.improvements.addChild((GuiElement)new HoloImprovementGui(0, i * 18, improvementSchematics[i]));
                }
            }
            this.requiredTools.clearChildren();
            baseOutcome.tools.getLevelMap().forEach((tool, level) -> {
                ToolRequirementGui requirement = new ToolRequirementGui(20, this.requiredTools.getNumChildren() * 18, (ToolType)tool);
                requirement.updateRequirement((int)level, this.availableToolLevels.getOrDefault(tool, 0));
                this.requiredTools.addChild((GuiElement)requirement);
            });
            if (baseOutcome.materials.length > 0) {
                this.material.setItems(baseOutcome.materials);
            } else {
                this.material.setItems(new ItemStack[0]);
            }
            this.stats.update(selectedOutcome != null ? selectedOutcome.itemStack : hoveredOutcome.itemStack, baseOutcome.itemStack, null, null, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            this.show();
        } else {
            this.hide();
        }
    }

    public void animateOpen() {
        this.stats.realignBars();
        this.openAnimation.start();
    }

    public void show() {
        this.hideAnimation.stop();
        this.setVisible(true);
        this.showAnimation.start();
    }

    public void hide() {
        this.showAnimation.stop();
        this.hideAnimation.start();
    }

    private static /* synthetic */ boolean lambda$updateVariant$3(PlayerEntity player, ItemStack improvementStack, UpgradeSchematic improvementSchematic) {
        return improvementSchematic.isVisibleForPlayer(player, null, improvementStack);
    }
}

