/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import net.minecraft.client.gui.screen.Screen;
import se.mickelus.mgui.gui.GuiClickable;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiItem;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleGlyph;
import se.mickelus.tetra.gui.GuiItemRolling;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.module.schematic.OutcomePreview;

public class HoloVariantItemGui
extends GuiClickable {
    protected GuiItemRolling material;
    protected GuiTexture backdrop;
    protected OutcomePreview outcome;
    protected Consumer<OutcomePreview> onHover;
    protected Consumer<OutcomePreview> onBlur;
    protected boolean isMuted = false;

    public HoloVariantItemGui(int x, int y, int width, int height, OutcomePreview outcome, Consumer<OutcomePreview> onHover, Consumer<OutcomePreview> onBlur, Consumer<OutcomePreview> onSelect) {
        super(x, y, width, height, () -> onSelect.accept(outcome));
        this.outcome = outcome;
        this.onHover = onHover;
        this.onBlur = onBlur;
        this.material = new GuiItemRolling(-1, -1).setCountVisibility(GuiItem.CountMode.never).setItems(outcome.materials);
    }

    public HoloVariantItemGui(int x, int y, OutcomePreview outcome, Consumer<OutcomePreview> onHover, Consumer<OutcomePreview> onBlur, Consumer<OutcomePreview> onSelect) {
        this(x, y, 11, 11, outcome, onHover, onBlur, onSelect);
        this.backdrop = new GuiTexture(0, 0, 11, 11, 68, 0, GuiTextures.workbench);
        this.addChild((GuiElement)this.backdrop);
        this.addChild((GuiElement)new GuiModuleGlyph(2, 2, 8, 8, outcome.glyph).setShift(false));
    }

    public void updateSelection(OutcomePreview outcome) {
        this.isMuted = outcome != null && !this.outcome.equals(outcome);
        this.backdrop.setColor(this.isMuted ? 0x7F7F7F : 0xFFFFFF);
    }

    protected void onFocus() {
        super.onFocus();
        this.onHover.accept(this.outcome);
        this.backdrop.setColor(0xFFFFCC);
    }

    protected void onBlur() {
        super.onBlur();
        this.onBlur.accept(this.outcome);
        this.backdrop.setColor(this.isMuted ? 0x7F7F7F : 0xFFFFFF);
    }

    protected void drawChildren(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.drawChildren(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        if (Screen.func_231173_s_()) {
            this.material.draw(matrixStack, refX + this.material.getX(), refY + this.material.getY(), screenWidth, screenHeight, mouseX, mouseY, opacity);
        }
    }
}

