/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.impl.GuiHorizontalLayoutGroup;
import se.mickelus.mgui.gui.impl.GuiHorizontalScrollable;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloVariantGroupGui;
import se.mickelus.tetra.module.schematic.OutcomePreview;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class HoloVariantsGui
extends GuiElement {
    private GuiHorizontalScrollable groupsScroll;
    private GuiHorizontalLayoutGroup groups;
    private Consumer<OutcomePreview> onVariantHover;
    private Consumer<OutcomePreview> onVariantBlur;
    private Consumer<OutcomePreview> onVariantSelect;

    public HoloVariantsGui(int x, int y, int width, Consumer<OutcomePreview> onVariantHover, Consumer<OutcomePreview> onVariantBlur, Consumer<OutcomePreview> onVariantSelect) {
        super(x, y, width, 50);
        this.groupsScroll = new GuiHorizontalScrollable(0, 0, width, this.height).setGlobal(true);
        this.addChild((GuiElement)this.groupsScroll);
        this.groups = new GuiHorizontalLayoutGroup(0, 0, this.height, 12);
        this.groupsScroll.addChild((GuiElement)this.groups);
        this.onVariantHover = onVariantHover;
        this.onVariantBlur = onVariantBlur;
        this.onVariantSelect = onVariantSelect;
    }

    public void update(IModularItem item, String slot, UpgradeSchematic schematic) {
        this.groups.clearChildren();
        boolean isDevelopment = (Boolean)ConfigHandler.development.get();
        Map result = Arrays.stream(schematic.getPreviews(new ItemStack((IItemProvider)item.getItem()), slot)).filter(preview -> isDevelopment || preview.materials.length != 0).collect(Collectors.groupingBy(preview -> preview.category, LinkedHashMap::new, Collectors.toList()));
        int offset = 0;
        for (Map.Entry entry : result.entrySet()) {
            this.groups.addChild((GuiElement)new HoloVariantGroupGui(0, 0, (String)entry.getKey(), (List)entry.getValue(), offset, this.onVariantHover, this.onVariantBlur, this.onVariantSelect));
            offset += ((List)entry.getValue()).size();
        }
        this.groupsScroll.markDirty();
    }

    public void updateSelection(OutcomePreview outcome) {
        this.groups.getChildren(HoloVariantGroupGui.class).forEach(group -> group.updateSelection(outcome));
    }

    protected void onShow() {
        this.groups.getChildren(HoloVariantGroupGui.class).forEach(HoloVariantGroupGui::animateIn);
    }
}

