/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.scan;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiRoot;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerBarGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerDebugRenderer;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerSound;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;

public class ScannerOverlayGui
extends GuiRoot {
    private static final ResourceLocation tag = new ResourceLocation("tetra:scannable");
    public static ScannerOverlayGui instance;
    private ScannerBarGui scanner = new ScannerBarGui(2, 16, this.horizontalSpread);
    BlockPos upHighlight;
    BlockPos midHighlight;
    BlockPos downHighlight;
    float widthRatio = 1.0f;
    ScannerSound sound;
    private int ticks;
    private int snooze = -1;
    private static final int snoozeLength = 6000;
    boolean available;
    int horizontalSpread = 44;
    int verticalSpread = 3;
    float cooldown = 1.2f;
    int range = 32;

    public ScannerOverlayGui() {
        super(Minecraft.func_71410_x());
        this.scanner.setAttachment(GuiAttachment.topCenter);
        this.scanner.setOpacity(0.0f);
        this.scanner.setVisible(false);
        this.addChild(this.scanner);
        this.sound = new ScannerSound(this.mc);
        if (((Boolean)ConfigHandler.development.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new ScannerDebugRenderer(this));
        }
        instance = this;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void toggleSnooze() {
        if (this.isSnoozed()) {
            this.snooze = -1;
            this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_219642_eu, (float)2.0f, (float)0.3f));
        } else {
            this.snooze = this.ticks + 6000;
            this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_219642_eu, (float)1.6f, (float)0.3f));
        }
    }

    public boolean isSnoozed() {
        return this.ticks < this.snooze;
    }

    public String getStatus() {
        if (this.isSnoozed()) {
            int seconds = Math.round((float)(this.snooze - this.ticks) / 20.0f);
            if (seconds > 60) {
                return I18n.func_135052_a((String)"tetra.holo.scan.snoozed", (Object[])new Object[]{String.format("%02d", seconds / 60), String.format("%02d", seconds % 60)});
            }
            return I18n.func_135052_a((String)"tetra.holo.scan.snoozed", (Object[])new Object[]{String.format("%02d", seconds / 60), String.format("%02d", seconds % 60)});
        }
        return I18n.func_135052_a((String)"tetra.holo.scan.active", (Object[])new Object[0]);
    }

    private void updateStats() {
        ItemStack itemStack = Stream.of(this.mc.field_71439_g.field_71071_by.field_184439_c.stream(), this.mc.field_71439_g.field_71071_by.field_70462_a.stream(), ToolbeltHelper.getToolbeltItems((PlayerEntity)this.mc.field_71439_g).stream()).flatMap(Function.identity()).filter(stack -> stack.func_77973_b() instanceof ModularHolosphereItem).findFirst().orElse(ItemStack.field_190927_a);
        if (!itemStack.func_190926_b()) {
            ModularHolosphereItem item = (ModularHolosphereItem)itemStack.func_77973_b();
            this.horizontalSpread = 2 * item.getEffectLevel(itemStack, ItemEffect.scannerHorizontalSpread);
            this.verticalSpread = item.getEffectLevel(itemStack, ItemEffect.scannerVerticalSpread);
            this.range = item.getEffectLevel(itemStack, ItemEffect.scannerRange);
            this.cooldown = Math.max((float)item.getCooldownBase(itemStack), 1.0f);
            this.scanner.setHorizontalSpread(this.horizontalSpread);
            this.available = this.range > 0;
        } else {
            this.available = false;
        }
    }

    private void updateGuiVisibility() {
        int scannerRange = Stream.of(this.mc.field_71439_g.func_184614_ca(), this.mc.field_71439_g.func_184592_cb()).filter(stack -> stack.func_77973_b() instanceof ModularHolosphereItem).map(stack -> ((IModularItem)stack.func_77973_b()).getEffectLevel((ItemStack)stack, ItemEffect.scannerRange)).findFirst().orElse(0);
        if (!this.scanner.isVisible() && scannerRange > 0) {
            this.updateStats();
        }
        if (scannerRange > 0) {
            this.scanner.show();
        } else {
            this.scanner.hide();
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.mc.func_147118_V().func_147683_b((ISound)this.sound);
        this.sound = new ScannerSound(this.mc);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.mc.func_147118_V().func_147683_b((ISound)this.sound);
        this.sound = new ScannerSound(this.mc);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        int offset;
        ClientWorld world = this.mc.field_71441_e;
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (world == null || player == null || TickEvent.Phase.START != event.phase) {
            return;
        }
        this.updateGuiVisibility();
        ++this.ticks;
        if (this.ticks % 200 == 0) {
            this.updateStats();
        }
        if (this.available && this.ticks % 20 == 0) {
            if (this.isSnoozed()) {
                this.scanner.setStatus(this.getStatus());
            } else {
                this.scanner.setStatus(null);
            }
        }
        if (this.available && this.ticks % 2 == 0 && !this.isSnoozed() && (offset = this.ticks / 2 % (int)((float)(this.horizontalSpread * 2) * this.cooldown)) < this.horizontalSpread * 2) {
            int yawOffset = (int)((double)(-this.horizontalSpread + offset) * ScannerBarGui.getDegreesPerUnit());
            if (offset % 2 == 0) {
                if (this.verticalSpread > 0) {
                    this.upHighlight = IntStream.range(0, this.verticalSpread).map(i -> i * -5 - 25).mapToObj(arg_0 -> this.lambda$onClientTick$4((PlayerEntity)player, (World)world, yawOffset, arg_0)).filter(Objects::nonNull).findAny().orElse(null);
                    this.scanner.highlightUp(offset / 2, this.upHighlight != null);
                    if (this.upHighlight != null) {
                        this.sound.activate();
                    }
                    this.downHighlight = IntStream.range(0, this.verticalSpread).map(i -> i * 5 + 25).mapToObj(arg_0 -> this.lambda$onClientTick$6((PlayerEntity)player, (World)world, yawOffset, arg_0)).filter(Objects::nonNull).findAny().orElse(null);
                    this.scanner.highlightDown(offset / 2, this.downHighlight != null);
                    if (this.downHighlight != null) {
                        this.sound.activate();
                    }
                }
            } else if (offset / 2 < this.horizontalSpread - 1) {
                this.midHighlight = IntStream.range(-1, 2).map(i -> i * 10).mapToObj(arg_0 -> this.lambda$onClientTick$8((PlayerEntity)player, (World)world, yawOffset, arg_0)).filter(Objects::nonNull).findAny().orElse(null);
                this.scanner.highlightMid(offset / 2, this.midHighlight != null);
                if (this.midHighlight != null) {
                    this.sound.activate();
                }
            }
        }
    }

    @Nullable
    private BlockPos getPositions(PlayerEntity player, World world, int pitchOffset, int yawOffset) {
        Vector3d eyePosition = player.func_174824_e(0.0f);
        Vector3d lookVector = this.getVectorForRotation(player.func_195050_f(1.0f) + (float)pitchOffset, player.func_195046_g(1.0f) + (float)yawOffset);
        Vector3d endVector = eyePosition.func_72441_c(lookVector.field_72450_a * (double)this.range, lookVector.field_72448_b * (double)this.range, lookVector.field_72449_c * (double)this.range);
        return (BlockPos)IBlockReader.func_217300_a((RayTraceContext)new RayTraceContext(eyePosition, endVector, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player), (ctx, blockPos) -> {
            BlockState blockState = world.func_180495_p(blockPos);
            if (blockState.func_177230_c().getTags().contains(tag)) {
                return blockPos.func_185334_h();
            }
            return null;
        }, ctx -> null);
    }

    private Vector3d getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vector3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            this.draw();
        }
    }

    public void draw() {
        if (this.isVisible()) {
            MainWindow window = this.mc.func_228018_at_();
            this.width = window.func_198107_o();
            this.height = window.func_198087_p();
            int mouseX = (int)(this.mc.field_71417_B.func_198024_e() * (double)this.width / (double)window.func_198105_m());
            int mouseY = (int)(this.mc.field_71417_B.func_198026_f() * (double)this.height / (double)window.func_198083_n());
            this.drawChildren(new MatrixStack(), 0, 0, this.width, this.height, mouseX, mouseY, 1.0f);
            this.widthRatio = (float)this.scanner.getWidth() * 1.0f / (float)this.width;
        }
    }

    private /* synthetic */ BlockPos lambda$onClientTick$8(PlayerEntity player, World world, int yawOffset, int pitch) {
        return this.getPositions(player, world, pitch, yawOffset);
    }

    private /* synthetic */ BlockPos lambda$onClientTick$6(PlayerEntity player, World world, int yawOffset, int pitch) {
        return this.getPositions(player, world, pitch, yawOffset);
    }

    private /* synthetic */ BlockPos lambda$onClientTick$4(PlayerEntity player, World world, int yawOffset, int pitch) {
        return this.getPositions(player, world, pitch, yawOffset);
    }
}

