/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.EquipToolbeltItemPacket;
import se.mickelus.tetra.items.modular.impl.toolbelt.OpenToolbeltItemPacket;
import se.mickelus.tetra.items.modular.impl.toolbelt.OverlayToolbelt;
import se.mickelus.tetra.items.modular.impl.toolbelt.SlotType;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltContainer;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.booster.JumpHandlerBooster;
import se.mickelus.tetra.items.modular.impl.toolbelt.booster.OverlayBooster;
import se.mickelus.tetra.items.modular.impl.toolbelt.booster.TickHandlerBooster;
import se.mickelus.tetra.items.modular.impl.toolbelt.booster.UpdateBoosterPacket;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.ToolbeltGui;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.suspend.JumpHandlerSuspend;
import se.mickelus.tetra.items.modular.impl.toolbelt.suspend.ToggleSuspendPacket;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.network.PacketHandler;

public class ModularToolbeltItem
extends ModularItem
implements INamedContainerProvider {
    public static final String unlocalizedName = "modular_toolbelt";
    public static final String slot1Key = "toolbelt/slot1";
    public static final String slot2Key = "toolbelt/slot2";
    public static final String slot3Key = "toolbelt/slot3";
    public static final String beltKey = "toolbelt/belt";
    public static final String slot1Suffix = "_slot1";
    public static final String slot2Suffix = "_slot2";
    public static final String slot3Suffix = "_slot3";
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(-14, 18, 4, 0, 4, 18);
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(-13, 0);
    @ObjectHolder(value="tetra:modular_toolbelt")
    public static ModularToolbeltItem instance;
    @ObjectHolder(value="tetra:modular_toolbelt")
    public static ContainerType<ToolbeltContainer> containerType;

    public ModularToolbeltItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)TetraItemGroup.instance).func_234689_a_());
        this.canHone = false;
        this.setRegistryName(unlocalizedName);
        this.majorModuleKeys = new String[]{slot1Key, slot2Key, slot3Key};
        this.minorModuleKeys = new String[]{beltKey};
        this.requiredModules = new String[]{beltKey};
    }

    @Override
    public void init(PacketHandler packetHandler) {
        packetHandler.registerPacket(EquipToolbeltItemPacket.class, EquipToolbeltItemPacket::new);
        packetHandler.registerPacket(OpenToolbeltItemPacket.class, OpenToolbeltItemPacket::new);
        packetHandler.registerPacket(UpdateBoosterPacket.class, UpdateBoosterPacket::new);
        packetHandler.registerPacket(ToggleSuspendPacket.class, ToggleSuspendPacket::new);
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerBooster());
        ToolbeltInventory.initializePredicates();
        RemoveSchematic.registerRemoveSchematics(this);
        DataManager.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("toolbelt/");
        });
    }

    @Override
    public void clientInit() {
        super.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new JumpHandlerBooster(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new JumpHandlerSuspend(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new OverlayToolbelt(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new OverlayBooster(Minecraft.func_71410_x()));
        ScreenManager.func_216911_a(containerType, ToolbeltGui::new);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.createStack("belt/rope"));
            items.add((Object)this.createStack("belt/inlaid"));
        }
    }

    private ItemStack createStack(String beltMaterial) {
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        IModularItem.putModuleInSlot(itemStack, beltKey, beltKey, "toolbelt/belt_material", beltMaterial);
        IModularItem.putModuleInSlot(itemStack, slot1Key, "toolbelt/strap_slot1", "toolbelt/strap_slot1_material", "strap1/leather");
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        ItemStack itemStack = player.func_184614_ca();
        if (!this.equals(itemStack.func_77973_b())) {
            itemStack = player.func_184592_cb();
        }
        if (!this.equals(itemStack.func_77973_b())) {
            itemStack = ToolbeltHelper.findToolbelt(player);
        }
        return new ToolbeltContainer(windowId, (IInventory)inventory, itemStack, player);
    }

    public int getNumSlots(ItemStack itemStack, SlotType slotType) {
        return this.getAllModules(itemStack).stream().map(module -> module.getEffectLevel(itemStack, slotType.effect)).reduce(0, Integer::sum);
    }

    public List<Collection<ItemEffect>> getSlotEffects(ItemStack itemStack, SlotType slotType) {
        return this.getAllModules(itemStack).stream().map(module -> module.getEffectData(itemStack)).filter(Objects::nonNull).filter(effects -> effects.contains(slotType.effect)).map(effects -> {
            Map effectLevels = effects.getLevelMap();
            int slotCount = effectLevels.get(slotType.effect);
            ArrayList<Collection> result = new ArrayList<Collection>(slotCount);
            int i = 0;
            while (i < slotCount) {
                int index = i++;
                result.add(effectLevels.entrySet().stream().filter(entry -> !((ItemEffect)entry.getKey()).equals(slotType.effect)).filter(entry -> (Integer)entry.getValue() > index).map(Map.Entry::getKey).collect(Collectors.toList()));
            }
            return result;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }
}

