/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.inventory;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.ItemPredicateComposite;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.SlotType;

public class ToolbeltInventory
implements IInventory {
    protected static final String slotKey = "slot";
    protected ItemStack toolbeltItemStack;
    protected SlotType inventoryType;
    protected final String inventoryKey;
    protected NonNullList<ItemStack> inventoryContents;
    protected int numSlots = 0;
    protected int maxSize = 0;
    ItemPredicate predicate = ItemPredicate.field_192495_a;
    public static ItemPredicate potionPredicate = ItemPredicate.field_192495_a;
    public static ItemPredicate quickPredicate = ItemPredicate.field_192495_a;
    public static ItemPredicate quiverPredicate = ItemPredicate.field_192495_a;
    public static ItemPredicate storagePredicate = ItemPredicate.field_192495_a;

    public ToolbeltInventory(String inventoryKey, ItemStack stack, int maxSize, SlotType inventoryType) {
        this.inventoryKey = inventoryKey;
        this.toolbeltItemStack = stack;
        this.inventoryType = inventoryType;
        this.maxSize = maxSize;
        this.inventoryContents = NonNullList.func_191197_a((int)maxSize, (Object)ItemStack.field_190927_a);
    }

    public static void initializePredicates() {
        DataManager.predicateData.onReload(() -> {
            potionPredicate = ToolbeltInventory.getPredicate("potion");
            quickPredicate = ToolbeltInventory.getPredicate("quick");
            quiverPredicate = ToolbeltInventory.getPredicate("quiver");
            storagePredicate = ToolbeltInventory.getPredicate("storage");
        });
    }

    private static ItemPredicate getPredicate(String inventory) {
        ItemPredicate[] predicates = (ItemPredicate[])Arrays.stream(DataManager.predicateData.getData(new ResourceLocation("tetra", String.format("toolbelt/%s", inventory)))).filter(Objects::nonNull).toArray(ItemPredicate[]::new);
        if (predicates.length > 0) {
            return new ItemPredicateComposite(predicates);
        }
        return ItemPredicate.field_192495_a;
    }

    public void readFromNBT(CompoundNBT compound) {
        ListNBT items = compound.func_150295_c(this.inventoryKey, 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundNBT itemTag = items.func_150305_b(i);
            int slot = itemTag.func_74771_c(slotKey) & 0xFF;
            if (0 > slot || slot >= this.maxSize) continue;
            this.inventoryContents.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTag));
        }
    }

    public void writeToNBT(CompoundNBT tagcompound) {
        ListNBT items = new ListNBT();
        for (int i = 0; i < this.maxSize; ++i) {
            if (this.func_70301_a(i) == null) continue;
            CompoundNBT compound = new CompoundNBT();
            this.func_70301_a(i).func_77955_b(compound);
            compound.func_74774_a(slotKey, (byte)i);
            items.add((Object)compound);
        }
        tagcompound.func_218657_a(this.inventoryKey, (INBT)items);
    }

    public int func_70302_i_() {
        return this.numSlots;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventoryContents, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemStack = (ItemStack)this.inventoryContents.get(index);
        if (itemStack.func_190926_b()) {
            return itemStack;
        }
        this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
        return itemStack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190916_E() != 0) continue;
            this.inventoryContents.set(i, (Object)ItemStack.field_190927_a);
        }
        this.writeToNBT(this.toolbeltItemStack.func_196082_o());
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(stack);
    }

    public void func_174888_l() {
        this.inventoryContents.clear();
    }

    public ItemStack takeItemStack(int index) {
        ItemStack itemStack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return itemStack;
    }

    public void emptyOverflowSlots(PlayerEntity player) {
        for (int i = this.func_70302_i_(); i < this.maxSize; ++i) {
            this.moveStackToPlayer(this.func_70304_b(i), player);
        }
        this.func_70296_d();
    }

    protected void moveStackToPlayer(ItemStack itemStack, PlayerEntity player) {
        if (!itemStack.func_190926_b() && !player.field_71071_by.func_70441_a(itemStack)) {
            player.func_71019_a(itemStack, false);
        }
    }

    public boolean isItemValid(ItemStack itemStack) {
        return !ModularToolbeltItem.instance.equals(itemStack.func_77973_b()) && this.predicate.func_192493_a(itemStack);
    }

    public boolean storeItemInInventory(ItemStack itemStack) {
        int i;
        if (!this.isItemValid(itemStack)) {
            return false;
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack storedStack = this.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)storedStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)storedStack) || storedStack.func_190916_E() >= storedStack.func_77976_d()) continue;
            int moveCount = Math.min(itemStack.func_190916_E(), storedStack.func_77976_d() - storedStack.func_190916_E());
            storedStack.func_190917_f(moveCount);
            this.func_70299_a(i, storedStack);
            itemStack.func_190918_g(moveCount);
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.func_70299_a(i, itemStack);
            return true;
        }
        return false;
    }

    public int getFirstIndexForItem(Item item) {
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).func_190926_b() || !((ItemStack)this.inventoryContents.get(i)).func_77973_b().equals(item)) continue;
            return i;
        }
        return -1;
    }

    public List<Collection<ItemEffect>> getSlotEffects() {
        return ModularToolbeltItem.instance.getSlotEffects(this.toolbeltItemStack, this.inventoryType);
    }
}

