/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ModuleRegistry;
import se.mickelus.tetra.module.ReplacementDefinition;
import se.mickelus.tetra.module.data.EnchantmentMapping;

public class ItemUpgradeRegistry {
    private static final Logger logger = LogManager.getLogger();
    public static ItemUpgradeRegistry instance;
    private List<BiFunction<ItemStack, ItemStack, ItemStack>> replacementHooks;
    private List<ReplacementDefinition> replacementDefinitions;

    public ItemUpgradeRegistry() {
        instance = this;
        this.replacementHooks = new ArrayList<BiFunction<ItemStack, ItemStack, ItemStack>>();
        this.replacementDefinitions = Collections.emptyList();
        DataManager.replacementData.onReload(() -> {
            this.replacementDefinitions = DataManager.replacementData.getData().values().stream().flatMap(Arrays::stream).filter(replacementDefinition -> replacementDefinition.predicate != null).collect(Collectors.toList());
        });
    }

    public void registerReplacementHook(BiFunction<ItemStack, ItemStack, ItemStack> hook) {
        this.replacementHooks.add(hook);
    }

    public ItemStack getReplacement(ItemStack itemStack) {
        for (ReplacementDefinition replacementDefinition : this.replacementDefinitions) {
            if (!replacementDefinition.predicate.func_192493_a(itemStack)) continue;
            ItemStack replacementStack = replacementDefinition.itemStack.func_77946_l();
            replacementStack.func_196085_b(itemStack.func_77952_i());
            this.transferEnchantments(itemStack, replacementStack);
            for (BiFunction<ItemStack, ItemStack, ItemStack> hook : this.replacementHooks) {
                replacementStack = hook.apply(itemStack, replacementStack);
            }
            return replacementStack;
        }
        return ItemStack.field_190927_a;
    }

    private void transferEnchantments(ItemStack sourceStack, ItemStack modularStack) {
        if (modularStack.func_77973_b() instanceof IModularItem) {
            IModularItem item = (IModularItem)modularStack.func_77973_b();
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)sourceStack);
            for (Map.Entry entry : enchantments.entrySet()) {
                ItemUpgradeRegistry.applyEnchantment(item, modularStack, (Enchantment)entry.getKey(), (Integer)entry.getValue());
            }
        }
    }

    public static void applyEnchantment(IModularItem item, ItemStack itemStack, Enchantment enchantment, int enchantmentLevel) {
        block0: for (EnchantmentMapping mapping : instance.getEnchantmentMappings(enchantment)) {
            float level;
            ItemModuleMajor[] modules = (ItemModuleMajor[])Arrays.stream(item.getMajorModules(itemStack)).filter(module -> module.acceptsImprovement(mapping.improvement)).toArray(ItemModuleMajor[]::new);
            if (modules.length <= 0) continue;
            if (Enchantments.field_185305_q.equals(enchantment)) {
                level = 1.0f * (float)enchantmentLevel / mapping.multiplier;
                for (ItemModuleMajor module2 : modules) {
                    if (!module2.acceptsImprovementLevel(mapping.improvement, (int)level)) continue;
                    module2.addImprovement(itemStack, mapping.improvement, (int)level);
                    continue block0;
                }
                continue;
            }
            level = 1.0f * (float)enchantmentLevel / (float)modules.length / mapping.multiplier;
            for (int i = 0; i < modules.length; ++i) {
                if (i == 0) {
                    if (!modules[i].acceptsImprovementLevel(mapping.improvement, (int)Math.ceil(level))) continue;
                    modules[i].addImprovement(itemStack, mapping.improvement, (int)Math.ceil(level));
                    continue;
                }
                if (!modules[i].acceptsImprovementLevel(mapping.improvement, (int)level)) continue;
                modules[i].addImprovement(itemStack, mapping.improvement, (int)level);
            }
        }
    }

    public EnchantmentMapping[] getEnchantmentMappings(String improvement) {
        return (EnchantmentMapping[])DataManager.enchantmentData.getData().values().stream().flatMap(Arrays::stream).filter(mapping -> mapping.enchantment != null).filter(mapping -> improvement.equals(mapping.improvement)).filter(mapping -> mapping.apply).toArray(EnchantmentMapping[]::new);
    }

    public EnchantmentMapping[] getEnchantmentMappings(Enchantment enchantment) {
        return (EnchantmentMapping[])DataManager.enchantmentData.getData().values().stream().flatMap(Arrays::stream).filter(mapping -> mapping.enchantment != null).filter(mapping -> enchantment.equals(mapping.enchantment)).filter(mapping -> mapping.extract).toArray(EnchantmentMapping[]::new);
    }

    public ItemModule getModule(String key) {
        return ModuleRegistry.instance.getModule(new ResourceLocation("tetra", key));
    }

    public Collection<ItemModule> getAllModules() {
        return ModuleRegistry.instance.getAllModules();
    }
}

