/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.data;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.MaterialData;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.data.UniqueVariantData;
import se.mickelus.tetra.module.data.VariantData;
import se.mickelus.tetra.properties.AttributeHelper;

public class MaterialVariantData
extends VariantData {
    public ResourceLocation[] materials = new ResourceLocation[0];
    public MaterialMultiplier extract = new MaterialMultiplier();

    public VariantData combine(MaterialData material) {
        UniqueVariantData result = new UniqueVariantData();
        result.key = this.key + material.key;
        if (material.category != null) {
            result.category = material.category;
        }
        result.attributes = AttributeHelper.collapseRound(AttributeHelper.merge(Arrays.asList(this.attributes, AttributeHelper.multiplyModifiers(this.extract.primaryAttributes, material.primary.floatValue()), AttributeHelper.multiplyModifiers(this.extract.secondaryAttributes, material.secondary.floatValue()), AttributeHelper.multiplyModifiers(this.extract.tertiaryAttributes, material.tertiary.floatValue()))));
        result.durability = Math.round((float)this.durability + Optional.ofNullable(this.extract.durability).map(extracted -> Float.valueOf(extracted.floatValue() * material.durability)).orElse(Float.valueOf(0.0f)).floatValue());
        result.durabilityMultiplier = this.durabilityMultiplier + Optional.ofNullable(this.extract.durabilityMultiplier).map(extracted -> Float.valueOf(extracted.floatValue() * material.durability)).orElse(Float.valueOf(0.0f)).floatValue();
        result.integrity = this.integrity + Optional.ofNullable(this.extract.integrity).map(extracted -> Float.valueOf(extracted.floatValue() * (extracted.floatValue() > 0.0f ? material.integrityGain : material.integrityCost))).map(Math::round).orElse(0);
        result.magicCapacity = Math.round((float)this.magicCapacity + Optional.ofNullable(this.extract.magicCapacity).map(extracted -> Float.valueOf(extracted.floatValue() * (float)material.magicCapacity)).orElse(Float.valueOf(0.0f)).floatValue());
        result.effects = EffectData.merge(Arrays.asList(this.effects, material.effects, EffectData.multiply(this.extract.primaryEffects, material.primary.floatValue(), material.primary.floatValue()), EffectData.multiply(this.extract.secondaryEffects, material.secondary.floatValue(), material.secondary.floatValue()), EffectData.multiply(this.extract.tertiaryEffects, material.tertiary.floatValue(), material.tertiary.floatValue())));
        result.tools = ToolData.merge(Arrays.asList(this.tools, ToolData.multiply(this.extract.tools, material.toolLevel, material.toolEfficiency)));
        result.glyph = Optional.ofNullable(this.extract.glyph).map(glyph -> new GlyphData(glyph.textureLocation, glyph.textureX, glyph.textureY, material.tints.glyph)).orElse(this.glyph);
        result.models = (ModuleModel[])Stream.concat(Arrays.stream(this.models), Arrays.stream(this.extract.models).map(model -> new ModuleModel(model.type, this.combineModelLocation(model.location, material), material.tints.texture))).toArray(ModuleModel[]::new);
        return result;
    }

    private ResourceLocation combineModelLocation(ResourceLocation modelLocation, MaterialData material) {
        if (material.textureOverride) {
            return this.appendString(modelLocation, material.textures[0]);
        }
        List<String> availableTextures = Arrays.asList(this.extract.availableTextures);
        return Arrays.stream(material.textures).filter(availableTextures::contains).findFirst().map(texture -> this.appendString(modelLocation, (String)texture)).orElseGet(() -> this.appendString(modelLocation, (String)availableTextures.get(0)));
    }

    private ResourceLocation appendString(ResourceLocation resourceLocation, String string) {
        return new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + string);
    }

    public static class MaterialMultiplier {
        public Multimap<Attribute, AttributeModifier> primaryAttributes;
        public Multimap<Attribute, AttributeModifier> secondaryAttributes;
        public Multimap<Attribute, AttributeModifier> tertiaryAttributes;
        public Float durability;
        public Float durabilityMultiplier;
        public Float integrity;
        public Float magicCapacity;
        public EffectData primaryEffects;
        public EffectData secondaryEffects;
        public EffectData tertiaryEffects;
        public ToolData tools;
        public GlyphData glyph;
        public String[] availableTextures = new String[0];
        public ModuleModel[] models = new ModuleModel[0];
    }
}

