/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.properties;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.math.MathHelper;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.properties.TetraAttributes;

public class AttributeHelper {
    public static final Multimap<Attribute, AttributeModifier> emptyMap = ImmutableMultimap.of();
    private static final Map<String, UUID> attributeIdMap = new HashMap<String, UUID>();

    public static Multimap<Attribute, AttributeModifier> overwrite(Multimap<Attribute, AttributeModifier> a, Multimap<Attribute, AttributeModifier> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll(a);
        b.asMap().forEach((x$0, x$1) -> result.replaceValues(x$0, x$1));
        return result;
    }

    public static Multimap<Attribute, AttributeModifier> merge(Collection<Multimap<Attribute, AttributeModifier>> modifiers) {
        return modifiers.stream().reduce(null, AttributeHelper::merge);
    }

    public static Multimap<Attribute, AttributeModifier> merge(Multimap<Attribute, AttributeModifier> a, Multimap<Attribute, AttributeModifier> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll(a);
        b.forEach((x$0, x$1) -> result.put(x$0, x$1));
        return result;
    }

    public static Multimap<Attribute, AttributeModifier> retainMax(Multimap<Attribute, AttributeModifier> modifiers, Attribute ... attributes) {
        return AttributeHelper.retainMax(modifiers, Arrays.asList(attributes));
    }

    public static Multimap<Attribute, AttributeModifier> retainMax(Multimap<Attribute, AttributeModifier> modifiers, Collection<Attribute> attributes) {
        if (modifiers == null) {
            return null;
        }
        return (Multimap)modifiers.asMap().entrySet().stream().collect(Multimaps.flatteningToMultimap(Map.Entry::getKey, entry -> attributes.contains(entry.getKey()) ? AttributeHelper.retainMax((Collection)entry.getValue()).stream() : ((Collection)entry.getValue()).stream(), ArrayListMultimap::create));
    }

    public static Collection<AttributeModifier> retainMax(Collection<AttributeModifier> modifiers) {
        return modifiers.stream().collect(Collectors.groupingBy(AttributeModifier::func_220375_c, Collectors.maxBy(Comparator.comparing(AttributeModifier::func_111164_d)))).values().stream().map(Optional::get).collect(Collectors.toList());
    }

    public static Collection<AttributeModifier> collapse(Collection<AttributeModifier> modifiers) {
        return Stream.of(Optional.of(AttributeHelper.getAdditionAmount(modifiers)).filter(amount -> amount != 0.0).map(amount -> new AttributeModifier("tetra.stats.addition", amount.doubleValue(), AttributeModifier.Operation.ADDITION)), Optional.of(AttributeHelper.getMultiplyAmount(modifiers)).map(amount -> amount - 1.0).filter(amount -> amount != 0.0).map(amount -> new AttributeModifier("tetra.stats.multiply", amount.doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static double getMergedAmount(Collection<AttributeModifier> modifiers) {
        return AttributeHelper.getMergedAmount(modifiers, 0.0);
    }

    public static double getMergedAmount(Collection<AttributeModifier> modifiers, double base) {
        return (AttributeHelper.getAdditionAmount(modifiers) + base) * AttributeHelper.getMultiplyAmount(modifiers);
    }

    public static double getAdditionAmount(Collection<AttributeModifier> modifiers) {
        double base = modifiers.stream().filter(modifier -> modifier.func_220375_c().equals((Object)AttributeModifier.Operation.ADDITION)).mapToDouble(AttributeModifier::func_111164_d).sum();
        return base + modifiers.stream().filter(modifier -> modifier.func_220375_c().equals((Object)AttributeModifier.Operation.MULTIPLY_BASE)).mapToDouble(AttributeModifier::func_111164_d).map(amount -> amount * Math.abs(base)).sum();
    }

    public static double getMultiplyAmount(Collection<AttributeModifier> modifiers) {
        return modifiers.stream().filter(modifier -> modifier.func_220375_c().equals((Object)AttributeModifier.Operation.MULTIPLY_TOTAL)).mapToDouble(AttributeModifier::func_111164_d).map(amount -> amount + 1.0).reduce(1.0, (a, b) -> a * b);
    }

    public static Multimap<Attribute, AttributeModifier> multiplyModifiers(Multimap<Attribute, AttributeModifier> modifiers, double multiplier) {
        return Optional.ofNullable(modifiers).map(Multimap::entries).map(Collection::stream).map(entries -> (ArrayListMultimap)entries.collect(Multimaps.toMultimap(Map.Entry::getKey, entry -> AttributeHelper.multiplyModifier((AttributeModifier)entry.getValue(), multiplier), ArrayListMultimap::create))).orElse(null);
    }

    public static AttributeModifier multiplyModifier(AttributeModifier modifier, double multiplier) {
        return new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() * multiplier, modifier.func_220375_c());
    }

    public static Multimap<Attribute, AttributeModifier> collapseRound(Multimap<Attribute, AttributeModifier> modifiers) {
        return Optional.ofNullable(modifiers).map(Multimap::asMap).map(Map::entrySet).map(Collection::stream).map(entries -> (ArrayListMultimap)entries.collect(Multimaps.flatteningToMultimap(Map.Entry::getKey, entry -> AttributeHelper.collapse((Collection)entry.getValue()).stream(), ArrayListMultimap::create))).map(AttributeHelper::round).orElse(null);
    }

    public static Multimap<Attribute, AttributeModifier> round(Multimap<Attribute, AttributeModifier> modifiers) {
        return (Multimap)Optional.ofNullable(modifiers).map(Multimap::entries).map(Collection::stream).orElseGet(Stream::empty).collect(Multimaps.toMultimap(Map.Entry::getKey, e -> AttributeHelper.round((Attribute)e.getKey(), (AttributeModifier)e.getValue()), ArrayListMultimap::create));
    }

    private static AttributeModifier round(Attribute attribute, AttributeModifier mod) {
        double multiplier = (Attributes.field_233823_f_.equals(attribute) || ((Attribute)TetraAttributes.drawStrength.get()).equals(attribute) || ((Attribute)TetraAttributes.abilityDamage.get()).equals(attribute)) && mod.func_220375_c() == AttributeModifier.Operation.ADDITION ? 2.0 : 20.0;
        return new AttributeModifier(mod.func_111167_a(), mod.func_111166_b(), (double)Math.round(mod.func_111164_d() * multiplier) / multiplier, mod.func_220375_c());
    }

    private static String getAttributeKey(Attribute attribute, AttributeModifier.Operation operation) {
        return attribute.func_233754_c_() + operation.ordinal();
    }

    private static UUID getAttributeId(Attribute attribute, AttributeModifier.Operation operation) {
        return attributeIdMap.computeIfAbsent(AttributeHelper.getAttributeKey(attribute, operation), k -> MathHelper.func_180182_a((Random)ThreadLocalRandom.current()));
    }

    public static AttributeModifier fixIdentifiers(Attribute attribute, AttributeModifier modifier) {
        return new AttributeModifier(AttributeHelper.getAttributeId(attribute, modifier.func_220375_c()), modifier.func_111166_b(), modifier.func_111164_d(), modifier.func_220375_c());
    }

    public static Multimap<Attribute, AttributeModifier> fixIdentifiers(Multimap<Attribute, AttributeModifier> modifiers) {
        return Optional.ofNullable(modifiers).map(Multimap::entries).map(Collection::stream).map(entries -> (ArrayListMultimap)entries.collect(Multimaps.toMultimap(Map.Entry::getKey, entry -> AttributeHelper.fixIdentifiers((Attribute)entry.getKey(), (AttributeModifier)entry.getValue()), ArrayListMultimap::create))).orElse(null);
    }

    static {
        attributeIdMap.put(AttributeHelper.getAttributeKey(Attributes.field_233823_f_, AttributeModifier.Operation.ADDITION), ModularItem.attackDamageModifier);
        attributeIdMap.put(AttributeHelper.getAttributeKey(Attributes.field_233825_h_, AttributeModifier.Operation.ADDITION), ModularItem.attackSpeedModifier);
    }
}

