/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.properties;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.StorageInventory;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.properties.IToolProvider;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.InventoryStream;

public class PropertyHelper {
    public static int getItemToolLevel(ItemStack itemStack, ToolType tool) {
        return Optional.of(itemStack).filter(stack -> !stack.func_190926_b()).map(PropertyHelper::getReplacement).filter(stack -> stack.func_77973_b() instanceof IToolProvider).map(stack -> ((IToolProvider)stack.func_77973_b()).getToolLevel((ItemStack)stack, tool)).orElse(0);
    }

    public static Set<ToolType> getItemTools(ItemStack itemStack) {
        return Optional.of(itemStack).filter(stack -> !stack.func_190926_b()).map(PropertyHelper::getReplacement).filter(stack -> stack.func_77973_b() instanceof IToolProvider).map(stack -> ((IToolProvider)stack.func_77973_b()).getTools((ItemStack)stack)).orElse(Collections.emptySet());
    }

    public static int getPlayerEffectLevel(PlayerEntity player, ItemEffect effect) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IModularItem).map(itemStack -> ((IModularItem)itemStack.func_77973_b()).getEffectLevel((ItemStack)itemStack, effect)).max(Integer::compare).orElse(0);
    }

    public static double getPlayerEffectEfficiency(PlayerEntity player, ItemEffect effect) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IModularItem).max(Comparator.comparingInt(itemStack -> ((IModularItem)itemStack.func_77973_b()).getEffectLevel((ItemStack)itemStack, effect))).map(itemStack -> ((IModularItem)itemStack.func_77973_b()).getEffectEfficiency((ItemStack)itemStack, effect)).orElse(0.0);
    }

    public static int getPlayerToolLevel(PlayerEntity player, ToolType tool) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.func_77973_b()).getToolLevel((ItemStack)itemStack, tool)).max(Integer::compare).orElse(0);
    }

    public static Set<ToolType> getPlayerTools(PlayerEntity player) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IToolProvider).flatMap(itemStack -> ((IToolProvider)itemStack.func_77973_b()).getTools((ItemStack)itemStack).stream()).collect(Collectors.toSet());
    }

    public static Map<ToolType, Integer> getPlayerToolLevels(PlayerEntity player) {
        return Stream.concat(player.field_71071_by.field_184439_c.stream(), player.field_71071_by.field_70462_a.stream()).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.func_77973_b()).getToolLevels((ItemStack)itemStack)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
    }

    public static int getInventoryToolLevel(IInventory inventory, ToolType tool) {
        int result = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int comparisonLevel = result;
            result = Optional.of(inventory.func_70301_a(i)).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.func_77973_b()).getToolLevel((ItemStack)itemStack, tool)).filter(level -> level > comparisonLevel).orElse(comparisonLevel);
        }
        return result;
    }

    public static Set<ToolType> getInventoryTools(IInventory inventory) {
        HashSet<ToolType> result = new HashSet<ToolType>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            Optional.of(inventory.func_70301_a(i)).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.func_77973_b()).getTools((ItemStack)itemStack).stream()).orElseGet(Stream::empty).forEach(result::add);
        }
        return result;
    }

    public static Map<ToolType, Integer> getInventoryToolLevels(IInventory inventory) {
        return InventoryStream.of(inventory).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.func_77973_b()).getToolLevels((ItemStack)itemStack)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
    }

    public static ItemStack getInventoryProvidingItemStack(IInventory inventory, ToolType tool, int level) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack result = Optional.of(inventory.func_70301_a(i)).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IToolProvider).filter(itemStack -> ((IToolProvider)itemStack.func_77973_b()).getToolLevel((ItemStack)itemStack, tool) >= level).orElse(ItemStack.field_190927_a);
            if (result.func_190926_b()) continue;
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getPlayerProvidingItemStack(ToolType tool, int level, Entity entity) {
        return CastOptional.cast(entity, PlayerEntity.class).map(player -> Stream.concat(Stream.of(player.func_184614_ca(), player.func_184592_cb()), player.field_71071_by.field_70462_a.stream())).orElse(Stream.empty()).filter(itemStack -> !itemStack.func_190926_b()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.func_77973_b() instanceof IToolProvider).filter(itemStack -> ((IToolProvider)itemStack.func_77973_b()).getToolLevel((ItemStack)itemStack, tool) >= level).findAny().orElse(ItemStack.field_190927_a);
    }

    public static ItemStack consumeCraftToolInventory(IInventory inventory, PlayerEntity player, ItemStack targetStack, ToolType tool, int level, boolean consumeResources) {
        ItemStack itemStack = PropertyHelper.getInventoryProvidingItemStack(inventory, tool, level);
        if (itemStack.func_77973_b() instanceof IToolProvider) {
            return ((IToolProvider)itemStack.func_77973_b()).onCraftConsume(itemStack, targetStack, player, tool, level, consumeResources);
        }
        return null;
    }

    public static ItemStack consumeActionToolInventory(IInventory inventory, PlayerEntity player, ItemStack targetStack, ToolType tool, int level, boolean consumeResources) {
        ItemStack itemStack = PropertyHelper.getInventoryProvidingItemStack(inventory, tool, level);
        if (itemStack.func_77973_b() instanceof IToolProvider) {
            return ((IToolProvider)itemStack.func_77973_b()).onActionConsume(itemStack, targetStack, player, tool, level, consumeResources);
        }
        return null;
    }

    private static ItemStack getReplacement(ItemStack itemStack) {
        ItemStack replacement = ItemUpgradeRegistry.instance.getReplacement(itemStack);
        if (!replacement.func_190926_b()) {
            return replacement;
        }
        return itemStack;
    }

    public static int getBlockToolLevel(World world, BlockPos pos, BlockState blockStateIn, ToolType tool) {
        return Optional.of(blockStateIn).filter(blockState -> blockState.func_177230_c() instanceof ITetraBlock).map(blockState -> (ITetraBlock)blockState.func_177230_c()).map(block -> block.getToolLevel(world, pos, blockStateIn, tool)).orElse(0);
    }

    public static Collection<ToolType> getBlockTools(World world, BlockPos pos, BlockState blockStateIn) {
        return Optional.of(blockStateIn).filter(blockState -> blockState.func_177230_c() instanceof ITetraBlock).map(blockState -> (ITetraBlock)blockState.func_177230_c()).map(block -> block.getTools(world, pos, blockStateIn)).orElse(Collections.emptyList());
    }

    public static Map<ToolType, Integer> getBlockToolLevels(World world, BlockPos pos, BlockState blockStateIn) {
        return Optional.of(blockStateIn).filter(blockState -> blockState.func_177230_c() instanceof ITetraBlock).map(blockState -> (ITetraBlock)blockState.func_177230_c()).map(block -> block.getToolLevels(world, pos, blockStateIn)).orElse(Collections.emptyMap());
    }

    public static int getToolbeltToolLevel(PlayerEntity player, ToolType tool) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> Math.max(PropertyHelper.getInventoryToolLevel(new QuickslotInventory((ItemStack)toolbeltStack), tool), PropertyHelper.getInventoryToolLevel(new StorageInventory((ItemStack)toolbeltStack), tool))).orElse(0);
    }

    public static Set<ToolType> getToolbeltTools(PlayerEntity player) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> Sets.union(PropertyHelper.getInventoryTools(new QuickslotInventory((ItemStack)toolbeltStack)), PropertyHelper.getInventoryTools(new StorageInventory((ItemStack)toolbeltStack)))).orElse(Collections.emptySet());
    }

    public static Map<ToolType, Integer> getToolbeltToolLevels(PlayerEntity player) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> Stream.of(PropertyHelper.getInventoryToolLevels(new QuickslotInventory((ItemStack)toolbeltStack)), PropertyHelper.getInventoryToolLevels(new StorageInventory((ItemStack)toolbeltStack)))).orElseGet(Stream::empty).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
    }

    @Nullable
    public static ItemStack consumeCraftToolToolbelt(PlayerEntity player, ItemStack targetStack, ToolType tool, int level, boolean consumeResources) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> {
            QuickslotInventory quickslotInventory = new QuickslotInventory((ItemStack)toolbeltStack);
            ItemStack result = PropertyHelper.consumeCraftToolInventory(quickslotInventory, player, targetStack, tool, level, consumeResources);
            if (result != null) {
                quickslotInventory.func_70296_d();
                return result;
            }
            StorageInventory storageInventory = new StorageInventory((ItemStack)toolbeltStack);
            result = PropertyHelper.consumeCraftToolInventory(quickslotInventory, player, targetStack, tool, level, consumeResources);
            if (result != null) {
                storageInventory.func_70296_d();
                return result;
            }
            return null;
        }).orElse(null);
    }

    public static ItemStack consumeActionToolToolbelt(PlayerEntity player, ItemStack targetStack, ToolType tool, int level, boolean consumeResources) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.func_190926_b()).map(toolbeltStack -> {
            QuickslotInventory quickslotInventory = new QuickslotInventory((ItemStack)toolbeltStack);
            ItemStack result = PropertyHelper.consumeActionToolInventory(quickslotInventory, player, targetStack, tool, level, consumeResources);
            if (result != null) {
                quickslotInventory.func_70296_d();
                return result;
            }
            StorageInventory storageInventory = new StorageInventory((ItemStack)toolbeltStack);
            result = PropertyHelper.consumeActionToolInventory(quickslotInventory, player, targetStack, tool, level, consumeResources);
            if (result != null) {
                storageInventory.func_70296_d();
                return result;
            }
            return null;
        }).orElse(null);
    }

    public static ItemStack getToolbeltProvidingItemStack(ToolType tool, int level, PlayerEntity player) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(itemStack -> !itemStack.func_190926_b()).map(toolbeltStack -> {
            ItemStack itemStack = PropertyHelper.getInventoryProvidingItemStack(new QuickslotInventory((ItemStack)toolbeltStack), tool, level);
            if (!itemStack.func_190926_b()) {
                return itemStack;
            }
            return PropertyHelper.getInventoryProvidingItemStack(new StorageInventory((ItemStack)toolbeltStack), tool, level);
        }).orElse(ItemStack.field_190927_a);
    }

    public static int getCombinedToolLevel(PlayerEntity player, World world, BlockPos pos, BlockState blockStateIn, ToolType tool) {
        return IntStream.of(PropertyHelper.getPlayerToolLevel(player, tool), PropertyHelper.getToolbeltToolLevel(player, tool), PropertyHelper.getBlockToolLevel(world, pos, blockStateIn, tool)).max().orElse(0);
    }

    public static Map<ToolType, Integer> getCombinedToolLevels(PlayerEntity player, World world, BlockPos pos, BlockState blockStateIn) {
        return Stream.of(PropertyHelper.getInventoryToolLevels((IInventory)player.field_71071_by), PropertyHelper.getToolbeltToolLevels(player), PropertyHelper.getBlockToolLevels(world, pos, blockStateIn)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
    }
}

