/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mgui.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import se.mickelus.mgui.gui.GuiElement;

public class GuiItem
extends GuiElement {
    private Minecraft mc;
    private FontRenderer fontRenderer;
    private ItemStack itemStack;
    private boolean showTooltip = true;
    private CountMode countMode = CountMode.normal;
    private float opacityThreshold = 1.0f;

    public GuiItem(int x, int y) {
        super(x, y, 16, 16);
        this.mc = Minecraft.func_71410_x();
        this.setVisible(false);
    }

    public GuiItem setOpacityThreshold(float opacityThreshold) {
        this.opacityThreshold = opacityThreshold;
        return this;
    }

    public GuiItem setTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
        return this;
    }

    public GuiItem setCountVisibility(CountMode mode) {
        this.countMode = mode;
        return this;
    }

    public GuiItem setItem(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.setVisible(itemStack != null);
        if (itemStack != null) {
            this.fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
            if (this.fontRenderer == null) {
                this.fontRenderer = this.mc.field_71466_p;
            }
        }
        return this;
    }

    @Override
    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        if (opacity * this.getOpacity() >= this.opacityThreshold) {
            RenderSystem.pushMatrix();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderHelper.func_227780_a_();
            this.mc.func_175599_af().func_180450_b(this.itemStack, refX + this.x, refY + this.y);
            RenderHelper.func_74518_a();
            this.mc.func_175599_af().func_180453_a(this.fontRenderer, this.itemStack, refX + this.x, refY + this.y, this.getCountString());
            RenderSystem.disableDepthTest();
            RenderSystem.popMatrix();
        }
    }

    protected String getCountString() {
        switch (this.countMode) {
            case normal: {
                return null;
            }
            case always: {
                return String.valueOf(this.itemStack.func_190916_E());
            }
            case never: {
                return "";
            }
        }
        return null;
    }

    @Override
    public List<String> getTooltipLines() {
        if (this.showTooltip && this.itemStack != null && this.hasFocus()) {
            return this.itemStack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(this.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)).stream().map(ITextComponent::getString).collect(Collectors.toList());
        }
        return null;
    }

    public static enum CountMode {
        normal,
        always,
        never;

    }
}

