/*
 * Decompiled with CFR 0.152.
 */
package ru.aiefu.timeandwind;

import com.mojang.brigadier.CommandDispatcher;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ru.aiefu.timeandwind.IDimType;
import ru.aiefu.timeandwind.IOManager;
import ru.aiefu.timeandwind.TAWCommands;
import ru.aiefu.timeandwind.TimeDataStorage;

public class TimeAndWind
implements ModInitializer {
    public static final String MOD_ID = "timeandwind";
    public static HashMap<String, TimeDataStorage> timeDataMap;

    public void onInitialize() {
        this.craftPaths();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> server.method_3738().forEach(serverWorld -> {
            String id = serverWorld.method_27983().method_29177().toString();
            if (timeDataMap.containsKey(id)) {
                ((IDimType)serverWorld.method_8597()).setCycleDuration(TimeAndWind.timeDataMap.get((Object)id).dayDuration, TimeAndWind.timeDataMap.get((Object)id).nightDuration);
            }
        }));
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> TAWCommands.reloadCfgReg((CommandDispatcher<class_2168>)dispatcher));
    }

    public void craftPaths() {
        try {
            if (!Files.isDirectory(Paths.get("./config", new String[0]), new LinkOption[0])) {
                Files.createDirectory(Paths.get("./config", new String[0]), new FileAttribute[0]);
            }
            if (!Files.isDirectory(Paths.get("./config/time-and-wind", new String[0]), new LinkOption[0])) {
                Files.createDirectory(Paths.get("./config/time-and-wind", new String[0]), new FileAttribute[0]);
            }
            IOManager ioManager = new IOManager();
            if (!Files.exists(Paths.get("./config/time-and-wind/time-data.json", new String[0]), new LinkOption[0])) {
                ioManager.genTimeData();
            }
            IOManager.readTimeData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendTimeSyncPacket(class_3222 player, long dayDuration, long nightDuration) {
        class_2487 tag = new class_2487();
        tag.method_10544("dayD", dayDuration);
        tag.method_10544("nightD", nightDuration);
        ServerPlayNetworking.send((class_3222)player, (class_2960)new class_2960(MOD_ID, "sync_cycle"), (class_2540)new class_2540(Unpooled.buffer()).method_10794(tag));
    }

    public static String get24TimeFormat(long time, class_1937 world) {
        if (world != null) {
            double duration = ((IDimType)world.method_8597()).getCycleDuration();
            double currentTime = (double)time % duration;
            double tickInHours = duration / 24.0;
            double ticksInMinute = tickInHours / 60.0;
            int hours = (int)Math.floor(currentTime / tickInHours);
            int minutes = (int)Math.floor((currentTime - tickInHours * (double)hours) / ticksInMinute);
            String mm = "0" + minutes;
            mm = mm.substring(mm.length() - 2);
            if ((hours += 6) > 23) {
                hours -= 24;
            }
            return hours + ":" + mm;
        }
        return "NaN";
    }

    public static int[] get24TimeFormatRaw(long time, class_1937 world) {
        if (world != null) {
            double duration = ((IDimType)world.method_8597()).getCycleDuration();
            double currentTime = (double)time % duration;
            double tickInHours = duration / 24.0;
            double ticksInMinute = tickInHours / 60.0;
            int hours = (int)Math.floor(currentTime / tickInHours);
            int minutes = (int)Math.floor((currentTime - tickInHours * (double)hours) / ticksInMinute);
            if ((hours += 6) > 23) {
                hours -= 24;
            }
            return new int[]{hours, minutes};
        }
        return new int[]{0, 0};
    }
}

