/*
 * Decompiled with CFR 0.152.
 */
package ru.aiefu.timeandwind.mixin;

import java.util.OptionalLong;
import net.minecraft.class_2874;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.aiefu.timeandwind.IDimType;

@Mixin(value={class_2874.class})
public class DimensionTypeMixin
implements IDimType {
    @Mutable
    @Final
    @Shadow
    private final OptionalLong field_24761;
    protected long dayDuration = 12000L;
    protected long nightDuration = 12000L;
    protected long cycleTime = this.dayDuration + this.nightDuration;
    protected double prevAngle = 0.0;

    public DimensionTypeMixin(OptionalLong fixedTime) {
        this.field_24761 = fixedTime;
    }

    @Inject(method={"getMoonPhase"}, at={@At(value="HEAD")}, cancellable=true)
    private void patchMoonPhase(long time, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)((int)(time / this.cycleTime % 8L + 8L) % 8));
    }

    @Inject(method={"getSkyAngle"}, at={@At(value="HEAD")}, cancellable=true)
    private void calculateCelestialAngle(long time, CallbackInfoReturnable<Float> cir) {
        if (!this.field_24761.isPresent()) {
            cir.setReturnValue((Object)Float.valueOf((float)this.syncTime(this.dayDuration, this.nightDuration, time)));
            return;
        }
    }

    private double syncTime(double dayD, double nightD, double time) {
        double d;
        double f;
        double mod = time % (dayD + nightD);
        if (mod > dayD) {
            f = 0.5 / nightD;
            d = f * (mod -= dayD) + 0.5;
        } else {
            f = 0.5 / dayD;
            d = f * mod;
        }
        d -= 0.25;
        if (d < 0.0) {
            d += 1.0;
        }
        this.prevAngle = d - f;
        if (this.prevAngle < 0.0) {
            this.prevAngle = 1.0 - f;
        }
        return d;
    }

    @Override
    public void setCycleDuration(long day, long night) {
        this.dayDuration = day;
        this.nightDuration = night;
        this.cycleTime = day + night;
    }

    @Override
    public long getDayDuration() {
        return this.dayDuration;
    }

    @Override
    public long getNightDuration() {
        return this.nightDuration;
    }

    @Override
    public long getCycleDuration() {
        return this.cycleTime;
    }

    @Override
    public float getPrevAngle() {
        return (float)this.prevAngle;
    }
}

