/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.reflect.Reflection;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.LootConditionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.api.TombstoneAPIProps;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.magic.IProtectedEntity;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.ProtectedEntityStorage;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityStorage;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityFirstAid;
import ovh.corail.tombstone.compatibility.IntegrationTOP;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.config.TombstoneModConfig;
import ovh.corail.tombstone.gui.GuiConfig;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.ThreadedBackup;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.loot.PreciseEnchantFunction;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.proxy.ClientProxy;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.proxy.ServerProxy;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod(value="tombstone")
public class ModTombstone {
    public static final String MOD_ID = "tombstone";
    public static final String MOD_NAME = "Corail Tombstone";
    public static final Logger LOGGER = LogManager.getLogger((String)"tombstone");
    public static final IProxy PROXY = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static LootConditionType OPEN_WATER;
    public static LootFunctionType DELAYED_NBT_LOOT;
    public static LootFunctionType PRECISE_ENCHANT;
    public static LootFunctionType TRIGGER_CAT_MORNING;
    public static final EnchantmentType TYPE_TOMBSTONE_ALL;

    public ModTombstone() {
        TombstoneAPIProps.COOLDOWN_HANDLER = CooldownHandler.INSTANCE;
        Reflection.initialize((Class[])new Class[]{PerkRegistry.class, PacketHandler.class, ModStats.class, ModTriggers.class, ModTags.class, ModTabs.class});
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, ConfigTombstone.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, ConfigTombstone.GENERAL_SPEC);
        this.registerSharedConfig(context);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(this::onServerStarting);
        forgeBus.addListener(this::onServerStoppingEvent);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::preInit);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::enqueueIMC);
        context.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> GuiConfig::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (SupportMods.TOP.isLoaded()) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", IntegrationTOP::new);
        }
    }

    private void registerSharedConfig(ModLoadingContext context) {
        context.getActiveContainer().addConfig((ModConfig)new TombstoneModConfig(SharedConfigTombstone.CONFIG_SPEC, context.getActiveContainer()));
    }

    private void preInit(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ITBCapability.class, (Capability.IStorage)new TBCapabilityStorage(), TBCapabilityDefault::new);
        CapabilityManager.INSTANCE.register(ISoulConsumer.class, TBSoulConsumerProvider.NULL_STORAGE, TBSoulConsumerProvider::getDefault);
        CapabilityManager.INSTANCE.register(IProtectedEntity.class, (Capability.IStorage)new ProtectedEntityStorage(), ProtectedEntityImpl::new);
        PROXY.preInit();
        MinecraftForge.EVENT_BUS.register((Object)Helper.buildKnowledgeFunction());
        OPEN_WATER = LootConditionManager.func_237475_a_((String)"tombstone:in_open_water", (ILootSerializer)InOpenWaterCondition.SERIALIZER);
        DELAYED_NBT_LOOT = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)DelayedNBTFunction.RL, (Object)new LootFunctionType((ILootSerializer)DelayedNBTFunction.SERIALIZER));
        PRECISE_ENCHANT = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)PreciseEnchantFunction.RL, (Object)new LootFunctionType((ILootSerializer)PreciseEnchantFunction.SERIALIZER));
        TRIGGER_CAT_MORNING = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)TriggerCatMorningFunction.RL, (Object)new LootFunctionType((ILootSerializer)TriggerCatMorningFunction.SERIALIZER));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(Helper::initModels);
    }

    private void onServerStarting(FMLServerStartingEvent event) {
        Helper.loadContributors(event.getServer());
        TimeHelper.init();
        Helper.checkDeathHandlingMod(null);
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
        }
        if (SupportMods.FIRST_AID.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityFirstAid.instance);
        }
        ThreadedBackup.INSTANCE.startThread();
        TameableType.init(event.getServer());
    }

    private void onServerStoppingEvent(FMLServerStoppingEvent event) {
        CallbackHandler.flushTasks();
        PlayerPreference.clear();
        CooldownHandler.INSTANCE.clear();
        try {
            ThreadedBackup.INSTANCE.flush();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            ThreadedBackup.INSTANCE.stopThread();
        }
    }

    static {
        TYPE_TOMBSTONE_ALL = EnchantmentType.create((String)"type_tombstone_all", p -> p != null && (p.func_77619_b() > 0 || p.func_77639_j() == 1));
    }
}

