/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.api.magic;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import ovh.corail.tombstone.api.TombstoneAPIProps;
import ovh.corail.tombstone.api.magic.IProtectedEntity;

public class ProtectedEntityProvider
implements ICapabilitySerializable<CompoundNBT> {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "cap_protected_entity");
    @CapabilityInject(value=IProtectedEntity.class)
    public static final Capability<IProtectedEntity> PROTECTED_ENTITY_CAPABILITY = (Capability)TombstoneAPIProps.unsafeNullCast();
    private final LazyOptional<IProtectedEntity> holderCap;

    public ProtectedEntityProvider(NonNullSupplier<IProtectedEntity> nonNullSupplier) {
        this.holderCap = LazyOptional.of(nonNullSupplier);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return PROTECTED_ENTITY_CAPABILITY.orEmpty(cap, this.holderCap);
    }

    public CompoundNBT serializeNBT() {
        return this.holderCap.map(cap -> Optional.ofNullable((CompoundNBT)PROTECTED_ENTITY_CAPABILITY.writeNBT(cap, null)).orElse(new CompoundNBT())).orElse(new CompoundNBT());
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.holderCap.ifPresent(cap -> PROTECTED_ENTITY_CAPABILITY.readNBT(cap, null, (INBT)nbt));
    }
}

