/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBAcceptTeleport
extends TombstoneCommand {
    private static final List<Ticket> TICKETS = new ArrayList<Ticket>();

    public CommandTBAcceptTeleport(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbacceptteleport";
    }

    @Override
    protected Predicate<CommandSource> getInitialRequirement() {
        return p -> true;
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::showUsage)).then(Commands.func_197056_a((String)"target", (ArgumentType)StringArgumentType.word()).executes(this::acceptTeleport));
    }

    private int acceptTeleport(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        String targetString = StringArgumentType.getString(ctx, (String)"target");
        ServerPlayerEntity target = ((CommandSource)ctx.getSource()).func_197028_i().func_184103_al().func_177451_a(UUID.fromString(targetString));
        if (target == null) {
            throw LangKey.MESSAGE_PLAYER_INVALID.asCommandException(new Object[0]);
        }
        boolean valid = false;
        boolean toPlayer = false;
        Iterator<Ticket> it = TICKETS.iterator();
        while (it.hasNext()) {
            Ticket ticket = it.next();
            if (!ticket.playerUUID.equals(player.func_110124_au()) || !ticket.targetUUID.equals(target.func_110124_au()) || ticket.expiredTime < TimeHelper.systemTime()) continue;
            valid = true;
            toPlayer = ticket.toPlayer;
            it.remove();
            break;
        }
        if (valid) {
            ServerPlayerEntity origin = toPlayer ? target : player;
            ServerPlayerEntity destination = toPlayer ? player : target;
            Location spawnLoc = new SpawnHelper(destination.func_71121_q(), destination.func_233580_cy_()).findSafePlace(3, true);
            origin = Helper.teleportEntity(origin, spawnLoc.isOrigin() ? new Location((Entity)destination) : spawnLoc, destination.func_71121_q());
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)origin, StyleType.MESSAGE_SPELL, new Object[0]);
            LangKey.MESSAGE_JOIN_YOU.sendMessage((PlayerEntity)destination, StyleType.MESSAGE_SPELL, new Object[]{origin.func_200200_C_()});
            return 1;
        }
        throw LangKey.MESSAGE_NO_TICKET.asCommandException(new Object[0]);
    }

    public static void addTicket(PlayerEntity player, PlayerEntity target, int duration) {
        CommandTBAcceptTeleport.addTicket(player, target, duration, true);
    }

    public static void addTicket(PlayerEntity player, PlayerEntity target, int duration, boolean toPlayer) {
        TICKETS.add(new Ticket(player.func_110124_au(), target.func_110124_au(), TimeHelper.systemTime() + TimeUnit.SECONDS.toMillis(duration), toPlayer));
    }

    public static void cleanTickets() {
        if (TICKETS.size() > 0) {
            long systemTime = TimeHelper.systemTime();
            TICKETS.removeIf(p -> ((Ticket)p).expiredTime < systemTime);
        }
    }

    public static class Ticket {
        private final UUID playerUUID;
        private final UUID targetUUID;
        private final long expiredTime;
        private final boolean toPlayer;

        Ticket(UUID playerUUID, UUID targetUUID, long expiredTime, boolean toPlayer) {
            this.playerUUID = playerUUID;
            this.targetUUID = targetUUID;
            this.expiredTime = expiredTime;
            this.toPlayer = toPlayer;
        }
    }
}

