/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBRequestTeleport
extends TombstoneCommand {
    public CommandTBRequestTeleport(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbrequestteleport";
    }

    @Override
    protected Predicate<CommandSource> getInitialRequirement() {
        return p -> (Integer)ConfigTombstone.general.cooldownRequestTeleport.get() >= 0 || this.defaultPermission.test(p);
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::showUsage)).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(this::requestTeleport));
    }

    private int requestTeleport(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"target");
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        if (player.equals((Object)target)) {
            throw LangKey.MESSAGE_TELEPORT_SAME_PLAYER.asCommandException(new Object[0]);
        }
        CommandTBRequestTeleport.checkAlive((Entity)target);
        CommandTBRequestTeleport.checkNotSpectator((PlayerEntity)target);
        int cd = CooldownHandler.INSTANCE.getCooldown((PlayerEntity)player, CooldownType.REQUEST_TELEPORT);
        if (cd > 0) {
            LangKey.MESSAGE_COMMAND_IN_COOLDOWN.sendMessage((PlayerEntity)player, TimeHelper.getTimeStringWithUnit(cd));
            return 0;
        }
        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.REQUEST_TELEPORT);
        CommandTBAcceptTeleport.addTicket((PlayerEntity)target, (PlayerEntity)player, Math.max(120, (Integer)ConfigTombstone.general.cooldownRequestTeleport.get() * 60));
        LangKey.MESSAGE_REQUEST_TO_JOIN_RECEIVER.sendMessage((PlayerEntity)target, StyleType.MESSAGE_SPECIAL, new Object[]{LangKey.MESSAGE_HERE.createComponentCommand("/tbacceptteleport " + player.func_110124_au(), new Object[0]), player.func_200200_C_()});
        LangKey.MESSAGE_REQUEST_TO_JOIN_SENDER.sendMessage((PlayerEntity)player, target.func_200200_C_());
        return 1;
    }
}

