/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.Arrays;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public class EnchantmentBlessing
extends ArmorEnchantment {
    private static final String BLESSING_LAST_PROC_NBT_LONG = "blessing_last_proc";

    public EnchantmentBlessing() {
        super("blessing", Enchantment.Rarity.RARE, EnchantmentType.ARMOR, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.HEAD, EquipmentSlotType.FEET);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentBlessing.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.blessingEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    protected void onWearerHit(LivingEntity wearer, Entity attacker, int level) {
        int delay = TimeHelper.tickFromSecond(10);
        int count = Math.min((int)Arrays.stream(this.field_185263_a).map(arg_0 -> ((LivingEntity)wearer).func_184582_a(arg_0)).filter(stack -> EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack) > 0).count(), 4);
        if (count > 0) {
            boolean valid;
            CompoundNBT persistantData = wearer.getPersistentData();
            boolean bl = valid = !persistantData.func_150297_b(BLESSING_LAST_PROC_NBT_LONG, 4);
            if (!valid) {
                long timeLeft = persistantData.func_74763_f(BLESSING_LAST_PROC_NBT_LONG) - (long)wearer.field_70173_aa;
                if (timeLeft < 0L) {
                    persistantData.func_82580_o(BLESSING_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.func_74772_a(BLESSING_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
                }
            }
            if (valid && wearer.func_70681_au().nextFloat() < 0.1f * (float)count) {
                EffectInstance effect = EffectHelper.getRandomEffect(TimeHelper.tickFromSecond(30), false, true, i -> wearer.func_70681_au().nextInt(count + 1));
                EffectHelper.addEffect(wearer, effect);
                persistantData.func_74772_a(BLESSING_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
            }
        }
    }

    @Override
    public boolean isInBeta() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return 1;
    }

    @Override
    public boolean hasUniqueLevel() {
        return true;
    }
}

