/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.EffectMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEffects;

public class EnchantmentCurseOfBones
extends ArmorEnchantment {
    private static final String BONE_SHIELD_LAST_PROC_NBT_LONG = "bone_shield_last_proc";

    public EnchantmentCurseOfBones() {
        super("curse_of_bones", Enchantment.Rarity.RARE, EnchantmentType.ARMOR_CHEST, EquipmentSlotType.CHEST);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentCurseOfBones.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.curseOfBonesEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public int func_77325_b() {
        return (Integer)SharedConfigTombstone.enchantments.maxLevelCurseOfBones.get();
    }

    @Override
    protected void onWearerHit(LivingEntity wearer, Entity attacker, int level) {
        int delay = TimeHelper.tickFromSecond(60 - Math.min(level * 3, 30));
        if (EntityHelper.getCurseOfBonesLevel(wearer) > 0) {
            boolean valid;
            CompoundNBT persistantData = wearer.getPersistentData();
            boolean bl = valid = !persistantData.func_150297_b(BONE_SHIELD_LAST_PROC_NBT_LONG, 4);
            if (!valid) {
                long timeLeft = persistantData.func_74763_f(BONE_SHIELD_LAST_PROC_NBT_LONG) - (long)wearer.field_70173_aa;
                if (timeLeft <= 0L) {
                    persistantData.func_82580_o(BONE_SHIELD_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.func_74772_a(BONE_SHIELD_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
                }
            }
            if (valid && wearer.func_70681_au().nextFloat() < 0.1f + (float)level * 0.1f) {
                EffectInstance effect = new EffectInstance(ModEffects.bone_shield, TimeHelper.tickFromSecond(10), level);
                EffectHelper.addEffect(wearer, effect);
                PacketHandler.sendToAllTrackingPlayers(new EffectMessage(wearer.func_145782_y(), effect), wearer);
                persistantData.func_74772_a(BONE_SHIELD_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
            }
        }
    }

    @Override
    public boolean isInBeta() {
        return true;
    }
}

