/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.GuiKnowledge;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModParticleTypes;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static final KeyBinding keybindKnowledge = new KeyBinding(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.field_197958_a, "Corail Tombstone");
    private static boolean hasTrueSight;
    private static boolean isFirstGuiGameOver;
    private static boolean requireRemovalNightVision;
    private static boolean requireRemovalVisibility;
    private static boolean delayedGui;
    private static long nextGhostTime;
    private static boolean SKIP_RENDER_EVENT;
    private static final List<Aura> AURAS;
    private static final ResourceLocation[] AURA_TEXTURES;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onClientChatEvent(ClientChatEvent event) {
        if ("/tbgui".equals(event.getMessage())) {
            delayedGui = true;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static <T extends LivingEntity> void onRenderCreatureEvent(RenderLivingEvent.Pre<T, EntityModel<T>> event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !hasTrueSight && !((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue()) {
            return;
        }
        if (hasTrueSight && event.getEntity().func_98034_c((PlayerEntity)Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g)) && event.getEntity().func_82150_aj()) {
            event.getEntity().func_82142_c(false);
            requireRemovalVisibility = true;
        }
        if (((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue() && !event.getEntity().func_82150_aj()) {
            Aura.addAura(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static <T extends LivingEntity> void onRenderCreatureEvent(RenderLivingEvent.Post<T, EntityModel<T>> event) {
        if (requireRemovalVisibility) {
            event.getEntity().func_82142_c(true);
            requireRemovalVisibility = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (EntityHelper.isValidPlayer((PlayerEntity)player)) {
            if (event.phase == TickEvent.Phase.START) {
                boolean bl = hasTrueSight = EffectHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape, 4) || EffectHelper.isPotionActive((LivingEntity)player, ModEffects.true_sight) || EffectHelper.isPotionActive((LivingEntity)player, ModEffects.aquatic_life) && Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216771_k().func_206884_a((ITag)FluidTags.field_206959_a);
                if (hasTrueSight && !EffectHelper.isPotionActive((LivingEntity)player, Effects.field_76439_r)) {
                    player.func_195064_c(new EffectInstance(Effects.field_76439_r, 1200, 0, true, false));
                    requireRemovalNightVision = true;
                }
            } else if (requireRemovalNightVision) {
                player.func_184596_c(Effects.field_76439_r);
                requireRemovalNightVision = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.func_147113_T()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && EntityHelper.isValidPlayer((PlayerEntity)mc.field_71439_g)) {
            if ((keybindKnowledge.func_151468_f() || delayedGui) && (mc.field_71462_r == null || mc.field_71462_r instanceof ChatScreen)) {
                mc.field_71439_g.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                    delayedGui = false;
                    mc.func_147108_a((Screen)new GuiKnowledge(mc.field_71439_g, (ITBCapability)cap));
                });
            }
            if (((Boolean)ConfigTombstone.client.enableHalloweenEffect.get()).booleanValue() && TimeHelper.isDateAroundHalloween()) {
                if (Helper.isNight((World)mc.field_71441_e)) {
                    long time = TimeHelper.worldTicks((World)mc.field_71441_e);
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && CooldownHandler.INSTANCE.noCooldown((PlayerEntity)mc.field_71439_g, CooldownType.NEXT_PRAY)) {
                            Vector3d ghostVec = mc.field_71439_g.func_213303_ch().func_72441_c(Helper.getRandom(-9.0, 9.0), 0.0, Helper.getRandom(-9.0, 9.0));
                            mc.field_71452_i.func_199280_a((IParticleData)ModParticleTypes.GHOST, ghostVec.field_72450_a, ghostVec.field_72448_b, ghostVec.field_72449_c, 0.0, 0.0, 0.0);
                        }
                        nextGhostTime = time + (long)Helper.getRandom(60, 6000);
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(GuiOpenEvent event) {
        ClientPlayerEntity player;
        if (event.getGui() instanceof DeathScreen && ((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue() && (player = Minecraft.func_71410_x().field_71439_g) != null && !player.field_70170_p.func_72912_H().func_76093_s()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.func_71004_bE();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        FluidState fluidState;
        boolean isWater;
        if (hasTrueSight && ((isWater = (fluidState = event.getInfo().getBlockAtCamera().func_204520_s()).func_206884_a((ITag)FluidTags.field_206959_a)) || fluidState.func_206884_a((ITag)FluidTags.field_206960_b))) {
            event.setCanceled(true);
            event.setDensity(isWater ? 0.025f : 0.8f);
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (hasTrueSight) {
            FluidState fluidState = event.getInfo().getBlockAtCamera().func_204520_s();
            if (fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) {
                event.setRed(0.09f);
                event.setGreen(0.42f);
                event.setBlue(0.93f);
            } else if (fluidState.func_206884_a((ITag)FluidTags.field_206960_b)) {
                event.setRed(1.0f);
                event.setGreen(0.32f);
                event.setBlue(0.09f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if (hasTrueSight && (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER || event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(GuiScreenEvent.DrawScreenEvent event) {
        if (requireRemovalNightVision) {
            Optional.ofNullable(Minecraft.func_71410_x().field_71439_g).ifPresent(p -> p.func_184596_c(Effects.field_76439_r));
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (SupportMods.canDisplayEnchantInfos() && event.getPlayer() != null && event.getPlayer().field_70170_p != null && ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue() && event.getItemStack().func_77942_o()) {
            boolean isEnchantedBook;
            boolean bl = isEnchantedBook = event.getItemStack().func_77973_b() == Items.field_151134_bR;
            if (!isEnchantedBook && ModEnchantments.getEnchantments().values().stream().allMatch(TombstoneEnchantment::isEnabled)) {
                return;
            }
            ListNBT taglist = isEnchantedBook ? EnchantedBookItem.func_92110_g((ItemStack)event.getItemStack()) : event.getItemStack().func_77986_q();
            Set list = IntStream.range(0, taglist.size()).mapToObj(arg_0 -> ((ListNBT)taglist).func_150305_b(arg_0)).map(nbt -> nbt.func_74779_i("id")).filter(id -> !id.isEmpty() && ModEnchantments.getEnchantments().keySet().contains(id)).map(ModEnchantments.getEnchantments()::get).collect(Collectors.toSet());
            for (TombstoneEnchantment enchant : list) {
                IntStream.range(0, event.getToolTip().size()).filter(line -> {
                    ITextComponent currentTooltip = (ITextComponent)event.getToolTip().get(line);
                    return currentTooltip instanceof TranslationTextComponent && enchant.func_77320_a().equals(((TranslationTextComponent)currentTooltip).func_150268_i());
                }).findFirst().ifPresent(line -> {
                    List<ITextComponent> infos = enchant.getTooltipInfos(isEnchantedBook);
                    for (ITextComponent info : infos) {
                        event.getToolTip().add(++line, info);
                    }
                });
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (SKIP_RENDER_EVENT) {
            SKIP_RENDER_EVENT = false;
            return;
        }
        if (EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangiblenessActive((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
            SKIP_RENDER_EVENT = true;
            event.getRenderer().func_225623_a_((AbstractClientPlayerEntity)event.getPlayer(), event.getPlayer().field_70177_z, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), 0xFFFFFF);
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        Location location;
        if (!((Boolean)ConfigTombstone.client.highlight.get()).booleanValue()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == ModItems.grave_key) {
            location = ModItems.grave_key.getTombPos(stack);
        } else if (stack.func_77973_b() == ModItems.tablet_of_recall) {
            location = ModItems.tablet_of_recall.getTombPos(stack);
        } else if (ModItems.lost_tablet.isWakeUp(stack)) {
            location = ModItems.lost_tablet.getLocation(stack);
        } else {
            return;
        }
        if (location.isOrigin() || !location.isSameDimension(player.field_70170_p) || World.func_189509_E((BlockPos)location.getPos())) {
            return;
        }
        ClientEventHandler.createBox(event.getMatrixStack(), location.x, location.y, location.z, 1.0);
    }

    private static void createBox(MatrixStack matrixStack, double x, double y, double z, double offset) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.pushMatrix();
        Vector3d projectedView = mc.field_71460_t.func_215316_n().func_216785_c();
        long c = TimeHelper.systemTime() / 15L % 360L;
        float[] color = Helper.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        matrixStack.func_227860_a_();
        Vector3d vec = new Vector3d(x, y, z).func_178788_d(projectedView);
        if (vec.func_72438_d(Vector3d.field_186680_a) > 200.0) {
            vec = vec.func_72432_b().func_186678_a(200.0);
            x += vec.field_72450_a;
            y += vec.field_72448_b;
            z += vec.field_72449_c;
        }
        x -= projectedView.field_72450_a;
        y -= projectedView.field_72448_b;
        z -= projectedView.field_72449_c;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.multMatrix((Matrix4f)matrix);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        RenderSystem.color4f((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        RenderSystem.lineWidth((float)2.5f);
        renderer.func_225582_a_(x, y, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z).func_181675_d();
        renderer.func_225582_a_(x, y, z).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x, y, z).func_181675_d();
        renderer.func_225582_a_(x, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z + offset).func_181675_d();
        tessellator.func_78381_a();
        matrixStack.func_227865_b_();
        RenderSystem.popMatrix();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderAuras(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && mc.field_71439_g != null && ((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue()) {
            Aura.addAura((LivingEntity)mc.field_71439_g);
        }
        if (!AURAS.isEmpty()) {
            double ratio = (double)System.currentTimeMillis() * 0.03 % 360.0;
            AURAS.forEach(aura -> ClientEventHandler.renderAura(mc, event.getMatrixStack(), aura, ratio));
            AURAS.clear();
        }
    }

    private static void renderAura(Minecraft mc, MatrixStack matrixStack, Aura aura, double ratio) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.disableCull();
        mc.func_175598_ae().field_78724_e.func_110577_a(AURA_TEXTURES[0]);
        Vector3d projectedView = mc.field_71460_t.func_215316_n().func_216785_c();
        Vector3d vec3 = aura.position.func_178788_d(projectedView);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)vec3.field_72450_a), (double)((float)vec3.field_72448_b), (double)((float)vec3.field_72449_c));
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)ratio));
        matrixStack.func_227861_a_((double)((float)(-vec3.field_72450_a)), (double)((float)(-vec3.field_72448_b)), (double)((float)(-vec3.field_72449_c)));
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.multMatrix((Matrix4f)matrix);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Vector3d vec1 = new Vector3d(vec3.field_72450_a - aura.auraType.radius, vec3.field_72448_b + 0.014625, vec3.field_72449_c - aura.auraType.radius);
        Vector3d vec2 = new Vector3d(vec3.field_72450_a + aura.auraType.radius, vec3.field_72448_b + 0.014625, vec3.field_72449_c + aura.auraType.radius);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        bufferbuilder.func_225582_a_(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c).func_225583_a_(0.0f, 0.0f).func_227885_a_(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(vec1.field_72450_a, vec1.field_72448_b, vec2.field_72449_c).func_225583_a_(0.0f, 1.0f).func_227885_a_(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(vec2.field_72450_a, vec1.field_72448_b, vec2.field_72449_c).func_225583_a_(1.0f, 1.0f).func_227885_a_(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(vec2.field_72450_a, vec1.field_72448_b, vec1.field_72449_c).func_225583_a_(1.0f, 0.0f).func_227885_a_(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        matrixStack.func_227865_b_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)keybindKnowledge);
        hasTrueSight = false;
        isFirstGuiGameOver = false;
        requireRemovalNightVision = false;
        requireRemovalVisibility = false;
        delayedGui = false;
        nextGhostTime = -1L;
        SKIP_RENDER_EVENT = false;
        AURAS = new ArrayList<Aura>();
        AURA_TEXTURES = new ResourceLocation[]{new ResourceLocation("tombstone", "textures/aura/aura1.png")};
    }

    private static class Aura {
        private final Vector3d position;
        private final AuraType auraType;

        private Aura(LivingEntity entity, AuraType auraType) {
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            this.position = new Vector3d(MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70142_S, (double)entity.func_226277_ct_()), MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70137_T, (double)entity.func_226278_cu_()) + 0.1111, MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70136_U, (double)entity.func_226281_cx_()));
            this.auraType = auraType;
        }

        private Aura(double x, double y, double z) {
            this.position = new Vector3d(x, y, z);
            this.auraType = AuraType.MARKER;
        }

        private static void addAura(LivingEntity entity) {
            AuraType auraType = AuraType.getAuraType(entity);
            if (auraType != null) {
                Aura aura = new Aura(entity, auraType);
                double opaque = 1.0;
                double distanceToCamera = Minecraft.func_71410_x().func_175598_ae().func_78714_a(aura.position.field_72450_a, aura.position.field_72448_b, aura.position.field_72449_c);
                double f = (1.0 - distanceToCamera * 0.00390625) * opaque;
                if (f > 0.0) {
                    AURAS.add(aura);
                }
            }
        }
    }

    static enum AuraType {
        PRAY(3.5, 0.88f, 0.78f, 0.48f, 1.0f),
        SCROLL(0.8, 0.38f, 0.28f, 0.88f, 1.0f),
        SIMPLE_TELEPORT(0.8, 0.23f, 0.78f, 0.86f, 1.0f),
        AREA_TELEPORT(5.0, 0.23f, 0.78f, 0.86f, 1.0f),
        MARKER(1.0, 0.38f, 0.48f, 0.18f, 1.0f);

        private final double radius;
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        private AuraType(double radius, float r, float g, float b, float a) {
            this.radius = radius;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        private static AuraType getAuraType(LivingEntity entity) {
            if (!entity.func_184587_cr()) {
                return null;
            }
            ItemStack heldStack = entity.func_184614_ca();
            Item heldItem = heldStack.func_77973_b();
            if (heldItem == ModItems.ankh_of_pray) {
                return PRAY;
            }
            if (heldItem == ModItems.grave_key || heldItem == ModItems.lost_tablet || heldItem == ModItems.tablet_of_assistance) {
                return SIMPLE_TELEPORT;
            }
            if (heldItem == ModItems.tablet_of_recall || heldItem == ModItems.tablet_of_home) {
                return ((ItemGraveMagic)heldStack.func_77973_b()).isAncient(heldStack) ? AREA_TELEPORT : SIMPLE_TELEPORT;
            }
            if (Arrays.stream(ModItems.scroll_buff).anyMatch(item -> item == heldItem) || heldItem == ModItems.scroll_of_knowledge) {
                return SCROLL;
            }
            return null;
        }
    }
}

