/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.OptionSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.gui.BooleanConfigOption;
import ovh.corail.tombstone.gui.ColorSliderHandler;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.CustomOptionsRowList;
import ovh.corail.tombstone.gui.IntegerConfigOption;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.registry.ModBlocks;

@OnlyIn(value=Dist.CLIENT)
public class GuiConfig
extends TBScreen {
    private static final ResourceLocation tablet = new ResourceLocation("tombstone", "textures/item/grave_plate.png");
    private TabConfig tab = TabConfig.GRAVE;
    private final String nameToDisplay;
    private final PlayerPreference playerPreference = PlayerPreference.fromClientConfig();
    private boolean enhanced_tooltips;
    private boolean skipRespawnScreen;
    private boolean dateInMCTime;
    private boolean showInfoOnEnchantment;
    private boolean highlightGrave;
    private boolean showShadowStep;
    private boolean showShieldParticle;
    private boolean enableHalloweenEffect;
    private boolean showMagicCircle;
    private CustomOptionsRowList miscList;
    private CustomOptionsRowList effectList;
    private ConfigTombstone.Client.GraveSkinRule graveSkinRule;
    private ConfigTombstone.Client.FogDensity fogDensity;
    private ConfigTombstone.Client.FogPeriod fogPeriod;
    private final ColorSliderHandler colorSliderHandler0;
    private final ColorSliderHandler colorSliderHandler1;
    private final ColorSliderHandler colorSliderHandler2;
    private final ColorSliderHandler colorSliderHandler3;
    private final ColorSliderHandler colorSliderHandler4;
    private boolean saveButtonHighlight;
    private boolean isDirty;
    private final AbstractOption[] miscOptions;
    private final AbstractOption[] effectOptions;
    private final List<Predicate<Boolean>> config_changed_predics;

    GuiConfig() {
        super((ITextComponent)new StringTextComponent("Tombstone Config"));
        this.enhanced_tooltips = (Boolean)ConfigTombstone.client.showEnhancedTooltips.get();
        this.skipRespawnScreen = (Boolean)ConfigTombstone.client.skipRespawnScreen.get();
        this.dateInMCTime = (Boolean)ConfigTombstone.client.dateInMCTime.get();
        this.showInfoOnEnchantment = (Boolean)ConfigTombstone.client.showInfoOnEnchantment.get();
        this.highlightGrave = (Boolean)ConfigTombstone.client.highlight.get();
        this.showShadowStep = (Boolean)ConfigTombstone.client.showShadowStep.get();
        this.showShieldParticle = (Boolean)ConfigTombstone.client.showShieldParticle.get();
        this.enableHalloweenEffect = (Boolean)ConfigTombstone.client.enableHalloweenEffect.get();
        this.showMagicCircle = (Boolean)ConfigTombstone.client.showMagicCircle.get();
        this.graveSkinRule = (ConfigTombstone.Client.GraveSkinRule)((Object)ConfigTombstone.client.graveSkinRule.get());
        this.fogDensity = (ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get());
        this.fogPeriod = (ConfigTombstone.Client.FogPeriod)ConfigTombstone.client.fogPeriod.get();
        this.colorSliderHandler0 = new ColorSliderHandler("particle_casting_color", (Integer)ConfigTombstone.client.particleCastingColor.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler1 = new ColorSliderHandler("text_color_rip", (Integer)ConfigTombstone.client.textColorRIP.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler2 = new ColorSliderHandler("text_color_owner", (Integer)ConfigTombstone.client.textColorOwner.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler3 = new ColorSliderHandler("text_color_death_date", (Integer)ConfigTombstone.client.textColorDeathDate.get(), d -> {
            this.isDirty = d;
        });
        this.colorSliderHandler4 = new ColorSliderHandler("fog_color", (Integer)ConfigTombstone.client.fogColor.get(), d -> {
            this.isDirty = d;
        });
        this.isDirty = true;
        this.miscOptions = new AbstractOption[]{new BooleanConfigOption("show_enhanced_tooltips", () -> this.enhanced_tooltips, b -> {
            this.enhanced_tooltips = b;
        }, d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("skip_respawn_screen", () -> this.skipRespawnScreen, b -> {
            this.skipRespawnScreen = b;
        }, d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("date_in_mc_time", () -> this.dateInMCTime, b -> {
            this.dateInMCTime = b;
        }, d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("display_knowledge_message", () -> this.playerPreference.displayKnowledgeMessage(), b -> this.playerPreference.setDisplayKnowledgeMessage(b), d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("equip_elytra_in_priority", () -> this.playerPreference.equipElytraInPriority(), b -> this.playerPreference.setEquipElytraInPriority(b), d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("show_info_on_enchantment", () -> this.showInfoOnEnchantment, b -> {
            this.showInfoOnEnchantment = b;
        }, d -> {
            this.isDirty = d;
        }), new IntegerConfigOption("grave_skin_rule", () -> this.graveSkinRule.ordinal(), b -> {
            this.graveSkinRule = ConfigTombstone.Client.GraveSkinRule.values()[b];
        }, ConfigTombstone.Client.GraveSkinRule.values().length - 1, d -> {
            this.isDirty = d;
        }, i -> ConfigTombstone.Client.GraveSkinRule.values()[i].name().replace("_", " ")), new IntegerConfigOption("fog_density", () -> this.fogDensity.ordinal(), b -> {
            this.fogDensity = ConfigTombstone.Client.FogDensity.values()[b];
        }, ConfigTombstone.Client.FogDensity.values().length - 1, d -> {
            this.isDirty = d;
        }, i -> ConfigTombstone.Client.FogDensity.values()[i].name()), new IntegerConfigOption("fog_period", () -> this.fogPeriod.ordinal(), b -> {
            this.fogPeriod = ConfigTombstone.Client.FogPeriod.values()[b];
        }, ConfigTombstone.Client.FogPeriod.values().length - 1, d -> {
            this.isDirty = d;
        }, i -> ConfigTombstone.Client.FogPeriod.values()[i].name()), new BooleanConfigOption("priorize_tool_on_hotbar", () -> this.playerPreference.priorizeToolOnHotbar(), b -> this.playerPreference.setPriorizeToolOnHotbar(b), d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("activate_grave_by_sneaking", () -> this.playerPreference.activateGraveBySneaking(), b -> this.playerPreference.setActivateGraveBySneaking(b), d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("deny_grave_on_death", () -> this.playerPreference.denyGraveOnDeath(), b -> this.playerPreference.setDenyGraveOnDeath(b), d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("allow_grave_in_water", () -> this.playerPreference.allowGraveInWater(), b -> this.playerPreference.setAllowGraveInWater(b), d -> {
            this.isDirty = d;
        }), new IntegerConfigOption("grave_spawn_rule", () -> this.playerPreference.getGraveSpawnRule().ordinal(), i -> this.playerPreference.setGraveSpawnRule(ConfigTombstone.Client.GraveSpawnRule.byId(i)), ConfigTombstone.Client.GraveSpawnRule.values().length - 1, d -> {
            this.isDirty = d;
        }, i -> ConfigTombstone.Client.GraveSpawnRule.values()[i].name()), new IntegerConfigOption("auto_equip_rule", () -> this.playerPreference.getAutoEquipRule().ordinal(), i -> this.playerPreference.setAutoEquipRule(ConfigTombstone.Client.AutoEquipRule.byId(i)), ConfigTombstone.Client.AutoEquipRule.values().length - 1, d -> {
            this.isDirty = d;
        }, i -> ConfigTombstone.Client.AutoEquipRule.values()[i].name().replace("_", " "))};
        this.effectOptions = new AbstractOption[]{new BooleanConfigOption("highlight", () -> this.highlightGrave, b -> {
            this.highlightGrave = b;
        }, d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("show_shadow_step", () -> this.showShadowStep, b -> {
            this.showShadowStep = b;
        }, d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("show_shield_particle", () -> this.showShieldParticle, b -> {
            this.showShieldParticle = b;
        }, d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("enable_halloween_effect", () -> this.enableHalloweenEffect, b -> {
            this.enableHalloweenEffect = b;
        }, d -> {
            this.isDirty = d;
        }), new BooleanConfigOption("show_magic_circle", () -> this.showMagicCircle, b -> {
            this.showMagicCircle = b;
        }, d -> {
            this.isDirty = d;
        })};
        this.config_changed_predics = new ArrayList<Predicate<Boolean>>(){
            {
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.textColorRIP, GuiConfig.this.colorSliderHandler1.getColor(), u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.textColorOwner, GuiConfig.this.colorSliderHandler2.getColor(), u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.textColorDeathDate, GuiConfig.this.colorSliderHandler3.getColor(), u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showEnhancedTooltips, GuiConfig.this.enhanced_tooltips, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.highlight, GuiConfig.this.highlightGrave, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.skipRespawnScreen, GuiConfig.this.skipRespawnScreen, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showShadowStep, GuiConfig.this.showShadowStep, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showShieldParticle, GuiConfig.this.showShieldParticle, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.enableHalloweenEffect, GuiConfig.this.enableHalloweenEffect, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.dateInMCTime, GuiConfig.this.dateInMCTime, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showInfoOnEnchantment, GuiConfig.this.showInfoOnEnchantment, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.graveSkinRule, (Object)GuiConfig.this.graveSkinRule, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.fogDensity, (Object)GuiConfig.this.fogDensity, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.showMagicCircle, GuiConfig.this.showMagicCircle, u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.particleCastingColor, GuiConfig.this.colorSliderHandler0.getColor(), u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.fogColor, GuiConfig.this.colorSliderHandler4.getColor(), u));
                this.add(u -> GuiConfig.this.checkConfig(ConfigTombstone.client.fogPeriod, GuiConfig.this.fogPeriod, u));
            }
        };
        this.nameToDisplay = Optional.ofNullable(Minecraft.func_71410_x().field_71439_g).map(p -> p.func_200200_C_().getString()).orElse(Helper.getRandomThankName());
    }

    public GuiConfig(Minecraft minecraft, Screen screen) {
        this();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        int posY = 0;
        for (TabConfig currentTab : TabConfig.values()) {
            this.func_230480_a_((Widget)new CustomButton(this.guiLeft - 50, this.guiTop + posY, 40, 20, (ITextComponent)new StringTextComponent(currentTab.name()), pressable -> this.switchTab(currentTab)));
            posY += 20;
        }
        this.func_230480_a_((Widget)new CustomButton(this.guiLeft - 50, this.guiTop + posY, 40, 20, (ITextComponent)new StringTextComponent("SAVE"), pressable -> this.saveConfig(), () -> this.saveButtonHighlight));
        TabConfig.clear();
        this.miscList = new CustomOptionsRowList(this.guiLeft + 13, this.guiTop + 50, 190, 133, 14);
        this.miscList.addOptions(this.miscOptions);
        this.field_230705_e_.add(this.miscList);
        TabConfig.MISC.attach(this.miscList);
        this.effectList = new CustomOptionsRowList(this.guiLeft + 13, this.guiTop + 50, 190, 77, 14);
        this.effectList.addOptions(this.effectOptions);
        this.field_230705_e_.add(this.effectList);
        this.colorSliderHandler0.createWidget(this.getMinecraft().field_71474_y, this.field_230710_m_, this.field_230705_e_, this.guiLeft + 100, this.guiTop + 145, 80, 4);
        this.colorSliderHandler4.createWidget(this.getMinecraft().field_71474_y, this.field_230710_m_, this.field_230705_e_, this.guiLeft + 100, this.guiTop + 170, 80, 4);
        TabConfig.EFFECT.attach(this.effectList, this.colorSliderHandler0, this.colorSliderHandler4);
        TabConfig.GRAVE.attach(this.func_230480_a_((Widget)new OptionSlider(this.getMinecraft().field_71474_y, this.guiRight - 10 - 30, this.guiTop + 40, 30, 20, new SliderPercentageOption("texture", 0.0, 1.0, 1.0f, settings -> this.playerPreference.getMarbleType().ordinal(), (settings, d) -> this.playerPreference.setMarbleType(BlockGraveMarble.MarbleType.byId(d.intValue())), (settings, d) -> new TranslationTextComponent(this.playerPreference.getMarbleType().func_176610_l()))){

            protected void func_230972_a_() {
                super.func_230972_a_();
                GuiConfig.this.isDirty = true;
            }
        }));
        TabConfig.GRAVE.attach(this.func_230480_a_((Widget)new ChangePageButton(this.halfWidth - 23 - 65, this.guiBottom - 25, false, pressable -> {
            do {
                this.playerPreference.setFavoriteGrave(this.playerPreference.getFavoriteGrave().getPrevious());
            } while (this.playerPreference.getFavoriteGrave().isOnlyContributor() && !Helper.IS_CONTRIBUTOR);
            this.isDirty = true;
        }, true)));
        TabConfig.GRAVE.attach(this.func_230480_a_((Widget)new ChangePageButton(this.halfWidth + 65, this.guiBottom - 25, true, pressable -> {
            do {
                this.playerPreference.setFavoriteGrave(this.playerPreference.getFavoriteGrave().getNext());
            } while (this.playerPreference.getFavoriteGrave().isOnlyContributor() && !Helper.IS_CONTRIBUTOR);
            this.isDirty = true;
        }, true)));
        this.colorSliderHandler1.createWidget(this.getMinecraft().field_71474_y, this.field_230710_m_, this.field_230705_e_, this.guiLeft + 10, this.guiTop + 67, 40, 4);
        this.colorSliderHandler2.createWidget(this.getMinecraft().field_71474_y, this.field_230710_m_, this.field_230705_e_, this.guiLeft + 10, this.guiTop + 97, 40, 4);
        this.colorSliderHandler3.createWidget(this.getMinecraft().field_71474_y, this.field_230710_m_, this.field_230705_e_, this.guiLeft + 10, this.guiTop + 131, 40, 4);
        TabConfig.PLATE.attach(this.colorSliderHandler1, this.colorSliderHandler2, this.colorSliderHandler3);
        TabConfig.hideAll();
        this.tab.show();
    }

    private void switchTab(TabConfig tab) {
        if (this.tab != tab) {
            this.tab.hide();
            this.tab = tab;
            this.tab.show();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isDirty) {
            this.isDirty = false;
            this.saveButtonHighlight = this.getConfigState(false).isChanged();
        }
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230712_o_.getClass();
        GuiConfig.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)(this.guiRight - 5), (int)(this.guiTop + 20 + 9), (int)0x55000000);
        ((Object)((Object)this)).getClass();
        GuiConfig.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)this.halfWidth, (int)(this.guiTop + 14), (int)-1);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.tab) {
            case GRAVE: {
                ItemStack stack = new ItemStack((IItemProvider)ModBlocks.DECORATIVE_GRAVES.get((Object)this.playerPreference.getFavoriteGrave()));
                ItemBlockGrave.setModelTexture(stack, this.playerPreference.getMarbleType().ordinal());
                ITextComponent displayName = stack.func_151000_E();
                EngravableHelper.setEngravedName(stack, this.nameToDisplay);
                ((Object)((Object)this)).getClass();
                GuiConfig.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)displayName, (int)this.halfWidth, (int)(this.guiBottom - 55), (int)-1);
                GuiConfig.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiRight - 5), (int)(this.guiBottom - 42), (int)0x50000000);
                Helper.renderStackInGui(stack, this.guiLeft + 40, this.guiTop + 32, 6.0, true);
                break;
            }
            case PLATE: {
                this.getMinecraft().field_71446_o.func_110577_a(tablet);
                GuiConfig.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 46), (int)(this.guiTop + 36), (float)0.0f, (float)0.0f, (int)154, (int)154, (int)154, (int)154);
                int textPos = this.halfWidth + 24;
                GuiConfig.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("R.I.P.").func_240699_a_(TextFormatting.BOLD), (int)textPos, (int)(this.guiTop + 70), (int)this.colorSliderHandler1.getColor());
                GuiConfig.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent(this.nameToDisplay).func_240699_a_(TextFormatting.BOLD), (int)textPos, (int)(this.guiTop + 100), (int)this.colorSliderHandler2.getColor());
                GuiConfig.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("Hasn't died yet").func_240699_a_(TextFormatting.ITALIC), (int)textPos, (int)(this.guiTop + 130), (int)this.colorSliderHandler3.getColor());
                GuiConfig.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("but will soon").func_240699_a_(TextFormatting.ITALIC), (int)textPos, (int)(this.guiTop + 140), (int)this.colorSliderHandler3.getColor());
                break;
            }
            case MISC: {
                ((Object)((Object)this)).getClass();
                GuiConfig.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiLeft + 200 - 5), (int)(this.guiTop + 194), (int)0x55000000);
                this.miscList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                break;
            }
            case EFFECT: {
                ((Object)((Object)this)).getClass();
                GuiConfig.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 35), (int)(this.guiLeft + 200 - 5), (int)(this.guiTop + 194), (int)0x55000000);
                this.effectList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                GuiConfig.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.colorSliderHandler0.getTitle(), (int)(this.guiLeft + 20), (int)(this.guiTop + 149), (int)this.colorSliderHandler0.getColor());
                GuiConfig.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.colorSliderHandler4.getTitle(), (int)(this.guiLeft + 20), (int)(this.guiTop + 174), (int)this.colorSliderHandler4.getColor());
            }
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private ConfigState getConfigState(boolean update) {
        if (!update) {
            return this.playerPreference.hasChangedFromConfig() || this.config_changed_predics.stream().anyMatch(p -> p.test(false)) ? ConfigState.CHANGED : ConfigState.UNCHANGED;
        }
        long countChanged = this.config_changed_predics.stream().filter(p -> p.test(true)).count();
        boolean requirePacket = this.playerPreference.hasChangedFromConfig();
        if (requirePacket) {
            this.playerPreference.updateClientConfig();
        }
        return requirePacket ? ConfigState.REQUIRED_PACKET : (countChanged > 0L ? ConfigState.CHANGED : ConfigState.UNCHANGED);
    }

    private void saveConfig() {
        ConfigState result;
        if (this.saveButtonHighlight && (result = this.getConfigState(true)).isChanged()) {
            ConfigTombstone.CLIENT_SPEC.save();
            if (result.requirePacket()) {
                ModTombstone.PROXY.markConfigDirty();
            }
        }
        this.func_231175_as__();
    }

    private <T> boolean checkConfig(ForgeConfigSpec.ConfigValue<T> config, T newValue, boolean update) {
        if (!newValue.equals(config.get())) {
            if (update) {
                config.set(newValue);
            }
            return true;
        }
        return false;
    }

    static enum TabConfig implements IHideable
    {
        GRAVE,
        PLATE,
        MISC,
        EFFECT;

        final List<IHideable> hideables = new ArrayList<IHideable>();

        void attach(IHideable ... theHideables) {
            this.hideables.addAll(Arrays.asList(theHideables));
        }

        void attach(final Widget button) {
            this.hideables.add(new IHideable(){

                @Override
                public void show() {
                    button.field_230694_p_ = true;
                    button.field_230693_o_ = true;
                }

                @Override
                public void hide() {
                    button.field_230694_p_ = false;
                    button.field_230693_o_ = false;
                }
            });
        }

        @Override
        public void show() {
            for (IHideable hideable : this.hideables) {
                hideable.show();
            }
        }

        @Override
        public void hide() {
            for (IHideable hideable : this.hideables) {
                hideable.hide();
            }
        }

        static void hideAll() {
            Stream.of(TabConfig.values()).forEach(TabConfig::hide);
        }

        static void clear() {
            Stream.of(TabConfig.values()).forEach(tab -> tab.hideables.clear());
        }
    }

    public static interface IHideable {
        public void show();

        public void hide();
    }

    static enum ConfigState {
        UNCHANGED,
        CHANGED,
        REQUIRED_PACKET;


        boolean isChanged() {
            return this != UNCHANGED;
        }

        boolean requirePacket() {
            return this == REQUIRED_PACKET;
        }
    }
}

