/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class GuiInfo
extends TBScreen {
    private static final ITextComponent DEFAULT_TITLE = new TranslationTextComponent("tombstone.compendium.main.title");
    private static final ITextComponent DEFAULT_DESCRIPTION = new TranslationTextComponent("tombstone.compendium.main.desc");
    private Info currentInfo;
    private Info lastInfo;
    private Info hoveredInfo = null;
    private int linesByPage;
    private int pageCount;
    private int currentPage;
    private final List<IReorderingProcessor> contentLines = new ArrayList<IReorderingProcessor>();
    private final List<InfoLink> infoLinks = new ArrayList<InfoLink>();
    private ItemStack icon;

    GuiInfo(@Nullable Info currentInfo) {
        super(DEFAULT_TITLE);
        this.currentInfo = this.lastInfo = currentInfo;
        this.currentPage = 0;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0 && this.hoveredInfo != null) {
            this.currentInfo = this.hoveredInfo;
            return true;
        }
        return false;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new CustomButton(this.halfWidth - 35, this.guiBottom - 25, 70, 15, (ITextComponent)LangKey.MESSAGE_BACK.getText(new Object[0]), pressable -> {
            if (this.currentInfo == null) {
                this.getThePlayer().func_71053_j();
            } else {
                this.currentInfo = null;
            }
        }));
        this.func_230480_a_((Widget)new ChangePageButton(this.halfWidth - 23 - 65, this.guiBottom - 25, false, pressable -> {
            --this.currentPage;
            this.updateButtons();
        }, true));
        this.func_230480_a_((Widget)new ChangePageButton(this.halfWidth + 65, this.guiBottom - 25, true, pressable -> {
            ++this.currentPage;
            this.updateButtons();
        }, true));
        this.updatePage(this.currentInfo);
    }

    private void updateContent(@Nullable Info currentInfo) {
        List<Info> infos;
        this.contentLines.clear();
        this.infoLinks.clear();
        this.icon = currentInfo == null ? new ItemStack((IItemProvider)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.TOMBSTONE)) : (ItemStack)currentInfo.icon.get();
        ITextComponent content = Optional.ofNullable(currentInfo).map(Info::getContent).orElse(DEFAULT_DESCRIPTION);
        ((Object)((Object)this)).getClass();
        this.contentLines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)content, 200 - 15));
        ((Object)((Object)this)).getClass();
        int x = this.guiLeft + 200 + 5;
        int y = this.guiTop + 10;
        if (currentInfo == null) {
            infos = Arrays.stream(Info.values()).filter(p -> ((Info)p).isMainEntry).collect(Collectors.toList());
        } else {
            infos = Info.getRelated(currentInfo);
            infos.sort(Comparator.comparing(p -> Normalizer.normalize(p.getTitle().getString(), Normalizer.Form.NFD)));
        }
        for (Info info : infos) {
            this.infoLinks.add(new InfoLink(info, x, y));
            this.field_230712_o_.getClass();
            y += 9 + 1;
        }
    }

    private void updatePage(@Nullable Info currentInfo) {
        if (this.lastInfo != currentInfo) {
            this.currentPage = 0;
        }
        this.lastInfo = currentInfo;
        this.updateContent(currentInfo);
        this.linesByPage = 12;
        this.pageCount = MathHelper.func_76123_f((float)((float)this.contentLines.size() / (float)this.linesByPage));
        this.updateButtons();
    }

    private void updateButtons() {
        ((Widget)this.field_230710_m_.get((int)1)).field_230694_p_ = this.currentPage > 0;
        ((Widget)this.field_230710_m_.get((int)1)).field_230693_o_ = ((Widget)this.field_230710_m_.get((int)1)).field_230694_p_;
        ((Widget)this.field_230710_m_.get((int)2)).field_230694_p_ = this.currentPage < this.pageCount - 1;
        ((Widget)this.field_230710_m_.get((int)2)).field_230693_o_ = ((Widget)this.field_230710_m_.get((int)2)).field_230694_p_;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        this.func_230446_a_(matrixStack);
        this.hoveredInfo = null;
        if (this.currentInfo != this.lastInfo) {
            this.updatePage(this.currentInfo);
        }
        ((Object)((Object)this)).getClass();
        this.field_230712_o_.getClass();
        GuiInfo.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)(this.guiLeft + 200 - 5), (int)(this.guiTop + 20 + 9), (int)0x55000000);
        float f = this.guiLeft + 30;
        float f2 = this.guiTop + 15;
        ((Object)((Object)this)).getClass();
        this.field_230712_o_.func_243248_b(matrixStack, Optional.ofNullable(this.currentInfo).map(Info::getTitle).orElse(DEFAULT_TITLE), f, f2, -1);
        if (this.currentInfo != null) {
            String string = this.currentPage + 1 + "/" + this.pageCount;
            ((Object)((Object)this)).getClass();
            float f3 = this.guiLeft + 200 - 30;
            float f4 = this.guiTop + 6;
            ((Object)((Object)this)).getClass();
            this.field_230712_o_.func_238421_b_(matrixStack, string, f3, f4, -1);
        }
        if (!this.icon.func_190926_b()) {
            this.field_230712_o_.getClass();
            this.field_230712_o_.getClass();
            GuiInfo.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 6), (int)(this.guiTop + 6), (int)(this.guiLeft + 19 + 9), (int)(this.guiTop + 19 + 9), (int)-16760736);
            this.field_230712_o_.getClass();
            this.field_230712_o_.getClass();
            GuiInfo.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 7), (int)(this.guiTop + 7), (int)(this.guiLeft + 18 + 9), (int)(this.guiTop + 18 + 9), (int)-2130706433);
            this.field_230707_j_.func_180450_b(this.icon, (int)((float)(this.guiLeft + 9) / 1.0f), (int)((float)(this.guiTop + 9) / 1.0f));
        }
        int indexStart = Math.min(this.currentPage * this.linesByPage, this.contentLines.size() - 1);
        int indexEnd = Math.min(indexStart + this.linesByPage - 1, this.contentLines.size() - 1);
        if (indexStart >= 0) {
            ((Object)((Object)this)).getClass();
            this.field_230712_o_.getClass();
            GuiInfo.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 34), (int)(this.guiLeft + 200 - 5), (int)(this.guiTop + 44 + (9 + 1) * (indexEnd - indexStart + 1)), (int)0x55000000);
            int count = 0;
            for (int i = indexStart; i <= indexEnd; ++i) {
                IReorderingProcessor line = this.contentLines.get(i);
                float f5 = this.guiLeft + 10;
                this.field_230712_o_.getClass();
                float f6 = this.guiTop + 39 + count * (9 + 1);
                ((Object)((Object)this)).getClass();
                this.field_230712_o_.func_238407_a_(matrixStack, line, f5, f6, -1);
                ++count;
            }
        }
        for (InfoLink link : this.infoLinks) {
            if (this.hoveredInfo == null && link.isHovered(mouseX, mouseY)) {
                this.hoveredInfo = link.info;
                this.field_230712_o_.func_243248_b(matrixStack, link.info.getTitle(), (float)link.x, (float)link.y, -7769547);
                continue;
            }
            ITextComponent iTextComponent = link.info.getTitle();
            float f7 = link.x;
            float f8 = link.y;
            ((Object)((Object)this)).getClass();
            this.field_230712_o_.func_243248_b(matrixStack, iTextComponent, f7, f8, -1);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
    }

    static enum Info {
        DEATH(() -> new ItemStack((IItemProvider)ModItems.advancement[0]), true),
        DECORATIVE_GRAVE(() -> new ItemStack((IItemProvider)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.GRAVE_SIMPLE)), true, "tombstone.config_cat.decorative_grave"),
        MAGIC_ITEMS(() -> new ItemStack((IItemProvider)ModItems.advancement[2]), true),
        ENCHANTMENTS(() -> new ItemStack((IItemProvider)Items.field_151134_bR), true),
        KNOWLEDGE_OF_DEATH(() -> new ItemStack((IItemProvider)ModItems.ankh_of_pray), true, "tombstone.message.knowledge_of_death"),
        SPECIAL_BONUS(() -> ItemStack.field_190927_a, true),
        SHADOW_STEP(() -> new ItemStack((IItemProvider)Items.field_151134_bR), false),
        SOULBOUND(() -> new ItemStack((IItemProvider)Items.field_151134_bR), false),
        MAGIC_SIPHON(() -> new ItemStack((IItemProvider)Items.field_151134_bR), false),
        PLAGUE_BRINGER(() -> new ItemStack((IItemProvider)Items.field_151134_bR), false),
        CURSE_OF_BONES(() -> new ItemStack((IItemProvider)Items.field_151134_bR), false),
        BLESSING(() -> new ItemStack((IItemProvider)Items.field_151134_bR), false),
        ALIGNMENT(() -> new ItemStack((IItemProvider)ModItems.advancement[7]), false),
        ANKH_OF_PRAY(() -> new ItemStack((IItemProvider)ModItems.ankh_of_pray), false, "tombstone.item.ankh_of_pray"),
        BONE_NEEDLE(() -> new ItemStack((IItemProvider)ModItems.bone_needle), false, "tombstone.item.bone_needle"),
        BOOK_OF_DISENCHANTMENT(() -> new ItemStack((IItemProvider)ModItems.book_of_disenchantment), false, "tombstone.item.book_of_disenchantment"),
        CONTRIBUTOR(() -> ItemStack.field_190927_a, false, (ITextComponent)new StringTextComponent("Contributor"), (ITextComponent)new StringTextComponent("To encourage people to participate in the mod by reporting bugs and providing translations, they are sometimes given a temporary special in-game bonus.\nThis bonus may vary from version to version, the currents being :\n- the cooldown duration of the Ankh of Pray is reduced by 50%\n- can use the pray of protection with a neutral alignment")),
        GRAVE_MARBLE(() -> new ItemStack((IItemProvider)ModBlocks.dark_marble), false, "tombstone.block.dark_marble"),
        DUST_OF_VANISHING(() -> new ItemStack((IItemProvider)ModItems.dust_of_vanishing), false, "tombstone.item.dust_of_vanishing"),
        ESSENCE_OF_UNDEATH(() -> new ItemStack((IItemProvider)ModItems.essence_of_undeath), false, "tombstone.item.essence_of_undeath"),
        FAMILIAR_RECEPTACLE(() -> new ItemStack((IItemProvider)ModItems.familiar_receptacle), false, "tombstone.item.familiar_receptacle"),
        FISHING_ROD_OF_MISADVENTURE(() -> new ItemStack((IItemProvider)ModItems.fishing_rod_of_misadventure), false, "tombstone.item.fishing_rod_of_misadventure"),
        GHOSTLY_SHAPE(() -> new ItemStack((IItemProvider)ModItems.advancement[1]), false, "effect.tombstone.ghostly_shape"),
        GRAVE_DUST(() -> new ItemStack((IItemProvider)ModItems.grave_dust), false, "tombstone.item.grave_dust"),
        GRAVE_KEY(() -> new ItemStack((IItemProvider)ModItems.grave_key), false, "tombstone.item.grave_key"),
        GRAVE_PLATE(() -> EngravableHelper.setEngravedName(new ItemStack((IItemProvider)ModItems.grave_plate), "named"), false, "tombstone.item.grave_plate"),
        HALLOWEEN(() -> new ItemStack((IItemProvider)ModItems.advancement[6]), false),
        IMPREGNATED_DIAMOND(() -> new ItemStack((IItemProvider)ModItems.impregnated_diamond), false, "tombstone.item.impregnated_diamond"),
        LOLLIPOP(() -> new ItemStack((IItemProvider)ModItems.lollipop), false, "tombstone.item.lollipop"),
        LOST_TABLET(() -> new ItemStack((IItemProvider)ModItems.lost_tablet), false, "tombstone.item.lost_tablet"),
        PERK(() -> ItemStack.field_190927_a, false),
        SCROLL_OF_FEATHER_FALL(() -> new ItemStack((IItemProvider)ModItems.scroll_buff[2]), false, "tombstone.item.scroll_of_feather_fall"),
        SCROLL_OF_KNOWLEDGE(() -> new ItemStack((IItemProvider)ModItems.scroll_of_knowledge), false, "tombstone.item.scroll_of_knowledge"),
        SCROLL_OF_PRESERVATION(() -> new ItemStack((IItemProvider)ModItems.scroll_buff[0]), false, "tombstone.item.scroll_of_preservation"),
        SCROLL_OF_PURIFICATION(() -> new ItemStack((IItemProvider)ModItems.scroll_buff[3]), false, "tombstone.item.scroll_of_purification"),
        SCROLL_OF_TRUE_SIGHT(() -> new ItemStack((IItemProvider)ModItems.scroll_buff[4]), false, "tombstone.item.scroll_of_true_sight"),
        SCROLL_OF_UNSTABLE_INTANGIBLENESS(() -> new ItemStack((IItemProvider)ModItems.scroll_buff[1]), false, "tombstone.item.scroll_of_unstable_intangibleness"),
        SCROLL_OF_REACH(() -> new ItemStack((IItemProvider)ModItems.scroll_buff[5]), false, "tombstone.item.scroll_of_reach"),
        SCROLL_OF_LIGHTNING_RESISTANCE(() -> new ItemStack((IItemProvider)ModItems.scroll_buff[6]), false, "tombstone.item.scroll_of_lightning_resistance"),
        SCROLL_OF_FROST_RESISTANCE(() -> new ItemStack((IItemProvider)ModItems.scroll_buff[7]), false, "tombstone.item.scroll_of_frost_resistance"),
        SCROLL_OF_AQUATIC_LIFE(() -> new ItemStack((IItemProvider)ModItems.scroll_buff[8]), false, "tombstone.item.scroll_of_aquatic_life"),
        MAGIC_SCROLLS(() -> new ItemStack((IItemProvider)ModItems.strange_scroll), false),
        SOUL(() -> new ItemStack((IItemProvider)ModItems.advancement[5]), false),
        SOUL_RECEPTACLE(() -> new ItemStack((IItemProvider)ModItems.soul_receptacle), false, "tombstone.item.soul_receptacle"),
        STRANGE_SCROLL(() -> new ItemStack((IItemProvider)ModItems.strange_scroll), false, "tombstone.item.strange_scroll"),
        STRANGE_TABLET(() -> new ItemStack((IItemProvider)ModItems.strange_tablet), false, "tombstone.item.strange_tablet"),
        TABLET_OF_HOME(() -> new ItemStack((IItemProvider)ModItems.tablet_of_home), false, "tombstone.item.tablet_of_home"),
        TABLET_OF_RECALL(() -> new ItemStack((IItemProvider)ModItems.tablet_of_recall), false, "tombstone.item.tablet_of_recall"),
        TABLET_OF_ASSISTANCE(() -> new ItemStack((IItemProvider)ModItems.tablet_of_assistance), false, "tombstone.item.tablet_of_assistance"),
        TABLET_OF_CUPIDITY(() -> new ItemStack((IItemProvider)ModItems.tablet_of_cupidity), false, "tombstone.item.tablet_of_cupidity"),
        MAGIC_TABLETS(() -> new ItemStack((IItemProvider)ModItems.strange_tablet), false),
        VOODOO_POPPET(() -> new ItemStack((IItemProvider)ModItems.voodoo_poppet), false, "tombstone.item.voodoo_poppet");

        private final Supplier<ItemStack> icon;
        private final boolean isMainEntry;
        private final ITextComponent title;
        private final ITextComponent description;

        private Info(Supplier<ItemStack> icon, boolean isMainEntry) {
            this(icon, isMainEntry, null);
        }

        private Info(@Nullable Supplier<ItemStack> icon, boolean isMainEntry, String titleKey) {
            this.icon = icon;
            this.isMainEntry = isMainEntry;
            this.title = new TranslationTextComponent(titleKey == null ? "tombstone.compendium." + this.name().toLowerCase(Locale.US) + ".title" : titleKey);
            this.description = new TranslationTextComponent("tombstone.compendium." + this.name().toLowerCase(Locale.US) + ".desc");
        }

        private Info(Supplier<ItemStack> icon, boolean isMainEntry, ITextComponent title, ITextComponent description) {
            this.icon = icon;
            this.isMainEntry = isMainEntry;
            this.title = title;
            this.description = description;
        }

        public final ITextComponent getTitle() {
            return this.title;
        }

        public final ITextComponent getContent() {
            return this.description;
        }

        public static List<Info> getRelated(Info info) {
            ArrayList<Info> infos = new ArrayList<Info>();
            switch (info) {
                case ALIGNMENT: {
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(ANKH_OF_PRAY);
                    break;
                }
                case ANKH_OF_PRAY: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    infos.add(ALIGNMENT);
                    break;
                }
                case BONE_NEEDLE: {
                    infos.add(GRAVE_DUST);
                    infos.add(IMPREGNATED_DIAMOND);
                    infos.add(FAMILIAR_RECEPTACLE);
                    break;
                }
                case BOOK_OF_DISENCHANTMENT: {
                    infos.add(MAGIC_ITEMS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case CONTRIBUTOR: 
                case HALLOWEEN: {
                    infos.add(LOLLIPOP);
                    infos.add(SPECIAL_BONUS);
                    break;
                }
                case GRAVE_MARBLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(GRAVE_DUST);
                    break;
                }
                case DEATH: {
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(GRAVE_KEY);
                    infos.add(PERK);
                    break;
                }
                case DECORATIVE_GRAVE: {
                    infos.add(GRAVE_MARBLE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    infos.add(GRAVE_PLATE);
                    infos.add(ESSENCE_OF_UNDEATH);
                    break;
                }
                case DUST_OF_VANISHING: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case ENCHANTMENTS: {
                    infos.add(SHADOW_STEP);
                    infos.add(SOULBOUND);
                    infos.add(MAGIC_SIPHON);
                    infos.add(PLAGUE_BRINGER);
                    infos.add(CURSE_OF_BONES);
                    infos.add(BLESSING);
                    break;
                }
                case SHADOW_STEP: 
                case SOULBOUND: 
                case MAGIC_SIPHON: 
                case PLAGUE_BRINGER: 
                case CURSE_OF_BONES: 
                case BLESSING: {
                    infos.add(ENCHANTMENTS);
                    break;
                }
                case ESSENCE_OF_UNDEATH: 
                case GRAVE_PLATE: {
                    infos.add(DECORATIVE_GRAVE);
                    break;
                }
                case FAMILIAR_RECEPTACLE: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(IMPREGNATED_DIAMOND);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    infos.add(BONE_NEEDLE);
                    break;
                }
                case FISHING_ROD_OF_MISADVENTURE: {
                    infos.add(LOST_TABLET);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case GHOSTLY_SHAPE: {
                    infos.add(DEATH);
                    break;
                }
                case GRAVE_DUST: {
                    infos.add(GRAVE_MARBLE);
                    infos.add(DUST_OF_VANISHING);
                    infos.add(IMPREGNATED_DIAMOND);
                    infos.add(BONE_NEEDLE);
                    break;
                }
                case GRAVE_KEY: {
                    infos.add(DEATH);
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case KNOWLEDGE_OF_DEATH: {
                    infos.add(ALIGNMENT);
                    infos.add(ANKH_OF_PRAY);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(SOUL);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case IMPREGNATED_DIAMOND: {
                    infos.add(GRAVE_DUST);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(BONE_NEEDLE);
                    break;
                }
                case LOLLIPOP: {
                    infos.add(CONTRIBUTOR);
                    infos.add(HALLOWEEN);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case LOST_TABLET: {
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(MAGIC_TABLETS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case MAGIC_ITEMS: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(BOOK_OF_DISENCHANTMENT);
                    infos.add(DUST_OF_VANISHING);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(GRAVE_KEY);
                    infos.add(LOLLIPOP);
                    infos.add(MAGIC_SCROLLS);
                    infos.add(MAGIC_TABLETS);
                    infos.add(SOUL_RECEPTACLE);
                    infos.add(VOODOO_POPPET);
                    break;
                }
                case MAGIC_SCROLLS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(PERK);
                    infos.add(SOUL);
                    infos.add(STRANGE_SCROLL);
                    infos.add(SCROLL_OF_AQUATIC_LIFE);
                    infos.add(SCROLL_OF_FEATHER_FALL);
                    infos.add(SCROLL_OF_FROST_RESISTANCE);
                    infos.add(SCROLL_OF_KNOWLEDGE);
                    infos.add(SCROLL_OF_LIGHTNING_RESISTANCE);
                    infos.add(SCROLL_OF_PRESERVATION);
                    infos.add(SCROLL_OF_PURIFICATION);
                    infos.add(SCROLL_OF_REACH);
                    infos.add(SCROLL_OF_TRUE_SIGHT);
                    infos.add(SCROLL_OF_UNSTABLE_INTANGIBLENESS);
                    break;
                }
                case STRANGE_SCROLL: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_SCROLLS);
                    break;
                }
                case STRANGE_TABLET: {
                    infos.add(GRAVE_MARBLE);
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_TABLETS);
                    break;
                }
                case MAGIC_TABLETS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(PERK);
                    infos.add(LOST_TABLET);
                    infos.add(SOUL);
                    infos.add(STRANGE_TABLET);
                    infos.add(TABLET_OF_ASSISTANCE);
                    infos.add(TABLET_OF_CUPIDITY);
                    infos.add(TABLET_OF_HOME);
                    infos.add(TABLET_OF_RECALL);
                    break;
                }
                case PERK: {
                    infos.add(DEATH);
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case SCROLL_OF_FEATHER_FALL: 
                case SCROLL_OF_KNOWLEDGE: 
                case SCROLL_OF_PRESERVATION: 
                case SCROLL_OF_PURIFICATION: 
                case SCROLL_OF_TRUE_SIGHT: 
                case SCROLL_OF_REACH: 
                case SCROLL_OF_LIGHTNING_RESISTANCE: 
                case SCROLL_OF_FROST_RESISTANCE: 
                case SCROLL_OF_AQUATIC_LIFE: 
                case SCROLL_OF_UNSTABLE_INTANGIBLENESS: {
                    infos.add(MAGIC_SCROLLS);
                    infos.add(SOUL);
                    break;
                }
                case SOUL: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case SOUL_RECEPTACLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case SPECIAL_BONUS: {
                    infos.add(CONTRIBUTOR);
                    infos.add(HALLOWEEN);
                    break;
                }
                case TABLET_OF_ASSISTANCE: 
                case TABLET_OF_CUPIDITY: 
                case TABLET_OF_HOME: 
                case TABLET_OF_RECALL: {
                    infos.add(MAGIC_TABLETS);
                    infos.add(SOUL);
                    break;
                }
                case VOODOO_POPPET: {
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                }
            }
            return infos;
        }
    }

    public class InfoLink {
        private final Info info;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        InfoLink(Info info, int x, int y) {
            this.info = info;
            this.x = x;
            this.y = y;
            this.width = GuiInfo.this.field_230712_o_.func_238414_a_((ITextProperties)info.getTitle());
            GuiInfo.this.field_230712_o_.getClass();
            this.height = 9 + 1;
        }

        private boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.width & mouseY <= this.y + this.height;
        }
    }
}

