/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootHelper {
    private static final Field fieldPools = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");

    private static void addEntry(LootPool.Builder builder, Item item, int weight, Consumer<CompoundNBT> consumer) {
        builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_216085_b(0).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)((CompoundNBT)Util.func_200696_a((Object)new CompoundNBT(), consumer)))));
    }

    private static void addEnchantedEntry(LootPool.Builder builder, Item item, int weight) {
        LootHelper.addEntry(builder, item, weight, nbt -> nbt.func_74757_a("enchant", true));
    }

    private static void addAncientTablet(LootPool.Builder builder, ItemTablet item, int weight) {
        LootHelper.addEntry(builder, item, weight, nbt -> nbt.func_74757_a("ancient", true));
    }

    private static void addDelayedNBTEntry(LootPool.Builder builder, Item item, int weight) {
        builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_216085_b(0).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)new DelayedNBTFunction.Builder()));
    }

    public static void addLostEntries(LootTable table) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:lost_treasure");
        builder.func_212840_b_(InOpenWaterCondition.builder());
        int weight = 0;
        ItemLootEntry.func_216168_a((IItemProvider)ModItems.essence_of_undeath).func_216085_b(0).func_216086_a(1);
        if (ModItems.tablet_of_recall.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_recall, 3);
            weight += 3;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_home, 3);
            weight += 3;
        }
        if (ModItems.tablet_of_assistance.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_assistance, 3);
            weight += 3;
        }
        if (ModItems.tablet_of_cupidity.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_cupidity, 3);
            weight += 3;
        }
        if (ModItems.voodoo_poppet.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10);
            weight += 10;
        }
        if (ModItems.familiar_receptacle.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.familiar_receptacle, 10);
            weight += 10;
        }
        int lostTabletChance = (Integer)SharedConfigTombstone.loot.chanceLootLostTablet.get();
        if (ModItems.lost_tablet.isEnabled() && lostTabletChance > 0) {
            builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.lost_tablet).func_216085_b(0).func_216086_a(lostTabletChance));
            weight += lostTabletChance;
        }
        if (weight > 0) {
            if (weight < 1000) {
                builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(0).func_216086_a(1000 - weight));
            }
            LootHelper.addPool(builder.func_216044_b(), table);
        }
    }

    private static void addPool(LootPool pool, LootTable table) {
        try {
            List pools = (List)fieldPools.get(table);
            pools.removeIf(aPool -> aPool == pool || pool.getName().equals(aPool.getName()));
            pools.add(pool);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void addChestEntries(LootTable table) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:chest_treasure");
        int weight = 0;
        for (ItemScrollBuff scroll : ModItems.scroll_buff) {
            if (!scroll.isEnabled()) continue;
            LootHelper.addEnchantedEntry(builder, scroll, 10);
            weight += 10;
        }
        if (ModItems.scroll_of_knowledge.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 10);
            weight += 10;
        }
        if (ModItems.tablet_of_cupidity.isEnabled()) {
            LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_cupidity, 10);
            weight += 10;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_home, 10);
            weight += 10;
        }
        if (ModItems.voodoo_poppet.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10);
            weight += 10;
        }
        if (ModItems.familiar_receptacle.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.familiar_receptacle, 10);
            weight += 10;
        }
        if (weight > 0) {
            if (weight < 1000) {
                builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(0).func_216086_a(1000 - weight));
            }
            LootHelper.addPool(builder.func_216044_b(), table);
        }
    }

    private static void addCatMorningEntries(LootTable table) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:cat_morning");
        builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.grave_dust).func_216085_b(0).func_216086_a(100).func_212841_b_((ILootFunction.IBuilder)new TriggerCatMorningFunction.Builder()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))));
        builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.essence_of_undeath).func_216085_b(0).func_216086_a(1));
        int weight = 101;
        builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(0).func_216086_a(1000 - weight));
        LootHelper.addPool(builder.func_216044_b(), table);
    }

    public static void handleMobDrops(Collection<ItemEntity> drops, LivingEntity entity, ServerPlayerEntity player) {
        Random rng = Helper.random;
        int boneCollectorLevel = EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.bone_collector);
        double chanceModifier = 1.0 + (double)boneCollectorLevel * 0.3;
        if (EntityHelper.isUndead(entity)) {
            if ((Integer)ConfigTombstone.loot.chanceGraveDust.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceGraveDust.get()).intValue() * chanceModifier)) {
                LootHelper.addDropToEntity(drops, entity, new ItemStack((IItemProvider)ModItems.grave_dust, rng.nextInt(2) + 1));
                ModTriggers.GRAVE_DUST_FROM_UNDEAD.trigger(player);
            }
            if (LootHelper.checkLoot(rng, 1 + boneCollectorLevel)) {
                LootHelper.addDropToEntity(drops, entity, new ItemStack((IItemProvider)ModItems.essence_of_undeath));
            }
            if (EntityHelper.isBoss(entity)) {
                ItemScrollBuff.SpellBuff randomBuff;
                if ((Integer)ConfigTombstone.loot.chanceSoulReceptacleOnBoss.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceSoulReceptacleOnBoss.get()).intValue() * chanceModifier)) {
                    LootHelper.addDropToEntity(drops, entity, new ItemStack((IItemProvider)ModItems.soul_receptacle));
                }
                if ((Integer)ConfigTombstone.loot.chanceRandomScrollOnBoss.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceRandomScrollOnBoss.get()).intValue() * chanceModifier) && (randomBuff = ItemScrollBuff.SpellBuff.getRandomBuff()).isEnable()) {
                    LootHelper.addDropToEntity(drops, entity, NBTStackHelper.setBoolean(new ItemStack((IItemProvider)ModItems.scroll_buff[randomBuff.ordinal()]), "enchant", true));
                }
                if (ModItems.voodoo_poppet.isEnabled() && (Integer)ConfigTombstone.loot.chanceVoodooPoppetOnBoss.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceVoodooPoppetOnBoss.get()).intValue() * chanceModifier)) {
                    LootHelper.addDropToEntity(drops, entity, ModItems.voodoo_poppet.createWithRandomProtections(Helper.random.nextInt(5) + 1));
                }
                if (ModItems.familiar_receptacle.isEnabled() && (Integer)ConfigTombstone.loot.chanceFamiliarReceptacleOnBoss.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceFamiliarReceptacleOnBoss.get()).intValue() * chanceModifier)) {
                    LootHelper.addDropToEntity(drops, entity, ModItems.familiar_receptacle.createWithRandomFamiliar());
                }
            }
        }
        if (TimeHelper.isDateAroundHalloween() && entity instanceof IMob && LootHelper.checkLoot(rng, 100.0 * chanceModifier)) {
            LootHelper.addDropToEntity(drops, entity, ModItems.lollipop.getRandom());
        }
    }

    private static boolean checkLoot(Random rng, double chance) {
        return chance >= 1000.0 || (double)rng.nextInt(1000) < chance;
    }

    private static void addDropToEntity(Collection<ItemEntity> drops, LivingEntity entity, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            drops.add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTables.field_186388_am)) {
            LootHelper.addLostEntries(event.getTable());
        } else if (event.getName().equals((Object)LootTables.field_215797_af)) {
            LootHelper.addCatMorningEntries(event.getTable());
        } else if (!event.getName().equals((Object)LootTables.field_186420_b)) {
            Optional.ofNullable(event.getName()).map(ResourceLocation::func_110623_a).filter(name -> name.startsWith("chests") && !name.startsWith("chests/village/") && !name.contains("supply")).ifPresent(name -> LootHelper.addChestEntries(event.getTable()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().func_200600_R() != EntityType.field_200729_aH && !event.getEntityLiving().field_70170_p.func_201670_d()) {
            Optional.ofNullable(event.getSource()).filter(d -> EntityHelper.isValidServerPlayer(d.func_76346_g())).map(d -> (ServerPlayerEntity)d.func_76346_g()).ifPresent(player -> LootHelper.handleMobDrops(event.getDrops(), event.getEntityLiving(), player));
        }
    }
}

