/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class TimeHelper {
    public static long SERVER_START_TIME;
    public static boolean IS_APRIL_FOOLS;
    public static boolean IS_HALLOWEEN;
    private static final String[] UNITY;

    public static void init() {
        SERVER_START_TIME = TimeHelper.systemTime();
        LocalDate date = LocalDate.now();
        IS_APRIL_FOOLS = date.get(ChronoField.MONTH_OF_YEAR) == 4 && date.get(ChronoField.DAY_OF_MONTH) == 1;
        IS_HALLOWEEN = !IS_APRIL_FOOLS && (date.get(ChronoField.MONTH_OF_YEAR) == 10 && date.get(ChronoField.DAY_OF_MONTH) >= 20 || date.get(ChronoField.MONTH_OF_YEAR) == 11 && date.get(ChronoField.DAY_OF_MONTH) <= 3);
    }

    public static boolean isSystemTimeElapsedSinceServerStart(int minute) {
        return TimeHelper.systemTime() - SERVER_START_TIME >= TimeUnit.MINUTES.toMillis(minute);
    }

    public static long systemTime() {
        return System.currentTimeMillis();
    }

    public static boolean isAprilFoolsDay() {
        return IS_APRIL_FOOLS;
    }

    public static boolean isDateAroundHalloween() {
        return IS_HALLOWEEN;
    }

    public static long worldTicks(World world) {
        return world.func_82737_E();
    }

    public static int tickFromSecond(int second) {
        return second * 20;
    }

    public static int tickFromMinute(int minute) {
        return minute * 1200;
    }

    public static int tickFromHour(int hour) {
        return hour * 72000;
    }

    public static int tickFromDay(int day) {
        return day * 1728000;
    }

    public static boolean atInterval(Entity entity, int tick) {
        return TimeHelper.atInterval(entity.field_70173_aa, tick);
    }

    public static boolean atInterval(World world, int tick) {
        return TimeHelper.atInterval(TimeHelper.worldTicks(world), tick);
    }

    public static boolean atInterval(long ticksExisted, int tick) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval == 0L);
    }

    public static boolean inIntervalBefore(long ticksExisted, int tick, int intervalStart) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval < (long)intervalStart);
    }

    public static boolean inIntervalAfter(long ticksExisted, int tick, int intervalStart) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval > (long)intervalStart);
    }

    public static boolean testInterval(long ticksExisted, int tick, Predicate<Long> intervalPredic) {
        return ticksExisted > 0L && intervalPredic.test(ticksExisted % (long)tick);
    }

    public static long minuteElapsed(World world, long oldTime) {
        return TimeHelper.minuteElapsed(TimeHelper.worldTicks(world), oldTime);
    }

    public static long minuteElapsed(long nowTime, long oldTime) {
        return (nowTime - oldTime) / 1200L;
    }

    public static boolean isMinuteElapsed(World world, long oldTime, int minute) {
        return TimeHelper.isMinuteElapsed(TimeHelper.worldTicks(world), oldTime, minute);
    }

    public static boolean isMinuteElapsed(long nowTime, long oldTime, int minute) {
        return nowTime - oldTime >= (long)TimeHelper.tickFromMinute(minute);
    }

    public static String getTimeString(int cd) {
        return TimeHelper.getTimeString(cd, i -> ":", false);
    }

    public static String getTimeStringWithUnit(int cd) {
        return TimeHelper.getTimeString(cd, i -> UNITY[i], true);
    }

    private static String getTimeString(int cd, Function<Integer, String> separator, boolean separatorAtEnd) {
        int[] timeArray = TimeHelper.getTimeArray(cd);
        StringBuilder builder = new StringBuilder();
        int start = IntStream.range(0, timeArray.length).filter(i -> timeArray[i] > 0).findFirst().orElse(timeArray.length - 1);
        IntStream.range(start, timeArray.length - 1).forEach(unit -> {
            builder.append(String.format("%02d", timeArray[unit]));
            builder.append((String)separator.apply(unit));
        });
        builder.append(String.format("%02d", timeArray[timeArray.length - 1]));
        if (separatorAtEnd) {
            builder.append(separator.apply(timeArray.length - 1));
        }
        return builder.toString();
    }

    private static int[] getTimeArray(int cd) {
        int[] timeArray = new int[]{0, 0, 0, 0};
        if (cd >= 1728000) {
            timeArray[0] = cd / 1728000;
            cd -= timeArray[0] * 1728000;
        }
        if (cd >= 72000) {
            timeArray[1] = cd / 72000;
            cd -= timeArray[1] * 72000;
        }
        if (cd >= 1200) {
            timeArray[2] = cd / 1200;
            cd -= timeArray[2] * 1200;
        }
        if (cd >= 20) {
            timeArray[3] = cd / 20;
        }
        return timeArray;
    }

    static {
        UNITY = new String[]{"d", "h", "m", "s"};
    }
}

