/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SmokeColumnMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemDustOfVanishing
extends ItemGeneric {
    public ItemDustOfVanishing() {
        super("dust_of_vanishing", () -> SharedConfigTombstone.allowed_magic_items.allowDustOfVanishing.get());
        this.withEffect();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            this.addItemUse(list);
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == this) {
            if (EntityHelper.hasGlobalItemCooldown(player, this)) {
                return new ActionResult(ActionResultType.CONSUME, (Object)stack);
            }
            Vector3d pVec = player.func_213303_ch();
            if (!world.func_201670_d()) {
                world.func_184148_a(null, pVec.field_72450_a, pVec.field_72448_b, pVec.field_72449_c, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 0.5f);
                ServerWorld targetWorld = (ServerWorld)world;
                Location spawnPos = this.findBackwardLocation(targetWorld, player, 8.0);
                if (!spawnPos.isOrigin()) {
                    Helper.teleportEntity(player, spawnPos, targetWorld);
                } else {
                    spawnPos = this.findBackwardLocation(targetWorld, player, 3.0);
                    if (!spawnPos.isOrigin()) {
                        Helper.teleportEntity(player, spawnPos, targetWorld);
                    }
                }
                player.field_70143_R = 0.0f;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                EffectHelper.addEffect((LivingEntity)player, ModEffects.diversion, 100);
                EntityHelper.setGlobalItemCooldown(player, this, 200);
                PacketHandler.sendToAllTrackingPlayers(new SmokeColumnMessage(player.func_145782_y()), (LivingEntity)player);
                ModTriggers.USE_VANISHING.trigger((ServerPlayerEntity)player);
            }
            ModTombstone.PROXY.produceSmokeColumn(world, pVec);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        return ActionResultType.FAIL;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (EntityHelper.isValidPlayer(context.func_195999_j())) {
            return this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a();
        }
        return ActionResultType.FAIL;
    }

    private Location findBackwardLocation(ServerWorld world, PlayerEntity player, double range) {
        Vector3d lookVec = new Vector3d(player.func_70040_Z().field_72450_a, 0.0, player.func_70040_Z().field_72449_c).func_72432_b();
        return new SpawnHelper(world, new BlockPos(player.func_213303_ch().func_178786_a(lookVec.field_72450_a * range, 0.0, lookVec.field_72449_c * range))).findSafePlace(2, true);
    }
}

