/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFamiliarReceptacle
extends ItemGeneric
implements IDelayedNBTLoot {
    private static final String CAPTURABLE_TYPE_NBT_STRING = "capturable_type";
    private static final String DEAD_PET_NBT_COMPOUND = "dead_pet";

    public ItemFamiliarReceptacle() {
        super("familiar_receptacle", ItemFamiliarReceptacle.getBuilder().func_200917_a(1).func_234689_a_(), () -> SharedConfigTombstone.allowed_magic_items.allowFamiliarReceptacle.get());
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && this.isEnabled()) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack stack = new ItemStack((IItemProvider)this);
            CompoundNBT pet_tag = new CompoundNBT();
            pet_tag.func_74778_a("id", TameableType.getRandomTameableEntityTypeString());
            stack.func_196082_o().func_218657_a(DEAD_PET_NBT_COMPOUND, (INBT)pet_tag);
            items.add((Object)stack);
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        String id;
        if (EntityHelper.isValidServerPlayer(player) && !(id = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING)).isEmpty() && !id.equals("unknown")) {
            ModTriggers.IMPREGNATED_RECEPTACLE.trigger((ServerPlayerEntity)player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.containSoul(stack) || super.func_77636_d(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            CompoundNBT pet_tag = this.getDeadPetTag(stack).orElse(null);
            if (pet_tag == null) {
                this.addItemDesc(list, "1", new Object[0]);
                String id = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING);
                if (!id.isEmpty() && !id.equals("unknown")) {
                    list.add((ITextComponent)LangKey.MESSAGE_IMPREGNATE.getText(StyleType.MESSAGE_SPECIAL, new Object[]{LangKey.getEntityName(id)}));
                }
            } else if (pet_tag.func_150297_b("id", 8)) {
                this.addItemDesc(list, "2", LangKey.getEntityName(pet_tag.func_74779_i("id")));
                this.addItemUse(list, this.getDurabilityForDisplay(stack) == 0.0 ? "2" : "1", new Object[0]);
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            int level = (Integer)SharedConfigTombstone.general.familiarReceptacleRequiredLevel.get();
            if (player == null || player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getTotalPerkPoints() < level).orElse(false).booleanValue()) {
                this.addWarn(list, LangKey.MESSAGE_CRAFTING_KNOWLEDGE_REQUIRED, level);
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.func_201670_d() && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && TimeHelper.atInterval(entity, TimeHelper.tickFromMinute(1))) {
            this.getDeadPetTag(stack).ifPresent(pet_tag -> {
                float maxHealth;
                float health = pet_tag.func_150297_b("Health", 5) ? Math.max(0.0f, pet_tag.func_74760_g("Health")) : 1.0f;
                float f = maxHealth = pet_tag.func_150297_b("max_life", 5) ? Math.max(1.0f, pet_tag.func_74760_g("max_life")) : 1.0f;
                if (health < maxHealth) {
                    float gain = maxHealth * 0.1f;
                    PlayerEntity player = (PlayerEntity)entity;
                    pet_tag.func_74776_a("Health", Math.min(health + Math.min(player.func_110143_aJ(), gain), maxHealth));
                    if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue()) {
                        player.func_70097_a(ModDamages.BEYOND_THE_GRAVE, gain);
                    }
                }
            });
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.containSoul(stack) && this.getDurabilityForDisplay(stack) > 0.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getDeadPetTag(stack).map(pet_tag -> {
            float health = pet_tag.func_150297_b("Health", 5) ? Math.max(0.0f, pet_tag.func_74760_g("Health")) : 1.0f;
            float maxHealth = pet_tag.func_150297_b("max_life", 5) ? Math.max(1.0f, pet_tag.func_74760_g("max_life")) : 1.0f;
            return Float.valueOf(1.0f - health / maxHealth);
        }).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public boolean containSoul(ItemStack stack) {
        return stack.func_77973_b() == this && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(DEAD_PET_NBT_COMPOUND, 10);
    }

    private Optional<CompoundNBT> getDeadPetTag(ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p()).filter(tag -> tag.func_150297_b(DEAD_PET_NBT_COMPOUND, 10)).map(tag -> tag.func_74775_l(DEAD_PET_NBT_COMPOUND));
    }

    public boolean revive(PlayerEntity player, BlockPos gravePos, ItemStack stack) {
        return this.getDeadPetTag(stack).map(pet_tag -> pet_tag.func_150297_b("id", 8) && EntityType.func_220327_a((String)pet_tag.func_74779_i("id")).map(entityType -> {
            LivingEntity entity = (LivingEntity)entityType.func_200721_a(player.field_70170_p);
            if (entity == null) {
                return false;
            }
            if (pet_tag.func_74764_b("max_life")) {
                pet_tag.func_82580_o("max_life");
                entity.func_70020_e(pet_tag);
                entity.func_70107_b((double)gravePos.func_177958_n() + 0.5, (double)gravePos.func_177956_o() + 0.5, (double)gravePos.func_177952_p() + 0.5);
            } else if (entity instanceof MobEntity) {
                entity.func_70107_b((double)gravePos.func_177958_n() + 0.5, (double)gravePos.func_177956_o() + 0.5, (double)gravePos.func_177952_p() + 0.5);
                ((MobEntity)entity).func_213386_a((IServerWorld)((ServerWorld)player.field_70170_p), player.field_70170_p.func_175649_E(entity.func_233580_cy_()), SpawnReason.TRIGGERED, null, null);
            }
            entity.func_70606_j(entity.func_110138_aP());
            entity.field_70128_L = false;
            TameableType.setTamedBy(player, (Entity)entity);
            EffectHelper.clearBadEffects(entity);
            player.field_70170_p.func_217376_c((Entity)entity);
            return true;
        }).orElse(false) != false).orElse(false);
    }

    public ItemStack setCapturableType(ItemStack stack, String type) {
        NBTStackHelper.setString(stack, CAPTURABLE_TYPE_NBT_STRING, type);
        return stack;
    }

    private boolean canCaptureSoul(ItemStack stack, LivingEntity entity) {
        String type = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING);
        return type.isEmpty() || type.equals("unknown") || type.equals(EntityHelper.getRegistryString((Entity)entity));
    }

    public boolean captureSoul(LivingEntity entity) {
        MobEntity mob;
        boolean hasReceptacle;
        boolean wasOffline;
        if (entity.field_70170_p.func_201670_d()) {
            return false;
        }
        String entityString = EntityHelper.getRegistryString((Entity)entity);
        if (entityString.isEmpty()) {
            return false;
        }
        TameableType tameableType = TameableType.getType(entityString);
        if (tameableType == null) {
            return false;
        }
        UUID ownerId = tameableType.getOwnerId((Entity)entity);
        MinecraftServer server = entity.func_184102_h();
        if (ownerId == null || server == null) {
            return false;
        }
        ServerPlayerEntity owner = server.func_184103_al().func_177451_a(ownerId);
        boolean bl = wasOffline = owner == null;
        if (wasOffline && (owner = EntityHelper.getOfflinePlayer(server, ownerId)) == null) {
            return false;
        }
        ItemStack receptacle = owner.func_70089_S() ? InventoryHelper.findFirstInInventory((PlayerEntity)owner, stack -> stack.func_77973_b() == this && this.canCaptureSoul((ItemStack)stack, entity) && !this.containSoul((ItemStack)stack)) : ItemStack.field_190927_a;
        boolean bl2 = hasReceptacle = !receptacle.func_190926_b();
        if (hasReceptacle && EventFactory.onCaptureSoul((PlayerEntity)owner, entity)) {
            hasReceptacle = false;
        }
        if (!hasReceptacle && !((Boolean)ConfigTombstone.recovery.recoveryFamiliarEnable.get()).booleanValue()) {
            return false;
        }
        if (entity.func_70608_bn()) {
            entity.func_213366_dy();
        }
        if (entity.func_184218_aH()) {
            entity.func_184210_p();
        }
        if (entity.func_184207_aI()) {
            entity.func_184226_ay();
        }
        if (entity instanceof MobEntity && (mob = (MobEntity)entity).func_110167_bD()) {
            mob.func_110160_i(true, false);
        }
        CompoundNBT pet_tag = entity.serializeNBT();
        pet_tag.func_82580_o("Dimension");
        pet_tag.func_82580_o("Motion");
        pet_tag.func_82580_o("UUID");
        pet_tag.func_82580_o("UpdateBlocked");
        pet_tag.func_74776_a("Health", 0.0f);
        pet_tag.func_74776_a("max_life", entity.func_110138_aP());
        if (!hasReceptacle) {
            CommandTBReviveFamiliar.saveFamiliar(server, ownerId, pet_tag, entity.func_110124_au().toString());
            return false;
        }
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)entity);
        IntStream.range(0, itemHandler.getSlots()).forEach(slot -> {
            ItemStack currentStack = itemHandler.getStackInSlot(slot);
            if (!currentStack.func_190926_b()) {
                itemHandler.extractItem(slot, currentStack.func_190916_E(), false);
            }
        });
        tameableType.onCapture((Entity)entity, pet_tag);
        receptacle.func_196082_o().func_218657_a(DEAD_PET_NBT_COMPOUND, (INBT)pet_tag);
        if (wasOffline) {
            EntityHelper.writePlayerData(server, (PlayerEntity)owner);
        } else {
            LangKey.MESSAGE_CAPTURE_FAMILIAR.sendMessage((PlayerEntity)owner, StyleType.MESSAGE_SPECIAL, new Object[]{entity.func_200200_C_()});
            ModTriggers.CAPTURE_SOUL.trigger(owner);
        }
        return true;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(DEAD_PET_NBT_COMPOUND, 10)) {
            CompoundNBT tag = stack.func_77978_p().func_74737_b();
            CompoundNBT pet_tag = tag.func_74775_l(DEAD_PET_NBT_COMPOUND);
            if (pet_tag.func_150297_b("id", 8)) {
                CompoundNBT newTag = new CompoundNBT();
                newTag.func_74778_a("id", pet_tag.func_74779_i("id"));
                if (pet_tag.func_74764_b("Health")) {
                    newTag.func_74776_a("Health", pet_tag.func_74760_g("Health"));
                }
                if (pet_tag.func_74764_b("max_life")) {
                    newTag.func_74776_a("max_life", pet_tag.func_74760_g("max_life"));
                }
                tag.func_218657_a(DEAD_PET_NBT_COMPOUND, (INBT)newTag);
            } else {
                pet_tag.func_82580_o(DEAD_PET_NBT_COMPOUND);
            }
            return tag;
        }
        return stack.func_77978_p();
    }

    public ItemStack createWithRandomFamiliar() {
        return this.setRandomFamiliar(new ItemStack((IItemProvider)this));
    }

    private ItemStack setRandomFamiliar(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            CompoundNBT pet_tag = new CompoundNBT();
            pet_tag.func_74778_a("id", TameableType.getRandomTameableEntityTypeString());
            stack.func_196082_o().func_218657_a(DEAD_PET_NBT_COMPOUND, (INBT)pet_tag);
        }
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundNBT tag, LootContext context) {
        return this.setRandomFamiliar(stack);
    }
}

