/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFishingRodOfMisadventure
extends FishingRodItem
implements ISoulConsumer {
    private final String name = "fishing_rod_of_misadventure";

    public ItemFishingRodOfMisadventure() {
        super(new Item.Properties().func_200916_a(ModTabs.mainTab).func_200915_b(32).func_234689_a_());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.func_230531_f_())).func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    public boolean isAncient(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "ancient");
    }

    public String getSimpleName() {
        return this.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            int id = this.isEnchanted(stack) ? 2 : 1;
            list.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".desc" + id).func_230530_a_(StyleType.TOOLTIP_DESC));
            list.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".use" + id).func_230530_a_(StyleType.TOOLTIP_USE));
        } else {
            list.add((ITextComponent)LangKey.TOOLTIP_MORE_INFO.getText(StyleType.TOOLTIP_DESC, new Object[0]));
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean isEnchanted = this.isEnchanted(stack);
        if (player.field_71104_cf != null) {
            if (!world.func_201670_d()) {
                int damage = player.field_71104_cf.func_146034_e(stack);
                if (!isEnchanted) {
                    Helper.damageItem(stack, damage, (ServerPlayerEntity)player, hand);
                }
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        } else {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.func_201670_d()) {
                boolean isAncient = this.isAncient(stack);
                FishingBobberEntity fishingBobber = new FishingBobberEntity(player, world, 0, isAncient ? 5 : (isEnchanted ? 2 : 0));
                fishingBobber.field_191518_aw = -(isAncient ? 100 : (isEnchanted ? 50 : 10));
                world.func_217376_c((Entity)fishingBobber);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isEnchanted(stack) && super.showDurabilityBar(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (!this.isEnchanted(stack)) {
            super.setDamage(stack, damage);
        }
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            stack.func_196085_b(0);
            if (!this.isAncient(stack) && soulStrenght > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                ModTriggers.CREATE_ANCIENT_FISHING_ROD.trigger(player);
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_FISHING_ROD_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_FAILED.getText(new Object[0]);
    }

    public String func_77658_a() {
        return "tombstone.item.fishing_rod_of_misadventure";
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return "tombstone";
    }
}

