/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModItems;

public class ItemLollipop
extends ItemGeneric {
    public ItemLollipop() {
        super("lollipop", ItemLollipop.getBuilder().func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(2.0f).func_221457_c().func_221455_b().func_221453_d()));
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        if (stack.func_77973_b() == this & tintIndex == 0) {
            ModelColor modelColor;
            short ordinal = NBTStackHelper.getShort(stack, "model_color", (short)-1);
            if (ordinal < 0 || ordinal >= ModelColor.values().length) {
                modelColor = ModelColor.getRandom();
                this.setColor(stack, modelColor);
            } else {
                modelColor = ModelColor.values()[ordinal];
            }
            return 0xFF000000 | modelColor.color;
        }
        return -1;
    }

    public ItemStack setColor(ItemStack stack, ModelColor modelColor) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setShort(stack, "model_color", (short)modelColor.ordinal());
        }
        return stack;
    }

    public ItemStack getRandom() {
        return this.setColor(new ItemStack((IItemProvider)this), ModelColor.getRandom());
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            list.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".desc").func_230530_a_(StyleType.TOOLTIP_DESC));
        } else {
            list.add((ITextComponent)LangKey.TOOLTIP_MORE_INFO.getText(StyleType.TOOLTIP_DESC, new Object[0]));
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        super.func_77654_b(stack, world, entity);
        if (entity instanceof ServerPlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            EffectHelper.addRandomEffect(player, 12000, true);
        }
        return stack;
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.EAT;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Event {
        @SubscribeEvent
        public static void registerItemColors(ColorHandlerEvent.Item event) {
            event.getItemColors().func_199877_a(ModItems.lollipop::getColor, new IItemProvider[]{ModItems.lollipop});
        }
    }

    public static enum ModelColor {
        YELLOW(14469140),
        PURPLE(5584316),
        GREEN(4174479),
        MAGENTA(11154876),
        RED(12334416);

        private final int color;

        private ModelColor(int color) {
            this.color = color;
        }

        public static ModelColor getRandom() {
            return ModelColor.values()[Helper.random.nextInt(ModelColor.values().length)];
        }
    }
}

