/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollBuff
extends ItemScroll {
    private final SpellBuff spellBuff;

    public ItemScrollBuff(SpellBuff spellBuff) {
        super("scroll_of_" + spellBuff.getName(), spellBuff::isEnable);
        this.spellBuff = spellBuff;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            this.addItemUse(list, this.isEnchanted(stack) ? LangKey.ITEM_SCROLL_BUFF_USE2 : LangKey.ITEM_SCROLL_BUFF_USE1, new Object[0]);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            list.add((ITextComponent)new StringTextComponent("(" + StringUtils.func_76337_a((int)MathHelper.func_76141_d((float)((float)((Integer)SharedConfigTombstone.general.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.scribe) / 10.0f)))) + ")").func_230530_a_(StyleType.MESSAGE_SPELL));
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack) {
        Effect potion = (Effect)this.spellBuff.potionSupplier.get();
        EffectHelper.addEffect((LivingEntity)player, potion, MathHelper.func_76141_d((float)((float)((Integer)SharedConfigTombstone.general.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.scribe) / 10.0f))), this.spellBuff.amplifier, new boolean[0]);
        LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[]{new TranslationTextComponent(potion.func_76393_a()).func_230530_a_(StyleType.MESSAGE_SPECIAL)});
        ModTriggers.SPELL_BUFF.get((Object)this.spellBuff).trigger(player);
        return true;
    }

    public static enum SpellBuff {
        PRESERVATION(() -> ModEffects.preservation, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPreservation.get()),
        UNSTABLE_INTANGIBLENESS(() -> ModEffects.unstable_intangibleness, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfUnstableIntangibleness.get()),
        FEATHER_FALL(() -> ModEffects.feather_fall, 2, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFeatherFall.get()),
        PURIFICATION(() -> ModEffects.purification, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPurification.get()),
        TRUE_SIGHT(() -> ModEffects.true_sight, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfTrueSight.get()),
        REACH(() -> ModEffects.reach, 4, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfReach.get()),
        LIGHTNING_RESISTANCE(() -> ModEffects.lightning_resistance, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfLightningResistance.get()),
        FROST_RESISTANCE(() -> ModEffects.frost_resistance, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFrostResistance.get()),
        AQUATIC_LIFE(() -> ModEffects.aquatic_life, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfAquaticLife.get());

        private final Supplier<Effect> potionSupplier;
        private final int amplifier;
        private final BooleanSupplier supplierEnabled;

        private SpellBuff(Supplier<Effect> potionSupplier, int amplifier, BooleanSupplier supplierEnabled) {
            this.potionSupplier = potionSupplier;
            this.amplifier = amplifier;
            this.supplierEnabled = supplierEnabled;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }

        public boolean isEnable() {
            return this.supplierEnabled.getAsBoolean();
        }

        public static SpellBuff getRandomBuff() {
            return SpellBuff.values()[Helper.getRandom(0, SpellBuff.values().length - 1)];
        }
    }
}

