/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfAssistance
extends ItemTablet {
    public ItemTabletOfAssistance() {
        super("tablet_of_assistance", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfAssistance.get());
    }

    public ITextComponent getHighlightTip(ItemStack stack, ITextComponent displayName) {
        return super.func_200295_i(stack).func_230531_f_().func_240703_c_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public ITextComponent func_200295_i(ItemStack stack) {
        return new StringTextComponent(EngravableHelper.getEngravedName(stack));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        ITextComponent displayName = super.func_200295_i(stack);
        if (list.size() > 0) {
            list.set(0, displayName);
        } else {
            list.add(displayName);
        }
        if (Helper.canShowTooltip(world, stack)) {
            boolean isAncient = this.isAncient(stack);
            boolean isEnchant = this.isEnchanted(stack);
            if (isAncient) {
                this.addItemDesc(list, "_ancient", new Object[0]);
                if (isEnchant) {
                    this.addItemUse(list, "_ancient", new Object[0]);
                } else {
                    this.addItemUse(list, "1", new Object[0]);
                }
            } else if (!isEnchant) {
                this.addItemDesc(list);
                this.addItemUse(list, "1", new Object[0]);
            } else {
                String engraved_name = EngravableHelper.getEngravedName(stack);
                if (engraved_name.isEmpty()) {
                    this.addItemDesc(list);
                    this.addItemUse(list, "2", new StringTextComponent("[").func_230529_a_(ModItems.grave_dust.func_200295_i(stack)).func_240702_b_("]").func_240703_c_(StyleType.TOOLTIP_ITEM));
                } else {
                    this.addInfo(list, LangKey.MESSAGE_ENGRAVED, '\"' + engraved_name + '\"');
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            this.setUseCount(stack, this.getUseMax());
            if (!this.isAncient(stack) && soulStrenght > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                ModTriggers.CREATE_ANCIENT_TABLET.trigger(player);
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack) {
        String engraved_name = EngravableHelper.getEngravedName(stack);
        if (engraved_name.isEmpty()) {
            boolean isAncient = this.isAncient(stack);
            if (!isAncient) {
                LangKey.MESSAGE_PLAYER_INVALID.sendMessage((PlayerEntity)player, new Object[0]);
                return false;
            }
            List receivers = player.field_71133_b.func_184103_al().func_181057_v().stream().filter(p -> !p.equals((Object)player)).collect(Collectors.toList());
            if (receivers.size() == 0) {
                LangKey.MESSAGE_NO_OTHER_VALID_PLAYER.sendMessage((PlayerEntity)player, new Object[0]);
                return false;
            }
            for (ServerPlayerEntity receiver : receivers) {
                LangKey.MESSAGE_REQUEST_TO_HELP_SENDER.sendMessage((PlayerEntity)receiver, StyleType.MESSAGE_SPECIAL, new Object[]{LangKey.MESSAGE_HERE.createComponentCommand("/tbacceptteleport " + player.func_110124_au(), new Object[0]), player.func_200200_C_()});
                CommandTBAcceptTeleport.addTicket((PlayerEntity)receiver, (PlayerEntity)player, 120, false);
            }
            LangKey.MESSAGE_CALL_FOR_HELP.sendMessage((PlayerEntity)player, new Object[0]);
            ModTriggers.USE_ASSISTANCE.trigger(player);
            return true;
        }
        if (engraved_name.equals(player.func_200200_C_().func_150261_e())) {
            LangKey.MESSAGE_TELEPORT_SAME_PLAYER.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        if (Stream.of(world.func_73046_m().func_71213_z()).noneMatch(p -> p.equals(engraved_name))) {
            if (world.func_73046_m().func_152358_ax().field_152661_c.keySet().contains(engraved_name)) {
                LangKey.MESSAGE_PLAYER_OFFLINE.sendMessage((PlayerEntity)player, new Object[0]);
            } else {
                LangKey.MESSAGE_PLAYER_INVALID.sendMessage((PlayerEntity)player, new Object[0]);
            }
            return false;
        }
        ServerPlayerEntity receiver = world.func_73046_m().func_184103_al().func_152612_a(engraved_name);
        if (receiver == null) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        if (!receiver.field_70170_p.func_234923_W_().equals(player.field_70170_p.func_234923_W_()) && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        LangKey.MESSAGE_REQUEST_TO_JOIN_RECEIVER.sendMessage((PlayerEntity)receiver, StyleType.MESSAGE_SPECIAL, new Object[]{LangKey.MESSAGE_HERE.createComponentCommand("/tbacceptteleport " + player.func_110124_au(), new Object[0]), player.func_200200_C_()});
        CommandTBAcceptTeleport.addTicket((PlayerEntity)receiver, (PlayerEntity)player, 120);
        LangKey.MESSAGE_REQUEST_TO_JOIN_SENDER.sendMessage((PlayerEntity)player, receiver.func_200200_C_());
        ModTriggers.USE_ASSISTANCE.trigger(player);
        return true;
    }

    @Override
    protected boolean canBlockInteractFirst(BlockState state, ItemStack stack) {
        return super.canBlockInteractFirst(state, stack) || state.func_177230_c().func_203417_a((ITag)BlockTags.field_200572_k);
    }
}

