/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityPlayerGrave
extends TileEntityWritableGrave {
    protected final ItemStackHandler inventory = new ItemStackHandler(120);
    @Nullable
    private UUID ownerId = null;
    private boolean needAccess = false;

    public TileEntityPlayerGrave() {
        super(ModBlocks.tile_grave);
    }

    @Override
    public boolean canShowFog() {
        return true;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void giveInventory(@Nullable ServerPlayerEntity player) {
        boolean hasLosses;
        if (this.field_145850_b == null || !EntityHelper.isValidServerPlayer((PlayerEntity)player)) {
            return;
        }
        assert (player != null && player.func_184102_h() != null);
        boolean bl = hasLosses = (Integer)ConfigTombstone.player_death.chanceLossOnDeath.get() > 0 && (Integer)ConfigTombstone.player_death.percentLossOnDeath.get() > 0 && ((Boolean)ConfigTombstone.player_death.lossOnDeathOnlyForAbandonedGrave.get() == false || !this.getNeedAccess()) && Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.player_death.chanceLossOnDeath.get();
        if (hasLosses) {
            float percentLossOnDeath = (float)((Integer)ConfigTombstone.player_death.percentLossOnDeath.get()).intValue() * 0.01f;
            int countLoss = 0;
            for (int slotId = 0; slotId < this.inventory.getSlots(); ++slotId) {
                ItemStack stack2 = this.inventory.getStackInSlot(slotId);
                if (stack2.func_190926_b()) continue;
                if (stack2.func_77985_e()) {
                    int losses;
                    if (stack2.func_77942_o() && ((Boolean)ConfigTombstone.player_death.lossOnDeathOnlyForStackableItems.get()).booleanValue() || (losses = Math.round((float)stack2.func_190916_E() * percentLossOnDeath)) <= 0) continue;
                    this.inventory.extractItem(slotId, losses, false);
                    ++countLoss;
                    continue;
                }
                if (((Boolean)ConfigTombstone.player_death.lossOnDeathOnlyForStackableItems.get()).booleanValue() || !(Helper.random.nextFloat() <= percentLossOnDeath)) continue;
                this.inventory.setStackInSlot(slotId, ItemStack.field_190927_a);
                ++countLoss;
            }
            if (countLoss > 0) {
                ItemStack junkStack = TimeHelper.isDateAroundHalloween() ? ModItems.lollipop.getRandom() : (countLoss > 5 ? new ItemStack((IItemProvider)ModItems.grave_dust) : (countLoss > 2 ? new ItemStack((IItemProvider)Items.field_151055_y) : new ItemStack((IItemProvider)Blocks.field_196555_aI)));
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)junkStack);
                LangKey.MESSAGE_LOSSES_ON_DEATH.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            }
        }
        EventFactory.onRestoreInventory((PlayerEntity)player, this);
        PlayerPreference playerPreference = PlayerPreference.get(player.func_110124_au());
        if (playerPreference.getAutoEquipRule().equiOnGraveRecovery()) {
            for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                if (!ovh.corail.tombstone.helper.InventoryHelper.autoequip(this.inventory.getStackInSlot(i), (PlayerEntity)player)) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
        NonNullList swapItems = NonNullList.func_191196_a();
        if (playerPreference.priorizeToolOnHotbar()) {
            IItemHandler itemHandler = ovh.corail.tombstone.helper.InventoryHelper.getItemHandler((Entity)player);
            int playerSlotId = -1;
            for (int graveSlotId = 0; graveSlotId < this.inventory.getSlots() && playerSlotId < 9; ++graveSlotId) {
                ItemStack playerStack;
                if (!ovh.corail.tombstone.helper.InventoryHelper.isTool(this.inventory.getStackInSlot(graveSlotId))) continue;
                do {
                    playerStack = itemHandler.getStackInSlot(++playerSlotId);
                } while (playerSlotId < 9 && ovh.corail.tombstone.helper.InventoryHelper.isTool(playerStack));
                if (!playerStack.func_190926_b()) {
                    swapItems.add((Object)itemHandler.extractItem(playerSlotId, 1, false));
                }
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.inventory.extractItem(graveSlotId, 1, false), (int)playerSlotId);
                this.inventory.setStackInSlot(graveSlotId, ItemStack.field_190927_a);
            }
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack3 = this.inventory.getStackInSlot(i);
            if (stack3.func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack3.func_77946_l());
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (!swapItems.isEmpty()) {
            swapItems.forEach(stack -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack));
            swapItems.clear();
        }
        this.removeGraveBy(player);
        EffectHelper.capDuration((LivingEntity)player, ModEffects.ghostly_shape, 100);
        player.field_71069_bz.func_75142_b();
        LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
    }

    public boolean canPlunder(PlayerEntity player) {
        return EntityHelper.getPerkLevelWithBonus(player, ModPerks.tomb_raider) > 0;
    }

    public boolean isAbandoned(@Nullable PlayerEntity player) {
        int knowledgeLevel = player != null ? player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> Math.min(cap.getTotalPerkPoints(), 10)).orElse(0) : 0;
        int delay = (Integer)SharedConfigTombstone.player_death.decayTime.get() == -1 ? TimeHelper.tickFromDay(1) : (int)((float)TimeHelper.tickFromMinute((Integer)SharedConfigTombstone.player_death.decayTime.get()) * (1.0f - (float)knowledgeLevel * 0.05f));
        return this.getDeathMCTime() >= (long)delay;
    }

    public boolean plunder(ServerPlayerEntity player) {
        int maxId = -1;
        for (int slotId = this.inventory.getSlots() - 1; slotId >= 0; --slotId) {
            if (this.inventory.getStackInSlot(slotId).func_190926_b()) continue;
            maxId = slotId + 1;
            break;
        }
        if (maxId == -1) {
            this.removeGraveBy(player);
            return false;
        }
        boolean valid = false;
        int nbTry = 3 + Helper.random.nextInt(player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getTotalPerkPoints).orElse(1));
        for (int i = 0; i < nbTry; ++i) {
            int id = Helper.random.nextInt(maxId);
            ItemStack stack = this.inventory.getStackInSlot(id);
            if (stack.func_190926_b()) continue;
            valid = true;
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.inventory.extractItem(id, stack.func_190916_E(), false));
        }
        if (valid) {
            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.TOMB_RAIDING);
            EntityHelper.addAlignment(player, (Integer)ConfigTombstone.alignment.pointsPlunderPlayerGrave.get());
            if (ovh.corail.tombstone.helper.InventoryHelper.hasAllSlotsEmpty((IItemHandler)this.inventory)) {
                this.removeGraveBy(player);
            } else {
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    private void removeGraveBy(ServerPlayerEntity player) {
        ServerPlayerEntity owner;
        if (this.field_145850_b == null) {
            return;
        }
        ServerPlayerEntity serverPlayerEntity = owner = player.func_146103_bH().getName().equals(this.ownerName) ? player : (ServerPlayerEntity)Optional.ofNullable(player.func_184102_h()).map(MinecraftServer::func_184103_al).map(list -> list.func_152612_a(this.ownerName)).orElse(null);
        if (owner != null) {
            DeathHandler.INSTANCE.removeGrave(owner, new Location(this.field_174879_c, this.field_145850_b));
        }
        Helper.removeNoEvent(this.field_145850_b, this.field_174879_c);
        this.field_145850_b.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void setOwner(PlayerEntity player, long deathDate, boolean needAccess) {
        this.setOwner(player.func_146103_bH().getName(), deathDate);
        this.ownerId = player.func_110124_au();
        this.needAccess = needAccess;
    }

    public boolean isOwner(PlayerEntity owner) {
        return this.ownerId == null ? this.hasOwner() && this.ownerName.equals(owner.func_146103_bH().getName()) : this.ownerId.equals(owner.func_110124_au());
    }

    public boolean getNeedAccess() {
        int decayTime = (Integer)SharedConfigTombstone.player_death.decayTime.get();
        return this.needAccess && (decayTime == -1 || this.getDeathMCTime() < (long)TimeHelper.tickFromMinute(decayTime));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        return compound;
    }

    @Override
    protected CompoundNBT writeShared(CompoundNBT compound) {
        super.writeShared(compound);
        if (this.ownerId != null) {
            compound.func_186854_a("owner_id", this.ownerId);
        }
        compound.func_74757_a("need_access", this.needAccess);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("inventory", 10)) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_186855_b("owner_id")) {
            this.ownerId = compound.func_186857_a("owner_id");
        }
        this.needAccess = compound.func_74767_n("need_access");
    }

    public boolean func_183000_F() {
        return true;
    }

    public void func_145843_s() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            if (ModBlocks.isPlayerGrave(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c())) {
                return;
            }
            if (Helper.isAllowedForRemoval(this.field_145850_b, this.field_174879_c)) {
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    ItemStack stack = this.inventory.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.inventory.extractItem(i, stack.func_190916_E(), false));
                }
            }
        }
        super.func_145843_s();
    }

    @Override
    public boolean isPlayerGrave() {
        return true;
    }

    public String getFormattedInfo() {
        StringBuilder builder = new StringBuilder(TextFormatting.GOLD.toString()).append(LangKey.MESSAGE_RIP.getText(new Object[0]).getString()).append(" ").append(this.getOwnerName()).append(" ");
        if (this.getNeedAccess()) {
            int left;
            builder.append(TextFormatting.RED).append("[").append(LangKey.MESSAGE_LOCKED.getText(new Object[0]).getString()).append("]");
            int decayTime = (Integer)SharedConfigTombstone.player_death.decayTime.get();
            if (decayTime > 0 && (left = TimeHelper.tickFromMinute(decayTime) - (int)this.getDeathMCTime()) > 0) {
                builder.append(" ").append(TimeHelper.getTimeStringWithUnit(left));
            }
        } else {
            builder.append(TextFormatting.GREEN).append("[").append(LangKey.MESSAGE_UNLOCKED.getText(new Object[0]).getString()).append("]");
        }
        return builder.toString();
    }

    public String getFormattedDeathDate() {
        Date date = new Date(this.getOwnerDeathTime());
        return TextFormatting.ITALIC + LangKey.MESSAGE_DIED_ON.getText(new Object[0]).getString() + " " + new SimpleDateFormat("dd/MM/yyyy").format(date) + " " + LangKey.MESSAGE_DEATH_TIME.getText(new SimpleDateFormat("HH:mm:ss").format(date)).getString();
    }
}

