/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.reflect.Reflection;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlclient.ConfigGuiHandler;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import net.minecraftforge.fmlserverevents.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.api.TombstoneAPIProps;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.IntegrationTOP;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.config.TombstoneModConfig;
import ovh.corail.tombstone.gui.GuiConfig;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.ThreadedBackup;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.InBundleFunction;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.loot.PreciseEnchantFunction;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.proxy.ClientProxy;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.proxy.ServerProxy;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod(value="tombstone")
public class ModTombstone {
    public static final String MOD_ID = "tombstone";
    public static final String MOD_NAME = "Corail Tombstone";
    public static final Logger LOGGER = LogManager.getLogger((String)"tombstone");
    public static final IProxy PROXY = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static LootItemConditionType OPEN_WATER;
    public static LootItemFunctionType DELAYED_NBT_LOOT;
    public static LootItemFunctionType PRECISE_ENCHANT;
    public static LootItemFunctionType IN_BUNDLE;
    public static LootItemFunctionType TRIGGER_CAT_MORNING;
    public static final EnchantmentCategory TYPE_TOMBSTONE_ALL;

    public ModTombstone() {
        TombstoneAPIProps.COOLDOWN_HANDLER = CooldownHandler.INSTANCE;
        Reflection.initialize((Class[])new Class[]{PerkRegistry.class, PacketHandler.class, ModStats.class, ModTriggers.class, ModTags.class, ModTabs.class});
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigTombstone.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigTombstone.GENERAL_SPEC);
        this.registerSharedConfig(context);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(this::onServerStarting);
        forgeBus.addListener(this::onServerStoppingEvent);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::preInit);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::enqueueIMC);
        context.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory(GuiConfig::new));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (SupportMods.TOP.isLoaded()) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", IntegrationTOP::new);
        }
        if (SupportMods.CURIOS.isLoaded()) {
            CompatibilityCurio.instance.sendIMC();
        }
    }

    private void registerSharedConfig(ModLoadingContext context) {
        context.getActiveContainer().addConfig((ModConfig)new TombstoneModConfig(SharedConfigTombstone.CONFIG_SPEC, context.getActiveContainer()));
    }

    private void preInit(FMLCommonSetupEvent event) {
        PROXY.preInit();
        MinecraftForge.EVENT_BUS.register((Object)Helper.buildKnowledgeFunction());
        OPEN_WATER = (LootItemConditionType)Registry.m_122961_((Registry)Registry.f_122877_, (String)"tombstone:in_open_water", (Object)new LootItemConditionType((Serializer)InOpenWaterCondition.SERIALIZER));
        DELAYED_NBT_LOOT = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)DelayedNBTFunction.RL, (Object)new LootItemFunctionType((Serializer)DelayedNBTFunction.SERIALIZER));
        PRECISE_ENCHANT = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)PreciseEnchantFunction.RL, (Object)new LootItemFunctionType((Serializer)PreciseEnchantFunction.SERIALIZER));
        IN_BUNDLE = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)InBundleFunction.RL, (Object)new LootItemFunctionType((Serializer)InBundleFunction.SERIALIZER));
        TRIGGER_CAT_MORNING = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)TriggerCatMorningFunction.RL, (Object)new LootItemFunctionType((Serializer)TriggerCatMorningFunction.SERIALIZER));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(Helper::initModels);
    }

    private void onServerStarting(FMLServerStartingEvent event) {
        Helper.loadContributors(event.getServer());
        TimeHelper.init();
        Helper.checkDeathHandlingMod(null);
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
        }
        ThreadedBackup.INSTANCE.startThread();
        TameableType.init(event.getServer());
    }

    private void onServerStoppingEvent(FMLServerStoppingEvent event) {
        CallbackHandler.flushTasks();
        PlayerPreference.clear();
        CooldownHandler.INSTANCE.clear();
        try {
            ThreadedBackup.INSTANCE.flush();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            ThreadedBackup.INSTANCE.stopThread();
        }
    }

    static {
        TYPE_TOMBSTONE_ALL = EnchantmentCategory.create((String)"type_tombstone_all", p -> p != null && (p.m_6473_() > 0 || p.m_41459_() == 1));
    }
}

