/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.advancement;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import ovh.corail.tombstone.advancement.ITriggerable;
import ovh.corail.tombstone.advancement.StatelessCriterion;

public class AbstractTrigger<T extends StatelessCriterion>
implements CriterionTrigger<T>,
ITriggerable {
    private final Map<PlayerAdvancements, Set<CriterionTrigger.Listener<T>>> listeners = Maps.newIdentityHashMap();
    private final ResourceLocation rl;
    private final BiFunction<JsonObject, DeserializationContext, T> factory;

    public AbstractTrigger(String name, BiFunction<JsonObject, DeserializationContext, T> factory) {
        this(new ResourceLocation("tombstone", name), factory);
    }

    public AbstractTrigger(ResourceLocation rl, BiFunction<JsonObject, DeserializationContext, T> factory) {
        this.rl = rl;
        this.factory = factory;
    }

    public ResourceLocation m_7295_() {
        return this.rl;
    }

    public void m_6467_(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<T> listener) {
        this.listeners.computeIfAbsent(playerAdvancements, advancements -> Sets.newHashSet()).add(listener);
    }

    public void m_6468_(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<T> listener) {
        Set<CriterionTrigger.Listener<T>> set = this.listeners.get(playerAdvancements);
        if (set != null && set.remove(listener) && set.isEmpty()) {
            this.listeners.remove(playerAdvancements);
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public T createInstance(JsonObject json, DeserializationContext context) {
        return (T)((StatelessCriterion)this.factory.apply(json, context));
    }

    @Override
    public void trigger(ServerPlayer player) {
        this.trigger(player, instance -> true);
    }

    public void trigger(ServerPlayer player, Predicate<T> predic) {
        PlayerAdvancements playeradvancements = player.m_8960_();
        Set<CriterionTrigger.Listener<T>> set = this.listeners.get(playeradvancements);
        if (set != null && !set.isEmpty()) {
            List<CriterionTrigger.Listener> list = set.stream().filter(l -> predic.test((StatelessCriterion)l.m_13685_())).collect(Collectors.toList());
            list.forEach(l -> l.m_13686_(playeradvancements));
        }
    }
}

