/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlockEntityTypes;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class BlockGrave
extends BlockGraveBase<TileEntityPlayerGrave> {
    public BlockGrave(GraveModel graveModel) {
        super(BlockGrave.getBuilder(), graveModel);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        if (!level.m_5776_()) {
            return this.activatePlayerGrave(level, pos, state, (ServerPlayer)player) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter blockGetter, BlockPos pos, Entity entity) {
        return false;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityPlayerGrave oldTile;
        if (!level.m_5776_() && !DeathHandler.INSTANCE.canRemovePlayerGrave(level, pos) && !ModBlocks.isPlayerGrave(newState.m_60734_()) && ModBlocks.isPlayerGrave(state.m_60734_()) && (oldTile = (TileEntityPlayerGrave)((Object)this.getTileEntity(level, pos))) != null) {
            CompoundTag oldNbt = oldTile.m_6945_(new CompoundTag());
            CallbackHandler.addFastCallback(() -> {
                level.m_46597_(pos, state);
                BlockEntity newTile = level.m_7702_(pos);
                if (newTile != null) {
                    newTile.m_142466_(oldNbt);
                    newTile.m_6596_();
                    level.m_7260_(pos, newState, state, 3);
                }
            });
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private boolean activatePlayerGrave(Level level, BlockPos pos, BlockState state, ServerPlayer player) {
        if (level.m_5776_()) {
            return true;
        }
        TileEntityPlayerGrave tile = (TileEntityPlayerGrave)((Object)this.getTileEntity(level, pos));
        if (tile == null || tile.countTicks < 30 || !player.m_6084_()) {
            return false;
        }
        boolean hasKey = ModItems.grave_key.removeKeyForGraveInInventory((Player)player, tile);
        boolean isOwner = tile.isOwner((Player)player);
        if (!hasKey && isOwner) {
            ModTriggers.EASY_OPENING.trigger(player);
        }
        boolean valid = hasKey || isOwner;
        boolean limitedAccess = false;
        if (!valid && !tile.getNeedAccess()) {
            if (TimeHelper.isSystemTimeElapsedSinceServerStart(10)) {
                valid = true;
            } else {
                limitedAccess = true;
            }
        }
        if (limitedAccess) {
            LangKey.MESSAGE_OPEN_GRAVE_PROTECTED.sendMessage((Player)player, new Object[0]);
        } else if (valid) {
            tile.giveInventory(player);
            if (level.m_6106_().m_5472_() != Difficulty.PEACEFUL && (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get() > 0 && Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get()) {
                IntStream.range(0, Helper.getRandom(1, 3)).forEach(i -> Helper.spawnRandomMob((ServerLevel)level, pos));
            }
            if (!isOwner) {
                ModTriggers.TOMB_RAIDING.trigger(player);
            }
        } else if (tile.canPlunder((Player)player)) {
            if (!tile.isAbandoned((Player)player)) {
                LangKey.MESSAGE_TOMB_RAIDER_NOT_ABANDONED.sendMessage((Player)player, new Object[0]);
            } else {
                int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownType.TOMB_RAIDING);
                if (cd > 0) {
                    LangKey.MESSAGE_TOMB_RAIDER_IN_COOLDOWN.sendMessage((Player)player, new Object[0]);
                    LangKey.MESSAGE_IN_COOLDOWN.sendMessage((Player)player, TimeHelper.getTimeStringWithUnit(cd));
                } else {
                    if (tile.plunder(player)) {
                        LangKey.MESSAGE_TOMB_RAIDER_SUCCESS.sendMessage((Player)player, new Object[0]);
                        ModTriggers.TOMB_RAIDING.trigger(player);
                        return true;
                    }
                    LangKey.MESSAGE_TOMB_RAIDER_FAILED.sendMessage((Player)player, new Object[0]);
                }
            }
        } else {
            LangKey.MESSAGE_OPEN_GRAVE_NEED_KEY.sendMessage((Player)player, new Object[0]);
        }
        return valid;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        ServerPlayer player;
        if (!level.m_5776_() && entity.m_6144_() && entity.m_6084_() && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && PlayerPreference.get(entity.m_142081_()).activateGraveBySneaking() && this.activatePlayerGrave(level, pos, state, player = (ServerPlayer)entity)) {
            ModTriggers.SNEAK_GRAVE.trigger(player);
        }
    }

    public boolean removedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.m_7500_()) {
            level.m_5898_(player, 2001, pos, BlockGrave.m_49956_((BlockState)state));
            if (!level.m_5776_()) {
                DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(level, pos);
            }
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        return false;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, Level level, BlockPos pos, Player player, ItemStack stack, ToolAction toolType) {
        return null;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }

    public boolean m_6903_(Explosion explosionIn) {
        return false;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter blockGetter, BlockPos pos, Explosion explosion) {
        return false;
    }

    private static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 1.8E7f).m_60953_(l -> 6).m_60918_(SoundType.f_56742_);
    }

    public ItemStack asDecorativeStack() {
        Item item;
        ResourceLocation registryName = this.getRegistryName();
        if (registryName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName.m_135827_(), "decorative_" + registryName.m_135815_()))) != null && item != Items.f_41852_) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityPlayerGrave(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> tile) {
        return BlockGrave.createTickerHelper(tile, ModBlockEntityTypes.tile_grave, level.m_5776_() ? TileEntityPlayerGrave::clientTick : TileEntityPlayerGrave::serverTick);
    }
}

