/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Locale;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import ovh.corail.tombstone.helper.Helper;

public enum SoulType implements StringRepresentable
{
    NONE(0),
    WEAK(13710317),
    STRONG(65532);

    private final String name = this.name().toLowerCase(Locale.US);
    private final int colorCode;

    private SoulType(int colorCode) {
        this.colorCode = colorCode;
    }

    public boolean hasSoul() {
        return this != NONE;
    }

    public SoulType consume(int soulStrengthMax) {
        return SoulType.byId(this.getSoulStrength() - soulStrengthMax);
    }

    public static SoulType generateSoulType() {
        return Helper.random.nextFloat() < 0.05f ? STRONG : WEAK;
    }

    public String m_7912_() {
        return this.name;
    }

    public int getSoulStrength() {
        return this.ordinal();
    }

    public int getColorCode() {
        return this.colorCode;
    }

    public static SoulType byId(int id) {
        return SoulType.values()[Mth.m_14045_((int)id, (int)0, (int)(SoulType.values().length - 1))];
    }
}

