/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.registry.ModTriggers;

public class TBCapabilityDefault
implements ITBCapability {
    protected int knowledge = 0;
    protected int alignment = 0;
    protected int alignmentLevel = 0;
    private final Map<Perk, Integer> perks = new ConcurrentHashMap<Perk, Integer>();
    private static final String KNOWLEDGE_NBT_INT = "knowledge";
    private static final String ALIGNMENT_NBT_SHORT = "alignment";

    @Override
    public int getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(int points) {
        this.knowledge = Math.max(0, points);
    }

    @Override
    public void reward(ServerPlayer player, int knowledge, int alignment) {
        if (EntityHelper.isValidServerPlayer((Player)player)) {
            if (knowledge > 0) {
                int newPerkPoints;
                int earnedPerkPoints;
                int oldPerkPoints = this.getTotalPerkPoints();
                this.knowledge += knowledge;
                boolean canDisplay = PlayerPreference.get(player.m_142081_()).displayKnowledgeMessage();
                if (canDisplay) {
                    LangKey.MESSAGE_EARN_KNOWLEDGE.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), knowledge});
                }
                if ((earnedPerkPoints = (newPerkPoints = this.getTotalPerkPoints()) - oldPerkPoints) > 0) {
                    if (canDisplay) {
                        LangKey.MESSAGE_ACCESS_GUI.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[]{earnedPerkPoints, LangKey.MESSAGE_HERE.createComponentCommand("/tbgui", new Object[0])});
                    }
                    if (oldPerkPoints == 0) {
                        ModTriggers.FIRST_KNOWLEDGE.trigger(player);
                    }
                    if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                        ModTriggers.MASTERY_1.trigger(player);
                    }
                }
            }
            if (alignment != 0) {
                int oldAlignment = this.alignmentLevel;
                if (alignment > 0 && this.alignmentLevel < 0 || alignment < 0 && this.alignmentLevel > 0) {
                    alignment *= 2;
                }
                this.setAlignment(this.alignment + alignment);
                if (oldAlignment != this.alignmentLevel) {
                    this.onAlignmentLevelChange(oldAlignment, this.alignmentLevel);
                }
            }
            if (knowledge > 0 && alignment != 0) {
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE_AND_ALIGNMENT, this.knowledge, this.alignment), player);
            } else if (knowledge > 0) {
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
            } else if (alignment != 0) {
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALIGNMENT, this.alignment), player);
            }
        }
    }

    @Override
    public void loseKnowledge(ServerPlayer player, int points) {
        if (EntityHelper.isValidServerPlayer((Player)player)) {
            int oldPerkPoints = this.getTotalPerkPoints();
            this.setKnowledge(this.knowledge - points);
            int lostPerkPoints = oldPerkPoints - this.getTotalPerkPoints();
            if (lostPerkPoints > 0) {
                Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
                while (it.hasNext() && lostPerkPoints > 0) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (Helper.isDisabledPerk(entry.getKey(), (Player)player)) {
                        it.remove();
                    }
                    for (int i = entry.getValue().intValue(); i >= 1 && lostPerkPoints > 0; --i) {
                        int cost = entry.getKey().getCost(i);
                        lostPerkPoints -= cost;
                        if (i == 1) {
                            it.remove();
                            continue;
                        }
                        entry.setValue(i - 1);
                    }
                }
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.alignment, this.perks), player);
            } else {
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
            }
            if (PlayerPreference.get(player.m_142081_()).displayKnowledgeMessage()) {
                LangKey.MESSAGE_LOSE_KNOWLEDGE.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), points});
            }
        }
    }

    @Override
    public int getKnowledgeForLevel(int level) {
        return level <= 0 ? 0 : level * level + 1;
    }

    @Override
    public int getKnowledgeToReachNextLevel(int level) {
        return level <= 0 ? 0 : level * 2 - 1;
    }

    @Override
    public void setAlignment(int value) {
        this.alignment = Mth.m_14045_((int)value, (int)this.getAlignmentMinValue(), (int)this.getAlignmentMaxValue());
        this.alignmentLevel = this.getAlignmentLevel();
    }

    @Override
    public int getAlignmentValue() {
        return this.alignment;
    }

    @Override
    public int getAlignmentMinValue() {
        return -500;
    }

    @Override
    public int getAlignmentMaxValue() {
        return 500;
    }

    @Override
    public int getAlignmentLevel() {
        if (this.alignment <= this.getAlignmentMinValue()) {
            return -4;
        }
        if (this.alignment <= -300) {
            return -3;
        }
        if (this.alignment <= -150) {
            return -2;
        }
        if (this.alignment <= -50) {
            return -1;
        }
        if (this.alignment < 50) {
            return 0;
        }
        if (this.alignment < 150) {
            return 1;
        }
        if (this.alignment < 300) {
            return 2;
        }
        if (this.alignment < this.getAlignmentMaxValue()) {
            return 3;
        }
        return 4;
    }

    @Override
    public void onAlignmentLevelChange(int oldAlignment, int newAlignment) {
    }

    @Override
    public int getUsedPerkPoints(Player player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey(), player)) {
                it.remove();
                continue;
            }
            Perk perk = entry.getKey();
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += perk.getCost(i);
            }
        }
        return perkPoints;
    }

    @Override
    public int getTotalPerkPoints() {
        return (int)Mth.m_14116_((float)(this.knowledge - 1));
    }

    @Override
    public Map<Perk, Integer> getPerks() {
        return this.perks;
    }

    @Override
    public void setPerks(Map<Perk, Integer> perks) {
        this.perks.clear();
        for (Map.Entry<Perk, Integer> entry : perks.entrySet()) {
            this.setPerk(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setPerk(Perk perk, int level) {
        this.perks.put(perk, level);
    }

    @Override
    public void removePerk(Perk perk) {
        this.perks.remove(perk);
    }

    @Override
    public int getPerkLevel(Player player, Perk perk) {
        return perk.isDisabled(player) ? 0 : this.perks.getOrDefault(perk, 0);
    }

    @Override
    public int getPerkLevelWithBonus(Player player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled(player)) {
            return Math.min(this.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax());
        }
        return 0;
    }

    @Override
    public boolean canResetPerks(Player player) {
        return CooldownHandler.INSTANCE.noCooldown(player, CooldownType.RESET_PERKS) && this.perks.entrySet().stream().anyMatch(entry -> entry.getKey() != null && (Integer)entry.getValue() > 0 && !((Perk)entry.getKey()).isDisabled(player));
    }

    @Override
    public boolean resetPerks(ServerPlayer player) {
        if (EntityHelper.isValidServerPlayer((Player)player) && this.canResetPerks((Player)player)) {
            this.setPerks(new HashMap<Perk, Integer>());
            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.RESET_PERKS);
            this.syncAll(player);
            return true;
        }
        return false;
    }

    @Override
    public void syncAll(ServerPlayer player) {
        if (EntityHelper.isValidServerPlayer((Player)player)) {
            PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.alignment, this.perks), player);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(KNOWLEDGE_NBT_INT, this.knowledge);
        nbt.m_128376_(ALIGNMENT_NBT_SHORT, (short)this.alignment);
        NBTStackHelper.writePerks(this.perks, nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_(KNOWLEDGE_NBT_INT, 3)) {
            this.knowledge = nbt.m_128451_(KNOWLEDGE_NBT_INT);
        }
        if (nbt.m_128425_(ALIGNMENT_NBT_SHORT, 2)) {
            this.setAlignment(nbt.m_128448_(ALIGNMENT_NBT_SHORT));
        }
        NBTStackHelper.readPerks(this.perks, nbt);
    }
}

