/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBAcceptTeleport
extends TombstoneCommand {
    private static final Set<Ticket> TICKETS = ConcurrentHashMap.newKeySet();

    public CommandTBAcceptTeleport(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbacceptteleport";
    }

    @Override
    protected Predicate<CommandSourceStack> getInitialRequirement() {
        return p -> true;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::showUsage)).then(Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.word()).executes(this::acceptTeleport));
    }

    private int acceptTeleport(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        String targetString = StringArgumentType.getString(ctx, (String)"target");
        ServerPlayer target = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(UUID.fromString(targetString));
        if (target == null) {
            throw LangKey.MESSAGE_PLAYER_INVALID.asCommandException(new Object[0]);
        }
        boolean valid = false;
        boolean toPlayer = false;
        Iterator<Ticket> it = TICKETS.iterator();
        while (it.hasNext()) {
            Ticket ticket = it.next();
            if (!ticket.playerUUID.equals(player.m_142081_()) || !ticket.targetUUID.equals(target.m_142081_()) || ticket.expiredTime < TimeHelper.systemTime()) continue;
            valid = true;
            toPlayer = ticket.toPlayer;
            it.remove();
            break;
        }
        if (valid) {
            ServerPlayer origin = toPlayer ? target : player;
            ServerPlayer destination = toPlayer ? player : target;
            Location spawnLoc = new SpawnHelper(destination.m_9236_(), destination.m_142538_()).findSafePlace(3, true);
            origin = Helper.teleportEntity(origin, spawnLoc.isOrigin() ? new Location((Entity)destination) : spawnLoc, destination.m_9236_());
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)origin, StyleType.MESSAGE_SPELL, new Object[0]);
            LangKey.MESSAGE_JOIN_YOU.sendMessage((Player)destination, StyleType.MESSAGE_SPELL, new Object[]{origin.m_7755_()});
            return 1;
        }
        throw LangKey.MESSAGE_NO_TICKET.asCommandException(new Object[0]);
    }

    public static void addTicket(Player player, Player target, int duration) {
        CommandTBAcceptTeleport.addTicket(player, target, duration, true);
    }

    public static void addTicket(Player player, Player target, int duration, boolean toPlayer) {
        TICKETS.add(new Ticket(player.m_142081_(), target.m_142081_(), TimeHelper.systemTime() + TimeUnit.SECONDS.toMillis(duration), toPlayer));
    }

    public static void cleanTickets() {
        if (TICKETS.size() > 0) {
            long systemTime = TimeHelper.systemTime();
            TICKETS.removeIf(p -> p.expiredTime < systemTime);
        }
    }

    public record Ticket(UUID playerUUID, UUID targetUUID, long expiredTime, boolean toPlayer) implements Comparable<Ticket>
    {
        @Override
        public int compareTo(Ticket ticket) {
            int cmp = this.playerUUID.compareTo(ticket.playerUUID);
            if (cmp == 0 && (cmp = this.targetUUID.compareTo(ticket.targetUUID)) == 0) {
                return Long.compare(this.expiredTime, ticket.expiredTime);
            }
            return cmp;
        }
    }
}

