/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBBind
extends TombstoneCommand {
    private static final String BIND_LOCATIONS_NBT_LIST = "tb_bind_locations";
    private static final String BIND_LOCATION_NBT_TAG = "location";
    private static final String BIND_LOCATION_ID_NBT_BYTE = "bind_id";
    private static final int BIND_ID_MIN = 1;
    private static final int BIND_ID_MAX = 5;
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_BIND_IDS = (ctx, build) -> SharedSuggestionProvider.m_82981_(IntStream.rangeClosed(1, 5).mapToObj(String::valueOf), (SuggestionsBuilder)build);
    private static final BiPredicate<Tag, Integer> IS_BIND_ID = (nbt, bindId) -> bindId.intValue() == ((CompoundTag)nbt).m_128445_(BIND_LOCATION_ID_NBT_BYTE);

    public CommandTBBind(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbbind";
    }

    @Override
    protected Predicate<CommandSourceStack> getInitialRequirement() {
        return p -> true;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.executes(this::showUsage);
        builder.then(SubCommand.SHOW.literal().executes(this::showBinds));
        builder.then(((LiteralArgumentBuilder)SubCommand.SET.literal().executes(this::setBind)).then(Commands.m_82129_((String)BIND_LOCATION_ID_NBT_BYTE, (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).suggests(SUGGESTION_BIND_IDS).executes(this::setBind)));
        builder.then(((LiteralArgumentBuilder)SubCommand.TELEPORT.literal().executes(this::teleportBind)).then(Commands.m_82129_((String)BIND_LOCATION_ID_NBT_BYTE, (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).suggests(SUGGESTION_BIND_IDS).executes(this::teleportBind)));
        return builder;
    }

    private int showBinds(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if ((Integer)ConfigTombstone.general.cooldownTeleportBind.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        NonNullList<Location> locations = this.getLocationList(((CommandSourceStack)ctx.getSource()).m_81377_(), player);
        if (locations.stream().allMatch(Location::isOrigin)) {
            throw LangKey.MESSAGE_NO_BIND_LOCATION.asCommandException(new Object[0]);
        }
        IntStream.range(0, locations.size()).forEach(i -> {
            Location location = (Location)locations.get(i);
            if (!location.isOrigin()) {
                LangKey.sendMessage((Component)new TextComponent(i + 1 + " -> {" + location.x + ", " + location.y + ", " + location.z + ", " + location.getDimString() + "}"), (Player)player);
            }
        });
        return 1;
    }

    private int teleportBind(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if ((Integer)ConfigTombstone.general.cooldownTeleportBind.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int bindId = CommandTBBind.getInteger(ctx, BIND_LOCATION_ID_NBT_BYTE, 0);
        Location location = this.getOrThrowLocation(((CommandSourceStack)ctx.getSource()).m_81375_(), bindId);
        CommandTBBind.checkAlive((Entity)player);
        CommandTBBind.checkNotSpectator((Player)player);
        int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownType.TELEPORT_BIND);
        if (cd > 0) {
            LangKey.MESSAGE_COMMAND_IN_COOLDOWN.sendMessage((Player)player, TimeHelper.getTimeStringWithUnit(cd));
            return 0;
        }
        ServerLevel world = this.getOrThrowWorld(((CommandSourceStack)ctx.getSource()).m_81377_(), location.dim);
        Location spawnPlace = new SpawnHelper(world, location.getPos()).findSpawnPlace();
        if (spawnPlace.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.TELEPORT_BIND);
        ServerPlayer newEntity = Helper.teleportEntity(player, spawnPlace, world);
        if (EntityHelper.isValidPlayer((Entity)newEntity)) {
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newEntity, StyleType.MESSAGE_SPELL, new Object[0]);
        }
        this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getText(newEntity.m_7755_(), spawnPlace.x, spawnPlace.y, spawnPlace.z, spawnPlace.getDimString()), false);
        return 1;
    }

    private int setBind(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Location location;
        if ((Integer)ConfigTombstone.general.cooldownTeleportBind.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int bindId = CommandTBBind.getInteger(ctx, BIND_LOCATION_ID_NBT_BYTE, 0);
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        ListTag locationList = persistentTag.m_128437_(BIND_LOCATIONS_NBT_LIST, 10);
        if (!this.findFirstLocationInListNBT(locationList, arg_0 -> CommandTBBind.lambda$setBind$2(location = new Location((Entity)player), arg_0)).isOrigin()) {
            throw LangKey.MESSAGE_EXISTING_BIND_LOCATION.asCommandException(new Object[0]);
        }
        if (bindId == 0) {
            byte id = this.getFirstEmptyIdInListNBT(locationList);
            if (id == -1) {
                this.setOrReplaceLocationInListNBT(locationList, location, bindId).m_128344_(BIND_LOCATION_ID_NBT_BYTE, (byte)1);
            } else {
                CompoundTag nbt = NBTStackHelper.setLocation(new CompoundTag(), BIND_LOCATION_NBT_TAG, location);
                nbt.m_128344_(BIND_LOCATION_ID_NBT_BYTE, id);
                locationList.add((Object)nbt);
            }
        } else {
            this.setOrReplaceLocationInListNBT(locationList, location, bindId).m_128344_(BIND_LOCATION_ID_NBT_BYTE, (byte)bindId);
        }
        persistentTag.m_128365_(BIND_LOCATIONS_NBT_LIST, (Tag)locationList);
        LangKey.MESSAGE_BIND_LOCATION.sendMessage((Player)player, new Object[0]);
        return 1;
    }

    private Byte getFirstEmptyIdInListNBT(ListTag locationList) {
        return locationList.stream().map(nbt -> ((CompoundTag)nbt).m_128445_(BIND_LOCATION_ID_NBT_BYTE)).filter(id -> id >= 1 && id <= 5).min(Byte::compareTo).orElse((byte)-1);
    }

    private CompoundTag setOrReplaceLocationInListNBT(ListTag locationList, Location location, int bindId) {
        return NBTStackHelper.setLocation(locationList.stream().map(CompoundTag.class::cast).filter(nbt -> IS_BIND_ID.test((Tag)nbt, bindId)).findFirst().orElseGet(() -> {
            CompoundTag nbt = new CompoundTag();
            locationList.add((Object)nbt);
            return nbt;
        }), BIND_LOCATION_NBT_TAG, location);
    }

    private Location getOrThrowLocation(ServerPlayer player, int bindId) {
        CompoundTag persistentTag;
        if (bindId < 0 || bindId > 5 || !(persistentTag = EntityHelper.getPersistentTag((Player)player)).m_128425_(BIND_LOCATIONS_NBT_LIST, 9)) {
            throw LangKey.MESSAGE_INVALID_LOCATION.asCommandException(new Object[0]);
        }
        ListTag locationList = persistentTag.m_128437_(BIND_LOCATIONS_NBT_LIST, 10);
        Location location = this.findFirstLocationInListNBT(locationList, bindId == 0 ? nbt -> true : nbt -> IS_BIND_ID.test((Tag)nbt, bindId));
        if (location.isOrigin()) {
            throw LangKey.MESSAGE_NO_BIND_LOCATION.asCommandException(new Object[0]);
        }
        return location;
    }

    private Location findFirstLocationInListNBT(ListTag locationList, Predicate<Tag> test) {
        return locationList.stream().filter(test).map(nbt -> NBTStackHelper.getLocation((CompoundTag)nbt, BIND_LOCATION_NBT_TAG)).findFirst().orElse(Location.ORIGIN);
    }

    private NonNullList<Location> getLocationList(MinecraftServer server, ServerPlayer player) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        NonNullList locationInstances = NonNullList.m_122780_((int)5, (Object)Location.ORIGIN);
        if (persistentTag.m_128425_(BIND_LOCATIONS_NBT_LIST, 9)) {
            ListTag locationList = persistentTag.m_128437_(BIND_LOCATIONS_NBT_LIST, 10);
            Iterator it = locationList.iterator();
            while (it.hasNext()) {
                CompoundTag data = (CompoundTag)it.next();
                Location location = NBTStackHelper.getLocation(data, BIND_LOCATION_NBT_TAG);
                if (!location.isOrigin() && !Helper.isInvalidDimension(server, location.dim)) {
                    locationInstances.set(data.m_128445_(BIND_LOCATION_ID_NBT_BYTE) - 1, (Object)location);
                    continue;
                }
                it.remove();
            }
        }
        return locationInstances;
    }

    private static /* synthetic */ boolean lambda$setBind$2(Location location, Tag nbt) {
        return NBTStackHelper.getLocation((CompoundTag)nbt, BIND_LOCATION_NBT_TAG).equals(location);
    }

    private static enum SubCommand implements ISubCommand
    {
        SHOW,
        SET,
        TELEPORT;

    }
}

