/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;

public class CommandTBKnowledge
extends TombstoneCommand {
    public CommandTBKnowledge(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbknowledge";
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.executes(this::showUsage);
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::showKnowledge)).then(SubCommand.SHOW.literal().executes(this::showKnowledge))).then(((LiteralArgumentBuilder)SubCommand.SET.literal().executes(this::showUsage)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(this::setKnowledge)))).then(((LiteralArgumentBuilder)SubCommand.GIVE.literal().executes(this::showUsage)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(this::giveKnowledge)))).then(((LiteralArgumentBuilder)SubCommand.REMOVE.literal().executes(this::showUsage)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(this::removeKnowledge)))).then(SubCommand.RESET_ANKH.literal().executes(this::resetAnkhCooldown)));
        return builder;
    }

    private int showKnowledge(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_SHOW_KNOWLEDGE.getText(StyleType.MESSAGE_SPELL, new Object[]{target.m_7755_(), cap.getKnowledge()}), false));
        return 1;
    }

    private int setKnowledge(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        int newKnowledge = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (newKnowledge < 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        int oldKnowledge = target.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getKnowledge).orElse(0);
        int adjust = newKnowledge - oldKnowledge;
        if (adjust >= 0) {
            this.increaseKnowledge((CommandSourceStack)ctx.getSource(), target, adjust);
        } else {
            this.decreaseKnowledge((CommandSourceStack)ctx.getSource(), target, Math.abs(adjust));
        }
        return 1;
    }

    private int giveKnowledge(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (amount <= 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        this.increaseKnowledge((CommandSourceStack)ctx.getSource(), target, amount);
        return 1;
    }

    private int removeKnowledge(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (amount <= 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        this.decreaseKnowledge((CommandSourceStack)ctx.getSource(), target, amount);
        return 1;
    }

    private void increaseKnowledge(CommandSourceStack source, ServerPlayer target, int amount) {
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(target, amount, 0));
        if (!target.equals((Object)source.m_81373_()) || !PlayerPreference.get(target.m_142081_()).displayKnowledgeMessage()) {
            this.sendMessage(source, LangKey.MESSAGE_EARN_KNOWLEDGE.getText(LangKey.MESSAGE_PLAYER_KNOWLEDGE.getText(target.m_7755_()), amount), false);
        }
    }

    private void decreaseKnowledge(CommandSourceStack source, ServerPlayer target, int amount) {
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.loseKnowledge(target, amount));
        if (!target.equals((Object)source.m_81373_()) || !PlayerPreference.get(target.m_142081_()).displayKnowledgeMessage()) {
            this.sendMessage(source, LangKey.MESSAGE_LOSE_KNOWLEDGE.getText(StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_PLAYER_KNOWLEDGE.getText(target.m_7755_()), amount}), false);
        }
    }

    private int resetAnkhCooldown(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        CooldownHandler.INSTANCE.setCooldown(target, CooldownType.NEXT_PRAY, 0);
        this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_RESET_ANKH.getText(StyleType.MESSAGE_SPELL, new Object[]{target.m_7755_()}), false);
        return 1;
    }

    private static enum SubCommand implements ISubCommand
    {
        SHOW,
        SET,
        GIVE,
        REMOVE,
        RESET_ANKH;

    }
}

