/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.LevelResource;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.ThreadedBackup;
import ovh.corail.tombstone.registry.ModItems;

public class CommandTBReviveFamiliar
extends TombstoneCommand {
    private static final LevelResource SAVE_FOLDER = new LevelResource("tombstone/saved_familiars");

    public CommandTBReviveFamiliar(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbrevivefamiliar";
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::showUsage)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::reviveFamiliar));
    }

    private int reviveFamiliar(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Style style;
        LangKey langKey;
        ItemStack receptacle;
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        CommandTBReviveFamiliar.checkAlive((Entity)player);
        CommandTBReviveFamiliar.checkNotSpectator((Player)player);
        CompoundTag petTag = this.getLastSave((CommandSourceStack)ctx.getSource(), (Player)player);
        if (petTag != null) {
            receptacle = new ItemStack((ItemLike)ModItems.familiar_receptacle);
            receptacle.m_41784_().m_128365_("dead_pet", (Tag)petTag);
        } else {
            receptacle = InventoryHelper.findFirstInInventory((Player)player, ModItems.familiar_receptacle::containSoul);
        }
        if (receptacle.m_41619_()) {
            throw LangKey.MESSAGE_NO_SAVE_TO_RESTORE.asCommandException(new Object[0]);
        }
        if (ModItems.familiar_receptacle.revive((Player)player, player.m_142538_(), receptacle)) {
            langKey = LangKey.MESSAGE_BRING_BACK_TO_LIFE;
            style = StyleType.MESSAGE_SPELL;
        } else {
            langKey = LangKey.MESSAGE_CANT_REVIVE_FAMILIAR;
            style = StyleType.COLOR_OFF;
        }
        langKey.sendMessage((Player)player, style, new Object[]{LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])});
        if (!player.equals((Object)((CommandSourceStack)ctx.getSource()).m_81373_())) {
            this.sendMessage((CommandSourceStack)ctx.getSource(), langKey.getText(style, new Object[]{LangKey.MESSAGE_FAMILIAR_OF.getText(player.m_7755_())}), false);
        }
        receptacle.m_41774_(1);
        player.f_36095_.m_38946_();
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private CompoundTag getLastSave(CommandSourceStack sender, Player player) {
        File saveFolder = new File(sender.m_81377_().m_129843_(SAVE_FOLDER).toFile(), player.m_142081_().toString());
        if (!saveFolder.exists()) {
            return null;
        }
        File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
        if (saveFiles == null) return null;
        if (saveFiles.length == 0) {
            return null;
        }
        File file = Stream.of(saveFiles).max(File::compareTo).orElse(null);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            CompoundTag nbt = TagParser.m_129359_((String)reader.readLine());
            reader.close();
            if (nbt.m_128431_().isEmpty()) return null;
            file.delete();
            CompoundTag compoundTag = nbt;
            return compoundTag;
        }
        catch (CommandSyntaxException | IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveFamiliar(MinecraftServer server, UUID ownerId, CompoundTag tag, String saveName) {
        File saveFolder = new File(server.m_129843_(SAVE_FOLDER).toFile(), ownerId.toString());
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            ModTombstone.LOGGER.info("The backup folder for familiars cannot be created");
            return;
        }
        String dateString = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(new Date());
        File accessedFile = new File(saveFolder, dateString + "_" + saveName + ".save");
        ThreadedBackup.INSTANCE.queueBackup(() -> {
            block9: {
                try (FileWriter writer = new FileWriter(accessedFile);){
                    writer.write(tag.toString());
                    writer.close();
                    File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
                    if (matchingFiles == null || matchingFiles.length <= 5) break block9;
                    int diff = matchingFiles.length - 5;
                    Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                    int num = 0;
                    for (File file2 : matchingFiles) {
                        if (num >= diff) {
                            break;
                        }
                        file2.delete();
                        ++num;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        });
    }
}

