/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.registry.ModItems;

public class CommandTBShowLastGrave
extends TombstoneCommand {
    public CommandTBShowLastGrave(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbshowlastgrave";
    }

    @Override
    protected Predicate<CommandSourceStack> getInitialRequirement() {
        return p -> true;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::getLastGrave)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(this.defaultPermission)).executes(this::getLastGrave));
    }

    private int getLastGrave(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = this.defaultPermission.test((CommandSourceStack)ctx.getSource()) ? CommandTBShowLastGrave.getPlayerOrCommandSender(ctx, "player") : ((CommandSourceStack)ctx.getSource()).m_81375_();
        Location lastGrave = DeathHandler.INSTANCE.getLastGrave(((CommandSourceStack)ctx.getSource()).m_81377_(), target);
        if (lastGrave.isOrigin()) {
            lastGrave = ModItems.grave_key.getTombPos(InventoryHelper.findFirstInInventory((Player)target, ModItems.grave_key));
        }
        if (lastGrave.isOrigin()) {
            throw LangKey.MESSAGE_NO_GRAVE.asCommandException(new Object[0]);
        }
        this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_LAST_GRAVE_PLACE.getText(target.m_36316_().getName(), LangKey.MESSAGE_LAST_GRAVE.getText(new Object[0]), lastGrave.x, lastGrave.y, lastGrave.z, lastGrave.getDimString()), false);
        return 1;
    }
}

