/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

abstract class TombstoneCommand {
    private final CommandDispatcher<CommandSourceStack> commandDispatcher;
    protected Predicate<CommandSourceStack> singlePlayerOwner = source -> {
        if (source.m_81377_().m_6982_()) return false;
        if (!source.m_81377_().m_129792_()) return false;
        if (Optional.ofNullable(source.m_81373_()).filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).map(Player::m_36316_).map(profil -> source.m_81377_().m_7779_(profil)).orElse(false) == false) return false;
        return true;
    };
    protected Predicate<CommandSourceStack> defaultPermission = source -> source.m_6761_(2) || this.singlePlayerOwner.test((CommandSourceStack)source);
    static final String PLAYER_PARAM = "player";
    static final String SOURCE_PARAM = "source";
    static final String TARGET_PARAM = "target";
    static final String BIOME_PARAM = "biome";
    static final String STRUCTURE_PARAM = "structure";
    static final String DIM_PARAM = "dim";
    static final String POS_PARAM = "pos";
    static final String AMOUNT_PARAM = "amount";
    static final SuggestionProvider<CommandSourceStack> SUGGESTION_STRUCTURE = (ctx, build) -> SharedSuggestionProvider.m_82926_((Iterable)ForgeRegistries.STRUCTURE_FEATURES.getKeys(), (SuggestionsBuilder)build);
    static final SuggestionProvider<CommandSourceStack> SUGGESTION_BIOME = (ctx, build) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)ctx.getSource()).m_81377_().m_129911_().m_6632_(Registry.f_122885_).map(Registry::m_6566_).orElse(Collections.emptySet()), (SuggestionsBuilder)build);
    static final SuggestionProvider<CommandSourceStack> AMOUNT_SUGGESTION = (ctx, build) -> build.suggest(1, () -> "[0-MAX]").buildFuture();

    public TombstoneCommand(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        this.commandDispatcher = commandDispatcher;
    }

    abstract String getName();

    protected Component getUsage() {
        return new TranslatableComponent("tombstone.command." + this.getName() + ".usage");
    }

    protected Predicate<CommandSourceStack> getInitialRequirement() {
        return this.defaultPermission;
    }

    int showUsage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_(this.getUsage(), false);
        return 1;
    }

    abstract LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> var1);

    public void registerCommand() {
        this.commandDispatcher.register(this.getBuilder((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.m_82127_((String)this.getName()).requires(this.getInitialRequirement()))));
    }

    static void checkAlive(Entity entity) {
        if (!entity.m_6084_()) {
            throw LangKey.MESSAGE_DEAD_ENTITY.asCommandException(new Object[0]);
        }
    }

    static void checkNotSpectator(Entity entity) {
        Entity entity2 = entity;
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            TombstoneCommand.checkNotSpectator(player);
        }
    }

    static void checkNotSpectator(Player player) {
        if (EntityHelper.isValidPlayer(player) && player.m_5833_()) {
            throw LangKey.MESSAGE_PLAYER_SPECTATOR.asCommandException(new Object[0]);
        }
    }

    static void checkValidPos(@Nullable Level level, BlockPos pos) {
        if (level != null && !Helper.isValidPos(level, pos)) {
            throw LangKey.MESSAGE_INVALID_LOCATION.asCommandException(new Object[0]);
        }
    }

    ServerLevel getOrThrowWorld(MinecraftServer server, ResourceKey<Level> dim) {
        ServerLevel level = server.m_129880_(dim);
        if (level == null) {
            throw LangKey.MESSAGE_NO_DIMENSION.asCommandException(new Object[0]);
        }
        return level;
    }

    Biome getOrThrowBiome(CommandContext<CommandSourceStack> context, String name) {
        return (Biome)((CommandSourceStack)context.getSource()).m_81377_().m_129911_().m_175515_(Registry.f_122885_).m_6612_((ResourceLocation)context.getArgument(name, ResourceLocation.class)).orElseThrow(() -> LangKey.MESSAGE_INVALID_BIOME.asCommandException(new Object[0]));
    }

    protected void sendMessage(CommandSourceStack source, MutableComponent message, boolean allowLogging) {
        source.m_81354_((Component)message.m_6270_(StyleType.TOOLTIP_DESC), allowLogging);
    }

    private static CommandExceptionType createCommandExceptionType(LangKey langKey) {
        return new SimpleCommandExceptionType((Message)langKey.getText(new Object[0]));
    }

    private static CommandExceptionType createDynamicCommandExceptionType(LangKey langKey) {
        return new DynamicCommandExceptionType(xva$0 -> langKey.getText(xva$0));
    }

    static ServerPlayer getPlayerOrCommandSender(CommandContext<CommandSourceStack> ctx, String label) throws CommandSyntaxException {
        try {
            EntityArgument.m_91474_(ctx, (String)label);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return ((CommandSourceStack)ctx.getSource()).m_81375_();
    }

    static int getInteger(CommandContext<CommandSourceStack> ctx, String label, int fallback) {
        try {
            return IntegerArgumentType.getInteger(ctx, (String)label);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return fallback;
        }
    }
}

