/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.compatibility.IEquipableCompat;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.Helper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CompatibilityCurio
implements IEquipableCompat {
    public static final CompatibilityCurio instance = new CompatibilityCurio();
    public final ResourceLocation BUNDLE_SLOT = new ResourceLocation("curios", "item/bundle_slot");
    @CapabilityInject(value=ICuriosItemHandler.class)
    public static final Capability<ICuriosItemHandler> INVENTORY = (Capability)Helper.unsafeNullCast();
    @CapabilityInject(value=ICurio.class)
    public static final Capability<ICurio> ITEM = (Capability)Helper.unsafeNullCast();

    private CompatibilityCurio() {
    }

    @Override
    public boolean autoEquip(ItemStack stack, Player player) {
        if (INVENTORY == null || ITEM == null) {
            return false;
        }
        Map map = player.getCapability(INVENTORY).map(ICuriosItemHandler::getCurios).orElse(null);
        if (map == null) {
            return false;
        }
        Set tags = CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_());
        for (String tag : tags) {
            ICurioStacksHandler stackHandler = (ICurioStacksHandler)map.get(tag);
            if (stackHandler == null) continue;
            IDynamicStackHandler dynamicStacks = stackHandler.getStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                if (!dynamicStacks.getStackInSlot(i).m_41619_() || !dynamicStacks.isItemValid(i, stack)) continue;
                dynamicStacks.setStackInSlot(i, stack.m_41777_());
                return true;
            }
        }
        return false;
    }

    public void sendIMC() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("bundle").icon(this.BUNDLE_SLOT).size(2).build());
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        public static void onStitchTextures(TextureStitchEvent.Pre event) {
            if (SupportMods.CURIOS.isLoaded() && event.getMap().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
                event.addSprite(CompatibilityCurio.instance.BUNDLE_SLOT);
            }
        }
    }
}

