/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    private static final ResourceLocation JEI_INTEGRATION_RL = new ResourceLocation("tombstone", "jei_integration");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return JEI_INTEGRATION_RL;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_key)));
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ImmutableList.Builder builder = ImmutableList.builder();
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        builder.add((Object)factory.createAnvilRecipe(new ItemStack((ItemLike)ModItems.grave_plate), Collections.singletonList(new ItemStack((ItemLike)Items.f_42416_)), Collections.singletonList(EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), Helper.getRandomThankName()))));
        ItemStack tablet = NBTStackHelper.setBoolean(new ItemStack((ItemLike)ModItems.tablet_of_assistance), "enchant", true);
        builder.add((Object)factory.createAnvilRecipe(tablet, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_dust)), Collections.singletonList(EngravableHelper.setEngravedName(tablet.m_41777_(), Helper.getRandomThankName()))));
        registry.addRecipes((Collection)builder.build(), VanillaRecipeCategoryUid.ANVIL);
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registration) {
        for (Block block : ModBlocks.DECORATIVE_GRAVES.values()) {
            registration.registerSubtypeInterpreter(block.m_5456_(), (stack, ctx) -> String.valueOf(ItemBlockGrave.getModelTexture(stack)));
        }
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_home, (stack, ctx) -> ModItems.tablet_of_home.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_recall, (stack, ctx) -> ModItems.tablet_of_recall.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter((Item)ModItems.grave_key, (stack, ctx) -> ModItems.grave_key.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
    }
}

