/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public class EnchantmentBlessing
extends ArmorEnchantment {
    private static final String BLESSING_LAST_PROC_NBT_LONG = "blessing_last_proc";

    public EnchantmentBlessing() {
        super("blessing", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.HEAD, EquipmentSlot.FEET);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentBlessing.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.blessingEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    protected void onWearerHit(LivingEntity wearer, Entity attacker, int level) {
        int delay = TimeHelper.tickFromSecond(10);
        int count = Math.min((int)Arrays.stream(this.f_44671_).map(arg_0 -> ((LivingEntity)wearer).m_6844_(arg_0)).filter(stack -> EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)stack) > 0).count(), 4);
        if (count > 0) {
            boolean valid;
            CompoundTag persistantData = wearer.getPersistentData();
            boolean bl = valid = !persistantData.m_128425_(BLESSING_LAST_PROC_NBT_LONG, 4);
            if (!valid) {
                long timeLeft = persistantData.m_128454_(BLESSING_LAST_PROC_NBT_LONG) - (long)wearer.f_19797_;
                if (timeLeft < 0L) {
                    persistantData.m_128473_(BLESSING_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.m_128356_(BLESSING_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
                }
            }
            if (valid && wearer.m_21187_().nextFloat() < 0.1f * (float)count) {
                MobEffectInstance effect = EffectHelper.getRandomEffect(TimeHelper.tickFromSecond(30), false, true, i -> wearer.m_21187_().nextInt(count + 1));
                EffectHelper.addEffect(wearer, effect);
                persistantData.m_128356_(BLESSING_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
            }
        }
    }

    @Override
    public boolean isInBeta() {
        return true;
    }

    @Override
    public int m_6586_() {
        return 1;
    }

    @Override
    public boolean hasUniqueLevel() {
        return true;
    }
}

