/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmlclient.registry.ClientRegistry;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.GuiKnowledge;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModParticleTypes;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static final KeyMapping keybindKnowledge = new KeyMapping(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "Corail Tombstone");
    private static boolean hasTrueSight;
    private static boolean isFirstGuiGameOver;
    private static boolean requireRemovalNightVision;
    private static boolean requireRemovalVisibility;
    private static boolean delayedGui;
    private static long nextGhostTime;
    private static final Set<UUID> REQUIRE_MASK_REMOVAL;
    private static final List<Aura> AURAS;
    private static final ResourceLocation[] AURA_TEXTURES;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onClientChatEvent(ClientChatEvent event) {
        if ("/tbgui".equals(event.getMessage())) {
            delayedGui = true;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static <T extends LivingEntity> void onRenderCreatureEvent(RenderLivingEvent.Pre<T, EntityModel<T>> event) {
        if (hasTrueSight && event.getEntity().m_20177_((Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_)) && event.getEntity().m_20145_()) {
            event.getEntity().m_6842_(false);
            requireRemovalVisibility = true;
        }
        if (((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue() && !event.getEntity().m_20145_()) {
            Aura.addAura(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderCreatureEvent(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        if (requireRemovalVisibility) {
            event.getEntity().m_6842_(true);
            requireRemovalVisibility = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (EntityHelper.isValidPlayer((Player)player)) {
            if (event.phase == TickEvent.Phase.START) {
                boolean bl = hasTrueSight = EffectHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape, 4) || EffectHelper.isPotionActive((LivingEntity)player, ModEffects.true_sight) || EffectHelper.isPotionActive((LivingEntity)player, ModEffects.aquatic_life) && Minecraft.m_91087_().f_91063_.m_109153_().m_167685_() == FogType.WATER;
                if (hasTrueSight && !EffectHelper.isPotionActive((LivingEntity)player, MobEffects.f_19611_)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 1200, 0, true, false));
                    requireRemovalNightVision = true;
                }
            } else if (requireRemovalNightVision) {
                player.m_6234_(MobEffects.f_19611_);
                requireRemovalNightVision = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.m_91104_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && EntityHelper.isValidPlayer((Player)mc.f_91074_)) {
            if ((keybindKnowledge.m_90859_() || delayedGui) && (mc.f_91080_ == null || mc.f_91080_ instanceof ChatScreen)) {
                mc.f_91074_.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                    delayedGui = false;
                    mc.m_91152_((Screen)new GuiKnowledge(mc.f_91074_, (ITBCapability)cap));
                });
            }
            if (((Boolean)ConfigTombstone.client.enableHalloweenEffect.get()).booleanValue() && TimeHelper.isDateAroundHalloween()) {
                if (Helper.isNight((Level)mc.f_91073_)) {
                    long time = TimeHelper.worldTicks((Level)mc.f_91073_);
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && CooldownHandler.INSTANCE.noCooldown((Player)mc.f_91074_, CooldownType.NEXT_PRAY)) {
                            Vec3 ghostVec = mc.f_91074_.m_20182_().m_82520_(Helper.getRandom(-9.0, 9.0), 0.0, Helper.getRandom(-9.0, 9.0));
                            mc.f_91061_.m_107370_((ParticleOptions)ModParticleTypes.GHOST, ghostVec.f_82479_, ghostVec.f_82480_, ghostVec.f_82481_, 0.0, 0.0, 0.0);
                        }
                        nextGhostTime = time + (long)Helper.getRandom(60, 6000);
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(GuiOpenEvent event) {
        LocalPlayer player;
        if (event.getGui() instanceof DeathScreen && ((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue() && (player = Minecraft.m_91087_().f_91074_) != null && !player.f_19853_.m_6106_().m_5466_()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.m_7583_();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        FluidState fluidState;
        boolean isWater;
        if (hasTrueSight && ((isWater = (fluidState = event.getInfo().getBlockAtCamera().m_60819_()).m_76153_((Tag)FluidTags.f_13131_)) || fluidState.m_76153_((Tag)FluidTags.f_13132_))) {
            event.setCanceled(true);
            event.setDensity(192.0f * (isWater ? 4.0f : 0.0625f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (hasTrueSight) {
            FluidState fluidState = event.getInfo().getBlockAtCamera().m_60819_();
            if (fluidState.m_76153_((Tag)FluidTags.f_13131_)) {
                event.setRed(0.09f);
                event.setGreen(0.42f);
                event.setBlue(0.93f);
            } else if (fluidState.m_76153_((Tag)FluidTags.f_13132_)) {
                event.setRed(1.0f);
                event.setGreen(0.32f);
                event.setBlue(0.09f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if (hasTrueSight && (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER || event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(GuiScreenEvent.DrawScreenEvent event) {
        if (requireRemovalNightVision) {
            Optional.ofNullable(Minecraft.m_91087_().f_91074_).ifPresent(p -> p.m_6234_(MobEffects.f_19611_));
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (Optional.ofNullable(event.getPlayer()).map(p -> p.f_19853_).isEmpty()) {
            return;
        }
        if (event.getItemStack().m_41720_() == Items.f_151058_) {
            event.getToolTip().add(1, new TranslatableComponent("tombstone.item.enchanted_bundle.desc").m_6270_(StyleType.TOOLTIP_USE));
        }
        if (!SupportMods.ENCH_DESC.isLoaded() && ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue() && event.getItemStack().m_41782_()) {
            boolean isEnchantedBook;
            boolean bl = isEnchantedBook = event.getItemStack().m_41720_() == Items.f_42690_;
            if (!isEnchantedBook && ModEnchantments.getEnchantments().values().stream().allMatch(TombstoneEnchantment::isEnabled)) {
                return;
            }
            ListTag taglist = isEnchantedBook ? EnchantedBookItem.m_41163_((ItemStack)event.getItemStack()) : event.getItemStack().m_41785_();
            List list = IntStream.range(0, taglist.size()).mapToObj(arg_0 -> ((ListTag)taglist).m_128728_(arg_0)).map(nbt -> nbt.m_128461_("id")).filter(id -> !id.isEmpty() && ModEnchantments.getEnchantments().containsKey(id)).map(ModEnchantments.getEnchantments()::get).collect(Collectors.toList());
            for (TombstoneEnchantment enchant : list) {
                IntStream.range(0, event.getToolTip().size()).filter(line -> {
                    Component currentTooltip = (Component)event.getToolTip().get(line);
                    return currentTooltip instanceof TranslatableComponent && enchant.m_44704_().equals(((TranslatableComponent)currentTooltip).m_131328_());
                }).findFirst().ifPresent(line -> {
                    List<Component> infos = enchant.getTooltipInfos(isEnchantedBook);
                    for (Component info : infos) {
                        event.getToolTip().add(++line, info);
                    }
                });
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!REQUIRE_MASK_REMOVAL.contains(event.getPlayer().m_142081_()) && (EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangibilityActive((LivingEntity)event.getPlayer())) && !(Minecraft.m_91087_().f_91080_ instanceof AbstractContainerScreen)) {
            REQUIRE_MASK_REMOVAL.add(event.getPlayer().m_142081_());
            GlStateManager.m_84300_((boolean)true, (boolean)false, (boolean)false, (boolean)true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        if (REQUIRE_MASK_REMOVAL.remove(event.getPlayer().m_142081_())) {
            GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        Location location;
        if (!((Boolean)ConfigTombstone.client.highlight.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (Optional.ofNullable(player).map(p -> p.f_19853_).isEmpty()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() == ModItems.grave_key) {
            location = ModItems.grave_key.getTombPos(stack);
        } else if (stack.m_41720_() == ModItems.tablet_of_recall) {
            location = ModItems.tablet_of_recall.getTombPos(stack);
        } else if (ModItems.lost_tablet.isWakeUp(stack)) {
            location = ModItems.lost_tablet.getLocation(stack);
        } else {
            return;
        }
        if (location.isOrigin() || !location.isSameDimension(player.f_19853_)) {
            return;
        }
        ClientEventHandler.createBox(mc, event.getMatrixStack(), location.x, location.y, location.z);
    }

    private static void createBox(Minecraft mc, PoseStack poseStack, double x, double y, double z) {
        RenderSystem.m_69393_(RenderSystem::m_69586_);
        GlStateManager.m_84507_();
        GlStateManager.m_84298_((boolean)false);
        GlStateManager.m_84094_();
        GlStateManager.m_84110_();
        GlStateManager.m_84519_();
        float[] colors = Helper.getHSBtoRGBF((float)(TimeHelper.systemTime() / 15L % 360L) / 360.0f, 1.0f, 1.0f);
        poseStack.m_85836_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        Vec3 vec = new Vec3(x, y, z).m_82546_(mc.f_91063_.m_109153_().m_90583_());
        if (vec.m_82553_() > 200.0) {
            vec = vec.m_82541_().m_82490_(200.0);
        }
        Vec3 vec1 = new Vec3(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        Vec3 vec2 = new Vec3(vec.f_82479_ + 1.0, vec.f_82480_ + 1.0, vec.f_82481_ + 1.0);
        RenderSystem.m_69832_((float)2.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172757_);
        bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec1.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec2.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec1.f_82480_, vec2.f_82481_, colors);
        ClientEventHandler.makeVertex(bufferbuilder, poseStack.m_85850_(), vec1.f_82479_, vec2.f_82480_, vec2.f_82481_, colors);
        tesselator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.m_69832_((float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
        GlStateManager.m_84091_();
        GlStateManager.m_84298_((boolean)true);
        GlStateManager.m_84513_();
    }

    private static void makeVertex(BufferBuilder bufferbuilder, PoseStack.Pose pose, double x, double y, double z, float[] colors) {
        bufferbuilder.m_85982_(pose.m_85861_(), (float)x, (float)y, (float)z).m_85950_(colors[0], colors[1], colors[2], 1.0f).m_85977_(pose.m_85864_(), 1.0f, 1.0f, 1.0f).m_5752_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderAuras(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON && mc.f_91074_ != null && ((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue()) {
            Aura.addAura((LivingEntity)mc.f_91074_);
        }
        if (!AURAS.isEmpty()) {
            double ratio = (double)System.currentTimeMillis() * 0.03 % 360.0;
            AURAS.forEach(aura -> ClientEventHandler.renderAura(mc, event.getMatrixStack(), aura, ratio));
            AURAS.clear();
        }
    }

    private static void renderAura(Minecraft mc, PoseStack poseStack, Aura aura, double ratio) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_69464_();
        RenderSystem.m_157427_(GameRenderer::m_172835_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AURA_TEXTURES[0]);
        Vec3 vec3 = aura.position.m_82546_(mc.f_91063_.m_109153_().m_90583_());
        poseStack.m_85836_();
        poseStack.m_85837_((double)((float)vec3.f_82479_), (double)((float)vec3.f_82480_), (double)((float)vec3.f_82481_));
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_((float)ratio));
        poseStack.m_85837_((double)((float)(-vec3.f_82479_)), (double)((float)(-vec3.f_82480_)), (double)((float)(-vec3.f_82481_)));
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        Vec3 vec1 = new Vec3(vec3.f_82479_ - aura.auraType.radius, vec3.f_82480_ + 0.014625, vec3.f_82481_ - aura.auraType.radius);
        Vec3 vec2 = new Vec3(vec3.f_82479_ + aura.auraType.radius, vec3.f_82480_ + 0.014625, vec3.f_82481_ + aura.auraType.radius);
        RenderSystem.m_157427_(GameRenderer::m_172835_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        bufferbuilder.m_85982_(matrix, (float)vec1.f_82479_, (float)vec1.f_82480_, (float)vec1.f_82481_).m_85950_(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)vec1.f_82479_, (float)vec1.f_82480_, (float)vec2.f_82481_).m_85950_(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)vec2.f_82479_, (float)vec1.f_82480_, (float)vec2.f_82481_).m_85950_(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)vec2.f_82479_, (float)vec1.f_82480_, (float)vec1.f_82481_).m_85950_(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        tesselator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.m_69481_();
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        ClientRegistry.registerKeyBinding((KeyMapping)keybindKnowledge);
        hasTrueSight = false;
        isFirstGuiGameOver = false;
        requireRemovalNightVision = false;
        requireRemovalVisibility = false;
        delayedGui = false;
        nextGhostTime = -1L;
        REQUIRE_MASK_REMOVAL = ConcurrentHashMap.newKeySet();
        AURAS = new ArrayList<Aura>();
        AURA_TEXTURES = new ResourceLocation[]{new ResourceLocation("tombstone", "textures/aura/aura1.png")};
    }

    private static class Aura {
        private final Vec3 position;
        private final AuraType auraType;

        private Aura(LivingEntity entity, AuraType auraType) {
            float partialTicks = Minecraft.m_91087_().m_91296_();
            this.position = new Vec3(Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_()), Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_()) + 0.1111, Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_()));
            this.auraType = auraType;
        }

        private Aura(double x, double y, double z) {
            this.position = new Vec3(x, y, z);
            this.auraType = AuraType.MARKER;
        }

        private static void addAura(LivingEntity entity) {
            AuraType auraType = AuraType.getAuraType(entity);
            if (auraType != null) {
                Aura aura = new Aura(entity, auraType);
                double opaque = 1.0;
                double distanceToCamera = Minecraft.m_91087_().m_91290_().m_114378_(aura.position.f_82479_, aura.position.f_82480_, aura.position.f_82481_);
                double f = (1.0 - distanceToCamera * 0.00390625) * opaque;
                if (f > 0.0) {
                    AURAS.add(aura);
                }
            }
        }
    }

    static enum AuraType {
        PRAY(3.5, 0.88f, 0.78f, 0.48f, 1.0f),
        SCROLL(0.8, 0.38f, 0.28f, 0.88f, 1.0f),
        SIMPLE_TELEPORT(0.8, 0.23f, 0.78f, 0.86f, 1.0f),
        AREA_TELEPORT(5.0, 0.23f, 0.78f, 0.86f, 1.0f),
        MARKER(1.0, 0.38f, 0.48f, 0.18f, 1.0f);

        private final double radius;
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        private AuraType(double radius, float r, float g, float b, float a) {
            this.radius = radius;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        private static AuraType getAuraType(LivingEntity entity) {
            if (!entity.m_6117_()) {
                return null;
            }
            ItemStack heldStack = entity.m_21205_();
            Item heldItem = heldStack.m_41720_();
            if (heldItem == ModItems.ankh_of_pray) {
                return PRAY;
            }
            if (heldItem == ModItems.grave_key || heldItem == ModItems.lost_tablet || heldItem == ModItems.tablet_of_assistance || heldItem == ModItems.tablet_of_cupidity) {
                return SIMPLE_TELEPORT;
            }
            if (heldItem == ModItems.tablet_of_recall || heldItem == ModItems.tablet_of_home) {
                return ((ItemGraveMagic)heldStack.m_41720_()).isAncient(heldStack) ? AREA_TELEPORT : SIMPLE_TELEPORT;
            }
            if (ModItems.scroll_buff.containsValue(heldItem) || heldItem == ModItems.scroll_of_knowledge) {
                return SCROLL;
            }
            return null;
        }
    }
}

