/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.GuiConfig;
import ovh.corail.tombstone.gui.GuiInfo;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpgradePerkServerMessage;
import ovh.corail.tombstone.perk.PerkRegistry;

@OnlyIn(value=Dist.CLIENT)
public class GuiKnowledge
extends TBScreen {
    private static final ResourceLocation GUI_BAR = new ResourceLocation("minecraft", "textures/gui/bars.png");
    private final LocalPlayer player;
    private final ITBCapability cap;
    private final int iconSize = 16;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private int hoveredPerkLevel = 0;
    private final ItemStack stackSkull = new ItemStack((ItemLike)ItemAdvancement.IconType.FIRST_KNOWLEDGE.getItem());
    private final ItemStack stackRevive = new ItemStack((ItemLike)ItemAdvancement.IconType.REVIVE.getItem());
    private final ItemStack stackAnkh = new ItemStack((ItemLike)ItemAdvancement.IconType.FIRST_PRAY.getItem());
    private final double alignmentPos;

    public GuiKnowledge(LocalPlayer player, ITBCapability cap) {
        super((Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]));
        this.player = player;
        this.cap = cap;
        for (Perk perk : PerkRegistry.perkRegistry.getValues()) {
            if (Helper.isDisabledPerk(perk, (Player)player)) continue;
            this.icons.add(new PerkIcon(perk));
        }
        this.alignmentPos = this.getBarRatio();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft + 15;
        int y = this.guiTop + 72;
        int i = 0;
        int spaceForIcon = this.icons.size() > 12 ? 22 : 31;
        int maxIconByLine = this.icons.size() > 12 ? 8 : 6;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setPosition(x + caseX * spaceForIcon, y);
            if (caseX == maxIconByLine - 1) {
                y += 30;
            }
            ++i;
        }
        this.m_142416_((GuiEventListener)new CustomButton(this.guiLeft + 10, this.guiBottom - 25, 70, 15, (Component)new TranslatableComponent("tombstone.compendium.main.title"), pressable -> this.getMinecraft().m_91152_((Screen)new GuiInfo(null))));
        this.m_142416_((GuiEventListener)new CustomButton(this.guiRight - 10 - 70, this.guiBottom - 25, 70, 15, (Component)LangKey.BUTTON_CONFIG.getText(new Object[0]), pressable -> this.getMinecraft().m_91152_((Screen)new GuiConfig())));
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.hoveredIcon != null) {
            if (mouseButton == 0) {
                int perkLevel = this.cap.getPerkLevel((Player)this.player, this.hoveredIcon.perk);
                if (perkLevel < this.hoveredIcon.perk.getLevelMax() && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                    return true;
                }
            } else if (mouseButton == 1 && this.player.m_7500_() && this.cap.getPerkLevel((Player)this.player, this.hoveredIcon.perk) > 0) {
                PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        String eventString;
        this.m_7333_(poseStack);
        this.hoveredIcon = this.icons.stream().filter(p -> p.contains(mouseX, mouseY)).findFirst().orElse(null);
        int totalPerkPoints = this.cap.getTotalPerkPoints();
        int usedPerkPoints = this.cap.getUsedPerkPoints((Player)this.player);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Objects.requireNonNull(this);
        this.m_93154_(poseStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 4, -1);
        Objects.requireNonNull(this);
        this.m_93154_(poseStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 6, -1);
        MutableComponent mutableComponent = LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]);
        Objects.requireNonNull(this);
        GuiKnowledge.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)mutableComponent, (int)this.halfWidth, (int)(this.guiTop + 9), (int)-1);
        Objects.requireNonNull(this);
        this.m_93154_(poseStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 18, -1);
        Objects.requireNonNull(this);
        this.m_93154_(poseStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 20, -1);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BAR);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiKnowledge.m_93133_((PoseStack)poseStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)40.0f, (int)182, (int)5, (int)182, (int)256);
        GuiKnowledge.m_93133_((PoseStack)poseStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)45.0f, (int)((int)(129.22 * (double)(this.cap.getKnowledge() - this.cap.getKnowledgeForLevel(totalPerkPoints)) / (double)this.cap.getKnowledgeToReachNextLevel(totalPerkPoints + 1))), (int)5, (int)182, (int)256);
        GuiKnowledge.m_93133_((PoseStack)poseStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 31), (float)0.0f, (float)101.0f, (int)182, (int)3, (int)182, (int)256);
        int startAlignmentY = 44;
        GuiKnowledge.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Alignment", (int)this.halfWidth, (int)(this.guiTop + startAlignmentY - 4), (int)-1);
        GuiKnowledge.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 20), (int)(this.guiTop + startAlignmentY + 10), (int)(this.guiRight - 20), (int)(this.guiTop + startAlignmentY + 17), (int)-16777216);
        Helper.fillGradient(matrix, this.guiLeft + 21, this.guiTop + startAlignmentY + 11, this.halfWidth, this.guiTop + startAlignmentY + 16, -65536, -1, this.m_93252_(), true);
        Helper.fillGradient(matrix, this.halfWidth, this.guiTop + startAlignmentY + 11, this.guiRight - 21, this.guiTop + startAlignmentY + 16, -1, -16776961, this.m_93252_(), true);
        Objects.requireNonNull(this);
        float step = (float)(200 - 42) / 8.0f;
        for (int i = 0; i < 8; ++i) {
            if (i == 4) continue;
            this.m_93222_(poseStack, this.guiLeft + 21 + (int)((float)i * step), this.guiTop + startAlignmentY + 10, this.guiTop + startAlignmentY + 16, -16777216);
        }
        this.f_96542_.m_115203_(this.stackSkull, this.guiLeft + 10, this.guiTop + startAlignmentY + 5);
        this.f_96542_.m_115203_(this.stackRevive, this.guiRight - 10 - 16, this.guiTop + startAlignmentY + 5);
        Objects.requireNonNull(this);
        int adjust = (int)Math.round((double)(200 - 42) / 2.0 * this.alignmentPos);
        this.f_96542_.m_115203_(this.stackAnkh, this.halfWidth + adjust - 8, this.guiTop + startAlignmentY + 4);
        String levelString = this.leftPerkPoints + " / " + totalPerkPoints;
        float f = this.guiLeft + 48 - this.f_96547_.m_92895_(levelString);
        float f2 = this.guiTop + 28;
        Objects.requireNonNull(this);
        this.f_96547_.m_92883_(poseStack, levelString, f, f2, -1);
        for (PerkIcon icon : this.icons) {
            this.drawPerk(poseStack, icon);
        }
        if (Helper.isContributor((Player)this.player)) {
            float f3 = this.guiLeft + 30;
            float f4 = this.guiBottom - 45;
            Objects.requireNonNull(this);
            this.f_96547_.m_92883_(poseStack, "Special Bonus", f3, f4, -7918643);
        }
        String string = TimeHelper.isDateAroundHalloween() ? "Halloween" : (eventString = TimeHelper.isAprilFoolsDay() ? "April Fools Day" : null);
        if (eventString != null) {
            float f5 = this.guiRight - 30 - this.f_96547_.m_92895_(eventString);
            float f6 = this.guiBottom - 45;
            Objects.requireNonNull(this);
            this.f_96547_.m_92883_(poseStack, eventString, f5, f6, -7918643);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.drawPerkTooltip(poseStack);
    }

    private double getBarRatio() {
        boolean isPositive = this.cap.getAlignmentValue() >= 0;
        int alignement = Math.abs(Mth.m_14045_((int)this.cap.getAlignmentValue(), (int)this.cap.getAlignmentMinValue(), (int)this.cap.getAlignmentMaxValue()));
        double ratio = alignement > 300 ? 0.75 + 0.25 * (double)(alignement - 300) * 0.005 : (alignement > 150 ? 0.5 + 0.25 * (double)(alignement - 150) / 150.0 : (alignement > 50 ? 0.25 + 0.25 * (double)(alignement - 50) * 0.01 : 0.25 * (double)alignement * 0.02));
        return isPositive ? ratio : -ratio;
    }

    private void drawPerk(PoseStack poseStack, PerkIcon icon) {
        int n;
        int levelWithBonus = this.cap.getPerkLevelWithBonus((Player)this.player, icon.perk);
        boolean isHovered = icon.equals(this.hoveredIcon);
        boolean isMax = this.cap.getPerkLevel((Player)this.player, icon.perk) == icon.perk.getLevelMax();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiKnowledge.m_93172_((PoseStack)poseStack, (int)(icon.getMinX() - 1), (int)(icon.getMinY() - 1), (int)(icon.getMaxX() + 1), (int)(icon.getMaxY() + 1 + 10), (int)-15329733);
        if (isHovered) {
            int n2;
            if (isMax) {
                Objects.requireNonNull(this);
                n2 = -1980292;
            } else {
                n2 = -7096363;
            }
            int color = n2;
            this.m_93154_(poseStack, icon.minX - 2, icon.maxX + 1, icon.minY - 2, color);
            this.m_93154_(poseStack, icon.minX - 2, icon.maxX + 1, icon.minY + 27, color);
            this.m_93222_(poseStack, icon.minX - 2, icon.minY - 2, icon.minY + 27, color);
            this.m_93222_(poseStack, icon.minX + 17, icon.minY - 2, icon.minY + 27, color);
        }
        if (levelWithBonus == 0 && !isHovered) {
            RenderSystem.m_157429_((float)0.13f, (float)0.13f, (float)0.13f, (float)0.5f);
            this.m_93179_(poseStack, icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -13421773, -13421773);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93179_(poseStack, icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -16703669, -7096363);
        }
        ResourceLocation texture = icon.perk.getIcon();
        if (texture != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
            float visibility = levelWithBonus == 0 && !isHovered ? 0.13f : 1.0f;
            RenderSystem.m_157429_((float)visibility, (float)visibility, (float)visibility, (float)visibility);
            GuiKnowledge.m_93133_((PoseStack)poseStack, (int)icon.getMinX(), (int)icon.getMinY(), (float)0.0f, (float)0.0f, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize);
        }
        boolean hasBonus = icon.perk.getLevelBonus((Player)this.player) != 0;
        String string = "" + levelWithBonus;
        float f = (float)icon.getMinX() + (levelWithBonus > 9 ? 2.5f : 5.5f);
        float f2 = icon.getMinY() + 18;
        if (hasBonus) {
            Objects.requireNonNull(this);
            n = -7918643;
        } else if (isMax) {
            Objects.requireNonNull(this);
            n = -1980292;
        } else if (levelWithBonus > 0) {
            Objects.requireNonNull(this);
            n = -12562177;
        } else {
            Objects.requireNonNull(this);
            n = -8355712;
        }
        this.f_96547_.m_92883_(poseStack, string, f, f2, n);
    }

    private void drawPerkTooltip(PoseStack poseStack) {
        if (this.hoveredIcon != null) {
            this.hoveredPerkLevel = this.cap.getPerkLevel((Player)this.player, this.hoveredIcon.perk);
            int levelWithBonus = this.cap.getPerkLevelWithBonus((Player)this.player, this.hoveredIcon.perk);
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(this.hoveredIcon.perk.getTranslation().m_6879_().m_130948_(StyleType.MESSAGE_SPECIAL));
            Component specialInfo = this.hoveredIcon.perk.getSpecialInfo(levelWithBonus);
            if (specialInfo != TextComponent.f_131282_) {
                list.add(specialInfo.m_6879_().m_130948_(StyleType.INFO));
            }
            IntStream.rangeClosed(1, this.hoveredIcon.perk.getLevelMax()).forEach(i -> {
                Component info = this.hoveredIcon.perk.getTooltip(i, this.hoveredPerkLevel, levelWithBonus);
                if (info != TextComponent.f_131282_) {
                    ChatFormatting formatting = this.hoveredPerkLevel >= i ? ChatFormatting.WHITE : ((this.hoveredIcon.perk.isEncrypted() ? levelWithBonus >= i : levelWithBonus == i) ? ChatFormatting.DARK_PURPLE : ChatFormatting.DARK_GRAY);
                    boolean isEncrypted = this.hoveredIcon.perk.isEncrypted() && levelWithBonus < i - 1;
                    list.add(new TextComponent(i + " -> ").m_7220_((Component)(isEncrypted ? info.m_6879_().m_6270_(SupportMods.RUNELIC.isLoaded() ? StyleType.RUNELIC : StyleType.STANDARD_GALACTIC) : info)).m_130940_(formatting));
                }
            });
            if (this.hoveredPerkLevel < this.hoveredIcon.perk.getLevelMax()) {
                int cost = this.hoveredIcon.perk.getCost(this.hoveredPerkLevel + 1);
                boolean canUpgrade = this.leftPerkPoints >= cost;
                list.add(LangKey.MESSAGE_COST.getText(canUpgrade ? ChatFormatting.AQUA : ChatFormatting.RED, new Object[]{cost}));
                list.add(canUpgrade ? LangKey.MESSAGE_CLICK_TO_UPGRADE.getText(ChatFormatting.BLUE, new Object[0]) : LangKey.MESSAGE_CANT_UPGRADE.getText(ChatFormatting.RED, new Object[0]));
            } else {
                list.add(LangKey.MESSAGE_MAX.getText(ChatFormatting.GOLD, new Object[0]));
            }
            GuiUtils.drawHoveringText((PoseStack)poseStack, list, (int)(this.hoveredIcon.minX + 10), (int)(this.hoveredIcon.minY + 10), (int)this.f_96543_, (int)this.f_96544_, (int)200, (Font)this.f_96547_);
        }
    }

    public class PerkIcon {
        public final Perk perk;
        int minX;
        int minY;
        int maxX;
        int maxY;

        PerkIcon(Perk perk) {
            this.perk = perk;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        boolean contains(double x, double y) {
            return x >= (double)this.minX && y >= (double)this.minY && x <= (double)this.maxX && y <= (double)(this.maxY + 10);
        }

        int getMinX() {
            return this.minX;
        }

        int getMinY() {
            return this.minY;
        }

        int getMaxX() {
            return this.maxX;
        }

        int getMaxY() {
            return this.maxY;
        }
    }
}

